/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.internal;

import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class BrewingQuest
extends ActionContainer {
    private NamespacedKey key;
    private JavaPlugin plugin;

    public BrewingQuest(JavaPlugin javaPlugin) {
        super(javaPlugin);
        this.plugin = javaPlugin;
        this.key = new NamespacedKey((Plugin)javaPlugin, "battlepass");
    }

    @EventHandler
    public void on(InventoryClickEvent inventoryClickEvent) {
        if (!(inventoryClickEvent.getInventory() instanceof BrewerInventory)) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        BrewerInventory brewerInventory = (BrewerInventory)inventoryClickEvent.getInventory();
        this.handleItem(player, inventoryClickEvent.getCurrentItem());
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            for (int i = 0; i < 3; ++i) {
                this.handleItem(player, brewerInventory.getItem(i));
            }
        });
    }

    private void handleItem(Player player, ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer persistentDataContainer = itemMeta.getPersistentDataContainer();
        if (persistentDataContainer.has(this.key, PersistentDataType.STRING)) {
            return;
        }
        PotionData potionData = this.getPotionData(itemStack);
        if (potionData == null) {
            return;
        }
        PotionType potionType = potionData.getType();
        boolean bl = potionData.isExtended();
        boolean bl2 = potionData.isUpgraded();
        this.executionBuilder("brew").player(player).root(potionType.toString().toLowerCase()).subRoot("isExtended", String.valueOf(bl)).subRoot("isUpgraded", String.valueOf(bl2)).progressSingle().buildAndExecute();
        persistentDataContainer.set(this.key, PersistentDataType.STRING, (Object)"claimed");
        itemStack.setItemMeta(itemMeta);
    }

    private PotionData getPotionData(ItemStack itemStack) {
        if (itemStack.getType() != Material.POTION) {
            return null;
        }
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        return potionMeta.getBasePotionData();
    }
}

