/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.internal;

import java.util.Map;
import java.util.function.UnaryOperator;
import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class EnchantQuests
extends ActionContainer {
    public EnchantQuests(JavaPlugin javaPlugin) {
        super(javaPlugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEnchant(EnchantItemEvent enchantItemEvent) {
        Player player = enchantItemEvent.getEnchanter();
        ItemStack itemStack = enchantItemEvent.getItem().clone();
        int n = enchantItemEvent.getExpLevelCost();
        Map map = enchantItemEvent.getEnchantsToAdd();
        for (Enchantment enchantment : map.keySet()) {
            String string = MinecraftVersion.isNew() ? this.getEnchantName(enchantment) : enchantment.getName();
            int n2 = (Integer)map.get(enchantment);
            this.executionBuilder("enchant").player(player).root(string).subRoot("level", String.valueOf(n2)).subRoot("cost", String.valueOf(n)).subRoot(itemStack).progress(1).buildAndExecute();
            this.executionBuilder("enchant-all").player(player).root(string).subRoot("level", String.valueOf(n2)).subRoot("cost", String.valueOf(n)).subRoot(itemStack).progress(1).buildAndExecute();
        }
    }

    @EventHandler
    public void onAnvil(PrepareAnvilEvent prepareAnvilEvent) {
    }

    @EventHandler(ignoreCancelled=true)
    public void onAnvilEnchant(InventoryClickEvent inventoryClickEvent) {
        if (!(inventoryClickEvent.getWhoClicked() instanceof Player) || !(inventoryClickEvent.getInventory() instanceof AnvilInventory) || inventoryClickEvent.getSlotType() != InventoryType.SlotType.RESULT || inventoryClickEvent.getClick() == ClickType.MIDDLE) {
            return;
        }
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        AnvilInventory anvilInventory = (AnvilInventory)inventoryClickEvent.getInventory();
        ItemStack itemStack = anvilInventory.getItem(1);
        if (itemStack == null || itemStack.getType() != Material.ENCHANTED_BOOK || inventoryClickEvent.getClick().toString().contains("SHIFT") && ASManager.getEmptySlotCountInInventory(player) < 1) {
            return;
        }
        if (player.getLevel() < anvilInventory.getRepairCost()) {
            return;
        }
        ItemStack itemStack2 = inventoryClickEvent.getCurrentItem();
        for (Map.Entry entry : ((EnchantmentStorageMeta)itemStack.getItemMeta()).getStoredEnchants().entrySet()) {
            String string = this.getEnchantName((Enchantment)entry.getKey());
            UnaryOperator unaryOperator = actionResult -> {
                actionResult.subRoot("level", String.valueOf(entry.getValue()));
                actionResult.subRoot(itemStack2);
                return actionResult.root(string);
            };
            this.executionBuilder("enchant-all").player(player).root(string).subRoot("level", String.valueOf(entry.getValue())).subRoot(itemStack2).progress(1).buildAndExecute();
            this.executionBuilder("enchant-anvil").player(player).root(string).subRoot("level", String.valueOf(entry.getValue())).subRoot(itemStack2).progress(1).buildAndExecute();
        }
    }

    private String getEnchantName(Enchantment enchantment) {
        if (MinecraftVersion.isNew()) {
            String string = enchantment.getKey().getKey();
            return string.startsWith("minecraft:") ? string.split("minecraft:")[1] : string;
        }
        return enchantment.getName();
    }
}

