/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.internal;

import net.advancedplugins.bp.impl.actions.containers.ActionContainer;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class MovementQuests
extends ActionContainer {
    private final boolean isNew = MinecraftVersion.isNew();

    public MovementQuests(JavaPlugin javaPlugin) {
        super(javaPlugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (playerMoveEvent.getFrom().getBlockX() == playerMoveEvent.getTo().getBlockX() && playerMoveEvent.getFrom().getBlockZ() == playerMoveEvent.getTo().getBlockZ()) {
            return;
        }
        Material material = player.getLocation().getBlock().getType();
        this.executionBuilder("move").player(player).progressSingle().buildAndExecute();
        if (material.toString().toLowerCase().contains("water") && !player.isInsideVehicle() && !player.isFlying()) {
            this.executionBuilder("swim").player(player).progressSingle().buildAndExecute();
            return;
        }
        if (this.isNew && player.isGliding()) {
            this.executionBuilder("glide").player(player).progressSingle().buildAndExecute();
        }
        if (player.isFlying() || this.isNew && player.isGliding()) {
            this.executionBuilder("fly").player(player).progressSingle().buildAndExecute();
            return;
        }
        if (player.isSneaking() || player.isSprinting()) {
            this.executionBuilder(player.isSneaking() ? "sneak" : "sprint").player(player).progressSingle().buildAndExecute();
        }
    }
}

