/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.actions.objects.variable;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.advancedplugins.bp.impl.actions.objects.variable.ActionResult;
import net.advancedplugins.bp.impl.actions.objects.variable.Variable;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Crops;
import org.jetbrains.annotations.NotNull;

public class ExecutableActionResult
implements ActionResult {
    private String root;
    private Map<String, String> subRoots = Maps.newHashMap();
    private String material;
    private byte data;

    @Override
    public ExecutableActionResult root(String string) {
        if (string == null) {
            return this;
        }
        this.root = string;
        return this;
    }

    @Override
    public ExecutableActionResult root(Block block) {
        if (block == null) {
            return this;
        }
        this.material = block.getType().toString();
        if (MinecraftVersion.isNew() ? block.getBlockData() instanceof Ageable : block.getState().getData() instanceof Crops) {
            this.data = block.getData();
        }
        return this;
    }

    @Override
    public ExecutableActionResult root(ItemStack itemStack) {
        if (itemStack == null) {
            return this;
        }
        this.material = itemStack.getType().toString();
        try {
            this.data = this.material.equalsIgnoreCase("COOKED_SALMON") ? (byte)0 : itemStack.getData().getData();
        }
        catch (Exception exception) {
            this.data = 0;
        }
        return this;
    }

    @Override
    public ExecutableActionResult subRoot(String string, String string2) {
        this.subRoots.put(string, string2);
        return this;
    }

    @Override
    public ActionResult subRoot(ItemStack itemStack) {
        this.subRoots.put("item", itemStack.getType().toString());
        return this;
    }

    @Override
    public ExecutableActionResult none() {
        this.root = "none";
        return this;
    }

    @Override
    public boolean isEligible(Player player, Variable variable) {
        if (this.areSubRootsValid(player, variable)) {
            for (String string : variable.getRoots()) {
                boolean bl = string.equalsIgnoreCase("none");
                if (bl) {
                    return true;
                }
                if (this.material == null) {
                    if (this.root == null || !this.root.equalsIgnoreCase(string)) continue;
                    return true;
                }
                for (ImmutablePair<String, Byte> immutablePair : variable.getMaterialRoots()) {
                    if (!this.material.equalsIgnoreCase((String)immutablePair.getKey()) || (Byte)immutablePair.getValue() >= 0 && this.data != (Byte)immutablePair.getValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String getEffectiveRoot() {
        return this.material == null || this.material.isEmpty() ? this.root : this.material + ":" + this.data;
    }

    @Override
    public Map<String, String> getSubRoots() {
        return this.subRoots;
    }

    private boolean areSubRootsValid(Player player, Variable variable) {
        Map<String, List<String>> map = variable.getSubRoots();
        return this.isNameSubRootValid(map) && this.isHeldItemSubRootValid(player, map) && this.areCustomSubRootsValid(map);
    }

    private boolean isNameSubRootValid(Map<String, List<String>> map) {
        return !map.containsKey("name") || this.subRoots.containsKey("name") && map.get("name").contains(this.subRoots.get("name"));
    }

    private String getItemAsConfigString(@NotNull ItemStack itemStack) {
        return itemStack.getType().toString().toLowerCase() + ":" + itemStack.getData().getData();
    }

    private boolean isHeldItemSubRootValid(Player player, Map<String, List<String>> map) {
        if (map.containsKey("holding.item")) {
            ItemStack itemStack = MinecraftVersion.getVersion().getVersionId() > 183 ? player.getInventory().getItemInMainHand() : player.getItemInHand();
            if (!(itemStack.getType().equals((Object)Material.AIR) ? "none" : this.getItemAsConfigString(itemStack)).equalsIgnoreCase(map.get("holding.item").get(0))) {
                return false;
            }
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (map.containsKey("holding.name") && Objects.nonNull(itemMeta) && !map.get("holding.name").get(0).equals(itemMeta.getDisplayName())) {
                return false;
            }
            return !map.containsKey("holding.amount") || Integer.parseInt(map.get("holding.amount").get(0)) == itemStack.getAmount();
        }
        return true;
    }

    private boolean areCustomSubRootsValid(Map<String, List<String>> map) {
        for (Map.Entry<String, String> entry : this.subRoots.entrySet()) {
            String string = entry.getKey();
            if (!map.containsKey(string)) continue;
            if (!this.subRoots.containsKey(string)) {
                return false;
            }
            if (map.get(string).contains(this.subRoots.get(string).toLowerCase())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.material == null) {
            return "QuestResult{root='" + this.root + '\'' + ", subRoots=" + this.subRoots + '}';
        }
        return "QuestResult{root='" + this.material + ":" + this.data + '\'' + ", subRoots=" + this.subRoots + '}';
    }
}

