/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.advancedplugins.bp.impl.utils.ColorUtils;
import net.advancedplugins.bp.impl.utils.CropUtils;
import net.advancedplugins.bp.impl.utils.MathUtils;
import net.advancedplugins.bp.impl.utils.SchedulerUtils;
import net.advancedplugins.bp.impl.utils.TryCatchMethodShort;
import net.advancedplugins.bp.impl.utils.configs.YamlFile;
import net.advancedplugins.bp.impl.utils.evalex.Expression;
import net.advancedplugins.bp.impl.utils.nbt.NBTapi;
import net.advancedplugins.bp.impl.utils.nbt.backend.ClassWrapper;
import net.advancedplugins.bp.impl.utils.nbt.backend.ReflectionMethod;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import net.advancedplugins.bp.impl.utils.text.Replace;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Bed;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ASManager {
    private static final HashSet<String> silkOnly = new HashSet<String>(Arrays.asList("LEAVE", "LEAVES", "MUSHROOM_STEM", "TURTLE_EGG", "CORAL"));
    private static JavaPlugin instance;
    private static final List<Integer> validSizes;
    private static HashMap<Integer, String> damages;
    private static HashMap<String, String> newMaterials;
    public static boolean debug;
    private static final ImmutableList<String> vegetationBlockNames;

    public static JavaPlugin getInstance() {
        return instance;
    }

    public static void setInstance(JavaPlugin javaPlugin) {
        instance = javaPlugin;
    }

    @Contract(value="null, _ -> fail")
    public static void notNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string.concat(" cannot be null."));
        }
    }

    @Contract(value="!null, _ -> fail")
    public static void isNull(Object object, String string) {
        if (object != null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static int getInvSize(int n) {
        MathUtils.clamp(n, 9, 54);
        if (n % 9 != 0) {
            n = MathUtils.getClosestInt(n, validSizes);
        }
        return n;
    }

    public static boolean isSpawner(Material material) {
        return material.name().endsWith("SPAWNER");
    }

    public static boolean isSpawner(Block block) {
        if (block == null || block.getType() == null) {
            return false;
        }
        return ASManager.isSpawner(block.getType());
    }

    public static boolean doesBlockFaceMatch(Block block, String string, BlockFace ... blockFaceArray) {
        for (BlockFace blockFace : blockFaceArray) {
            Material material = block.getRelative(blockFace).getType();
            if (ASManager.isAir(material) || !material.name().endsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static Block getOtherHalfOfBed(Block block) {
        if (!block.getType().name().endsWith("_BED")) {
            return null;
        }
        Bed bed = (Bed)block.getBlockData();
        Block block2 = bed.getPart() == Bed.Part.HEAD ? block.getRelative(bed.getFacing().getOppositeFace()) : block.getRelative(bed.getFacing());
        if (!(block2.getBlockData() instanceof Bed)) {
            return null;
        }
        return block2;
    }

    public static boolean isTool(Material material) {
        Object object = ReflectionMethod.CRAFT_MagicNumbers_getItem.run(null, material);
        return ASManager.isValid(material) && ClassWrapper.NMS_ItemTool.getClazz().isInstance(object);
    }

    public static boolean isExcessVelocity(Vector vector) {
        return vector.getX() > 10.0 || vector.getX() < -10.0 || vector.getY() > 10.0 || vector.getY() < -10.0 || vector.getZ() > 10.0 || vector.getZ() < -10.0;
    }

    public static List<Block> getBlocksFlat(Block block, int n) {
        if (n < 1) {
            return n == 0 ? Collections.singletonList(block) : Collections.emptyList();
        }
        int n2 = (n << 1) + 1;
        ArrayList<Block> arrayList = new ArrayList<Block>(n2 * n2 * n2);
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                arrayList.add(block.getRelative(i, 0, j));
            }
        }
        return arrayList;
    }

    public static int getAmount(Player player, Material material) {
        int n = 0;
        for (ItemStack itemStack : player.getInventory().getStorageContents()) {
            if (itemStack == null || itemStack.getType() != material) continue;
            n += itemStack.getAmount();
        }
        return n;
    }

    public static boolean hasAmount(Player player, Material material, int n) {
        for (ItemStack itemStack : player.getInventory().getContents()) {
            if (itemStack == null || itemStack.getType() != material || (n -= itemStack.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItems(Inventory inventory, Material material, int n) {
        PlayerInventory playerInventory;
        ItemStack itemStack;
        if (material == null || inventory == null) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        if (n == Integer.MAX_VALUE) {
            inventory.remove(material);
            return true;
        }
        int n2 = n;
        if (MinecraftVersion.getVersionNumber() >= 190 && inventory instanceof PlayerInventory && (itemStack = (playerInventory = (PlayerInventory)inventory).getItemInOffHand()).getType() == material) {
            n2 = ASManager.removeItem(inventory, itemStack, 45, n2);
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            int n3 = inventory.first(material);
            if (n3 == -1) {
                return false;
            }
            ItemStack itemStack2 = inventory.getItem(n3);
            assert (itemStack2 != null);
            if ((n2 = ASManager.removeItem(inventory, itemStack2, n3, n2)) <= 0) break;
        }
        return true;
    }

    public static boolean removeItems(Inventory inventory, ItemStack itemStack, int n) {
        PlayerInventory playerInventory;
        ItemStack itemStack2;
        if (itemStack == null || inventory == null) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        if (n == Integer.MAX_VALUE) {
            inventory.remove(itemStack);
            return true;
        }
        int n2 = n;
        if (MinecraftVersion.getVersionNumber() >= 190 && inventory instanceof PlayerInventory && (itemStack2 = (playerInventory = (PlayerInventory)inventory).getItemInOffHand()).isSimilar(itemStack)) {
            n2 = ASManager.removeItem(inventory, itemStack2, 45, n2);
        }
        for (int i = 0; i < inventory.getSize(); ++i) {
            int n3 = inventory.first(itemStack);
            if (n3 == -1) {
                return false;
            }
            ItemStack itemStack3 = inventory.getItem(n3);
            assert (itemStack3 != null);
            if ((n2 = ASManager.removeItem(inventory, itemStack3, n3, n2)) <= 0) break;
        }
        return true;
    }

    public static boolean itemStackEquals(ItemStack itemStack, ItemStack itemStack2, boolean bl) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        if (itemStack == itemStack2) {
            return true;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        ItemMeta itemMeta2 = itemStack2.getItemMeta();
        if (!bl && MinecraftVersion.isNew()) {
            if (itemMeta instanceof Damageable) {
                ((Damageable)itemMeta).setDamage(0);
            }
            if (itemMeta2 instanceof Damageable) {
                ((Damageable)itemMeta2).setDamage(0);
            }
        }
        return !(itemStack.getType() != itemStack2.getType() || bl && itemStack.getDurability() != itemStack2.getDurability() || itemStack.hasItemMeta() != itemStack2.hasItemMeta() || itemStack.hasItemMeta() && !Bukkit.getItemFactory().equals(itemMeta, itemMeta2));
    }

    private static int removeItem(Inventory inventory, ItemStack itemStack, int n, int n2) {
        if (itemStack.getAmount() <= n2) {
            n2 -= itemStack.getAmount();
            if (n == 45 && inventory instanceof PlayerInventory) {
                ((PlayerInventory)inventory).setItemInOffHand(null);
            } else {
                inventory.clear(n);
            }
        } else {
            itemStack.setAmount(itemStack.getAmount() - n2);
            inventory.setItem(n, itemStack);
            n2 = 0;
        }
        return n2;
    }

    public static int getEmptySlotOtherThan(int n, Player player) {
        PlayerInventory playerInventory = player.getInventory();
        int n2 = -1;
        List<Integer> list = Arrays.asList(36, 37, 38, 39, 40);
        for (int i = 0; i <= player.getInventory().getSize() - 1; ++i) {
            if (n == i || list.contains(i) || playerInventory.getItem(i) != null && playerInventory.getItem(i).getType() != Material.AIR) continue;
            n2 = i;
            return n2;
        }
        return n2;
    }

    public static void giveItemAtSlot(Player player, ItemStack itemStack, int n) {
        if (!ASManager.isValid(itemStack)) {
            return;
        }
        player.getInventory().setItem(n, itemStack);
        player.updateInventory();
    }

    public static boolean hasPotionEffect(LivingEntity livingEntity, PotionEffectType potionEffectType, int n) {
        for (PotionEffect potionEffect : livingEntity.getActivePotionEffects()) {
            if (potionEffect.getType() != potionEffectType || potionEffect.getAmplifier() != n) continue;
            return true;
        }
        return false;
    }

    public static boolean isLog(Material material) {
        if (material != null && !ASManager.isAir(material)) {
            boolean bl = YamlFile.CONFIG.getBoolean("settings.stems-count-as-trees", false);
            boolean bl2 = material.name().endsWith("LOG") || material.name().endsWith("LOG_2");
            boolean bl3 = material.name().endsWith("STEM");
            if (!bl2 && !bl3) {
                return false;
            }
            return bl || !bl3;
        }
        return false;
    }

    public static String getOrDefault(Replace replace, String string) {
        return replace == null ? string : replace.toString();
    }

    public static boolean doChancesPass(int n) {
        return (double)n > ThreadLocalRandom.current().nextDouble() * 100.0;
    }

    public static void reduceHeldItems(Player player, EquipmentSlot equipmentSlot, int n) {
        ItemStack itemStack = player.getInventory().getItem(equipmentSlot);
        if (itemStack.getAmount() - n <= 0) {
            itemStack = null;
        } else {
            itemStack.setAmount(itemStack.getAmount() - n);
        }
        player.getInventory().setItem(equipmentSlot, itemStack);
    }

    public static String capitalize(String string) {
        string = string.replaceAll("_", " ").toLowerCase(Locale.ROOT);
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String formatMaterialName(Material material) {
        return ASManager.formatMaterialName(material.name());
    }

    public static String formatMaterialName(String string) {
        String string2 = string.toLowerCase().replaceAll("_", " ");
        string2 = ASManager.capitalize(string2);
        return string2;
    }

    public static Material getItemFromBlock(Material material) {
        if (MinecraftVersion.getVersionNumber() >= 1120 && material.isItem()) {
            return material;
        }
        if (ASManager.isWallBlock(material)) {
            return ASManager.getItemFromBlock(ASManager.getItemFromBlock(material));
        }
        switch (material.name()) {
            case "CARROTS": {
                return Material.CARROT;
            }
            case "COCOA": {
                return Material.COCOA_BEANS;
            }
            case "KELP_PLANT": {
                return Material.KELP;
            }
            case "POTATOES": {
                return Material.POTATO;
            }
            case "TRIPWIRE": {
                return Material.TRIPWIRE_HOOK;
            }
        }
        return material;
    }

    public static boolean isWallBlock(Material material) {
        if (!ASManager.isValid(material)) {
            return false;
        }
        String string = material.name();
        if (string.contains("SKULL") || string.contains("HEAD")) {
            return false;
        }
        return string.contains("WALL_") || string.equals("TRIPWIRE_HOOK") || string.equals("LADDER") || string.equals("LEVER") || string.contains("BUTTON") || string.contains("BANNER") || string.equals("COCOA");
    }

    public static Object extractFromDataArray(String string, String string2, String string3, Object object) {
        for (String string4 : string.split(" ")) {
            if (!string4.startsWith(string2)) continue;
            return string4.split(string3)[1];
        }
        return object;
    }

    public static String formatTime(long l) {
        int n = (int)(l / 1000L);
        int n2 = n % 3600 % 60;
        int n3 = (int)Math.floor(n % 3600 / 60);
        int n4 = (int)Math.floor(n / 3600);
        String string = "";
        if (n4 > 0) {
            string = string + n4 + "h ";
        }
        if (n3 > 0) {
            string = string + n3 + "m ";
        }
        string = string + n2 + "s";
        return string;
    }

    public static void reportIssue(Exception exception, String string) {
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string2 = "";
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string3 = stackTraceElement + "";
            if (!string3.contains("net.advancedplugins.ae")) continue;
            string2 = string3;
            break;
        }
        exception.printStackTrace();
        Bukkit.getLogger().info("[" + instance.getDescription().getName() + " ERROR] Could not pass " + ExceptionUtils.getRootCauseMessage((Throwable)exception) + "");
        Bukkit.getLogger().info("   Class: " + string2);
        Bukkit.getLogger().info("   Extra info: " + string + "; mc[" + MinecraftVersion.getVersionNumber() + "];");
        Bukkit.getLogger().info("If you cannot indentify cause of this, contact developer providing this report. ");
    }

    public static Material getMaterial(String string) {
        try {
            MinecraftVersion.getVersion();
            return MinecraftVersion.getVersionNumber() > 1121 ? Material.matchMaterial((String)string, (boolean)true) : Material.matchMaterial((String)string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static <T, E> Set<T> getKeysByValue(Map<T, E> map, E e) {
        HashSet<T> hashSet = new HashSet<T>();
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(e, entry.getValue())) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E e) {
        HashSet hashSet = new HashSet();
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(e, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static List<String> replace(List<String> list, String string, String string2) {
        list.replaceAll(string3 -> string3.replace(string, string2));
        return list;
    }

    public static int[] getSlots(String string) {
        int[] nArray = new int[1];
        if (string.equalsIgnoreCase("filler")) {
            return nArray;
        }
        if (string.contains(",")) {
            nArray = Arrays.stream(string.split(",")).mapToInt(Integer::parseInt).toArray();
        } else if (string.contains("-")) {
            nArray = Arrays.stream(string.split("-")).mapToInt(Integer::parseInt).toArray();
            nArray = IntStream.rangeClosed(nArray[0], nArray[1]).toArray();
        } else {
            nArray[0] = ASManager.parseInt(string);
        }
        return nArray;
    }

    public static boolean contains(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.toLowerCase(Locale.ROOT).contains(string2.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.toLowerCase(Locale.ROOT).equalsIgnoreCase(string2.toLowerCase(Locale.ROOT))) continue;
            return true;
        }
        return false;
    }

    public static int parseInt(String string) {
        return ASManager.parseInt(string, 0);
    }

    public static int parseInt(String string, int n) {
        try {
            if (string.split("-").length > 1 && !string.substring(0, 1).equalsIgnoreCase("-")) {
                int n2 = Integer.parseInt(string.split("-")[0]);
                int n3 = Integer.parseInt(string.split("-")[1]);
                return ThreadLocalRandom.current().nextInt(n3 - n2) + n2;
            }
            return (int)Double.parseDouble(string.replaceAll("\"[^0-9.-]\"", "").replaceAll(" ", ""));
        }
        catch (Exception exception) {
            instance.getLogger().warning("Failed to parse " + string + " from String to Integer.");
            exception.printStackTrace();
            return n;
        }
    }

    public static double parseDouble(String string, double d) {
        try {
            if (string.split("-").length > 1 && !string.substring(0, 1).equalsIgnoreCase("-")) {
                double d2 = Integer.parseInt(string.split("-")[0]);
                double d3 = Integer.parseInt(string.split("-")[1]);
                return ThreadLocalRandom.current().nextDouble(d3 - d2) + d2;
            }
            return Double.parseDouble(string.replaceAll("[^\\\\d.]", ""));
        }
        catch (Exception exception) {
            instance.getLogger().warning("Failed to parse " + string + " from String to Double.");
            exception.printStackTrace();
            return d;
        }
    }

    public static double round(double d, int n) {
        return new BigDecimal(d).setScale(n, RoundingMode.HALF_EVEN).doubleValue();
    }

    public static double parseThroughCalculator(String string) {
        Object object;
        if (string.contains("<random>")) {
            object = StringUtils.substringBetween((String)string, (String)"<random>", (String)"</random>");
            int n = ASManager.parseInt((String)object);
            string = string.replace("<random>" + (String)object + "</random>", Integer.toString(n));
        }
        string = string.replaceAll(" ", "");
        object = new Expression(string);
        try {
            return ((Expression)object).eval().doubleValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Bukkit.getLogger().warning("Failed to calculate '" + string + "': Invalid syntax or outcome");
            return 0.0;
        }
    }

    public static void playEffect(String string, float f, int n, Location location) {
        MinecraftVersion.getVersion();
        if (MinecraftVersion.getVersionNumber() < 1130) {
            try {
                Class<?> clazz = Class.forName("org.bukkit.Effect");
                Object obj = Enum.valueOf(clazz, string);
                Method method = location.getWorld().spigot().getClass().getMethod("playEffect", Location.class, clazz, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)location.getWorld().spigot(), location, obj, 0, 0, Float.valueOf(f), Float.valueOf(f), Float.valueOf(f), Float.valueOf(0.0f), n, 32);
            }
            catch (Exception exception) {}
        } else {
            try {
                Class<?> clazz = Class.forName("org.bukkit.Particle");
                Object obj = Enum.valueOf(clazz, string);
                Method method = location.getWorld().getClass().getMethod("spawnParticle", clazz, Location.class, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke((Object)location.getWorld(), obj, location, n, Float.valueOf(f), Float.valueOf(f), Float.valueOf(f), Float.valueOf(0.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean startsWithColor(String string) {
        for (String string2 : damages.values()) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static String addColor(String string, int n) {
        String string2 = damages.get(n);
        if (string2 == null) {
            return string;
        }
        return string2 + "_" + string;
    }

    private static boolean canAddColor(String string) {
        return string.contains("STAINED_GLASS") || string.contains("SHULKER") || string.contains("TERRACOTTA") || string.contains("WOOL") || string.contains("BANNER") || string.contains("DYE") || string.contains("CONCRETE") || string.contains("CARPET") || string.contains("BED");
    }

    public static ItemStack matchMaterial(String string, int n, int n2) {
        return ASManager.matchMaterial(string, n, n2, false, true);
    }

    public static ItemStack matchMaterial(String string, int n, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        MinecraftVersion.getVersion();
        boolean bl4 = bl3 = MinecraftVersion.getVersionNumber() > 1121;
        if (bl3) {
            if (!(!string.startsWith("GOLD_") || string.contains("BLOCK") || string.contains("NUGGET") || string.contains("INGOT") || string.contains("ORE"))) {
                string = string.replace("GOLD_", "GOLDEN_");
            }
            for (Map.Entry entry : newMaterials.entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(string)) continue;
                string = (String)entry.getValue();
                break;
            }
            if (ASManager.canAddColor(string) && !ASManager.startsWithColor(string)) {
                string = ASManager.addColor(string, n2);
            }
        }
        try {
            Material material = bl ? Material.matchMaterial((String)string, (boolean)true) : Material.matchMaterial((String)string);
            return !bl3 ? new ItemStack(material, n, (short)((byte)n2)) : new ItemStack(material, n);
        }
        catch (Exception exception) {
            if (!bl && bl3) {
                return ASManager.matchMaterial(string, n, n2, true, bl2);
            }
            if (bl2) {
                Bukkit.getLogger().info("\u00ef\u00bf\u00bdcFailed to match '" + string + "' material, check your configuration or use materials.txt  to find needed material. \u00ef\u00bf\u00bd7\u00ef\u00bf\u00bdoFurther information has been pasted to console...");
                exception.printStackTrace();
            }
            return null;
        }
    }

    public static String getRoughNumber(long l) {
        if (l <= 999L) {
            return String.valueOf(l);
        }
        String[] stringArray = new String[]{"", "K", "M", "B", "P"};
        int n = (int)(Math.log10(l) / Math.log10(1000.0));
        return new DecimalFormat("#,##0.#").format((double)l / Math.pow(1000.0, n)) + "" + stringArray[n];
    }

    public static String format(long l) {
        return NumberFormat.getInstance(Locale.ROOT).format(l) + "";
    }

    public static String color(String string) {
        return ColorUtils.format(string);
    }

    public static boolean isTall(Material material) {
        if (material.name().endsWith("_DOOR")) {
            return true;
        }
        if (MinecraftVersion.isNew()) {
            return material == Material.SUNFLOWER || material == Material.LILAC || material == Material.ROSE_BUSH || material == Material.PEONY;
        }
        return material == Material.valueOf((String)"DOUBLE_PLANT");
    }

    public static List<Location> removeDuplicateLocations(List<Location> list) {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Location location : list) {
            String string;
            if (location == null || location.getWorld() == null || hashSet.contains(string = location.getWorld().getName() + "," + location.getX() + "," + location.getY() + "," + location.getZ())) continue;
            hashSet.add(string);
            arrayList.add(location);
        }
        return arrayList;
    }

    public static boolean isValid(Material material) {
        return material != null && !ASManager.isAir(material);
    }

    public static boolean isValid(ItemStack itemStack) {
        return itemStack != null && itemStack.getAmount() > 0 && !ASManager.isAir(itemStack.getType());
    }

    public static boolean isValid(Block block) {
        if (block == null || ASManager.isAir(block.getType())) {
            return false;
        }
        String string = block.getType().name();
        if (string.endsWith("_PORTAL")) {
            return false;
        }
        if (string.contains("PISTON_")) {
            return string.contains("PISTON_BASE") || string.contains("PISTON_STICKY_BASE");
        }
        return !string.equals("FIRE") && !string.equals("SOUL_FIRE") && !string.equals("TALL_SEAGRASS") && !string.equals("SWEET_BERRY_BUSH") && !string.equals("BUBBLE_COLUMN") && !string.equals("LAVA");
    }

    public static void giveItem(Player player, ItemStack ... itemStackArray) {
        for (ItemStack itemStack : itemStackArray) {
            if (!ASManager.isValid(itemStack)) continue;
            if (player.getInventory().addItem(new ItemStack[]{itemStack}).isEmpty()) continue;
            if (!Bukkit.isPrimaryThread()) {
                SchedulerUtils.runTaskLater(() -> ASManager.dropItem(player.getLocation(), itemStack));
                continue;
            }
            ASManager.dropItem(player.getLocation(), itemStack);
        }
    }

    public static List<ItemStack> condense(ItemStack[] itemStackArray) {
        for (int i = 0; i < itemStackArray.length; ++i) {
            if (itemStackArray[i] == null) continue;
            for (int j = i + 1; j < itemStackArray.length; ++j) {
                if (itemStackArray[j] == null || !itemStackArray[i].isSimilar(itemStackArray[j]) || itemStackArray[i].getAmount() + itemStackArray[j].getAmount() > itemStackArray[i].getMaxStackSize()) continue;
                itemStackArray[i].setAmount(itemStackArray[i].getAmount() + itemStackArray[j].getAmount());
                itemStackArray[j] = null;
            }
        }
        return Arrays.stream(itemStackArray).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void dropItem(Location location, ItemStack ... itemStackArray) {
        for (ItemStack itemStack : itemStackArray) {
            location.getWorld().dropItem(location, itemStack);
        }
    }

    public static boolean isAir(Material material) {
        if (material == null) {
            return false;
        }
        if (MinecraftVersion.getVersionNumber() >= 1130) {
            return material == Material.AIR || material == Material.CAVE_AIR || material == Material.VOID_AIR || material == Material.LEGACY_AIR;
        }
        return material == Material.AIR;
    }

    public static boolean isAir(Block block) {
        return block == null || ASManager.isAir(block.getType());
    }

    public static boolean isAir(ItemStack itemStack) {
        return itemStack == null || ASManager.isAir(itemStack.getType());
    }

    public static void sendActionBar(String string, Player player) {
        if (MinecraftVersion.getVersionNumber() >= 190) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)string));
        } else {
            String string2 = "v1_8_R3";
            try {
                Class<?> clazz = Class.forName("org.bukkit.craftbukkit." + string2 + ".entity.CraftPlayer");
                Object obj = clazz.cast(player);
                Class<?> clazz2 = Class.forName("net.minecraft.server." + string2 + ".PacketPlayOutChat");
                Class<?> clazz3 = Class.forName("net.minecraft.server." + string2 + ".Packet");
                Class<?> clazz4 = Class.forName("net.minecraft.server." + string2 + (string2.equalsIgnoreCase("v1_8_R1") ? ".ChatSerializer" : ".ChatComponentText"));
                Class<?> clazz5 = Class.forName("net.minecraft.server." + string2 + ".IChatBaseComponent");
                Method method = null;
                if (string2.equalsIgnoreCase("v1_8_R1")) {
                    method = clazz4.getDeclaredMethod("a", String.class);
                }
                Object obj2 = string2.equalsIgnoreCase("v1_8_R1") ? clazz5.cast(method.invoke(clazz4, "{'text': '" + string + "'}")) : clazz4.getConstructor(String.class).newInstance(string);
                Object obj3 = clazz2.getConstructor(clazz5, Byte.TYPE).newInstance(obj2, (byte)2);
                Method method2 = clazz.getDeclaredMethod("getHandle", new Class[0]);
                Object object = method2.invoke(obj, new Object[0]);
                Field field = object.getClass().getDeclaredField("playerConnection");
                Object object2 = field.get(object);
                Method method3 = object2.getClass().getDeclaredMethod("sendPacket", clazz3);
                method3.invoke(object2, obj3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static int getPages(int n, int n2) {
        return n / n2 + (n % n2 == 0 ? 0 : 1);
    }

    public static <T> List<T> getItemsInPage(List<T> list, int n, int n2) {
        return list.subList(n * n2, Math.min(list.size(), n2 * (n + 1)));
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                ASManager.deleteFile(file2);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZip(File file, File file2) {
        if (!file2.exists() || !file2.isDirectory()) {
            file2.mkdirs();
        }
        ZipFile zipFile = new ZipFile(file);
        ZipEntry zipEntry = null;
        byte[] byArray = new byte[1024];
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        try {
            while (enumeration.hasMoreElements()) {
                Object object;
                zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) {
                    object = new File(file2, zipEntry.getName());
                    ((File)object).mkdirs();
                    continue;
                }
                object = zipFile.getInputStream(zipEntry);
                File file3 = new File(file2, zipEntry.getName());
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                int n = 0;
                while ((n = ((InputStream)object).read(byArray)) > -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileOutputStream.close();
                ((InputStream)object).close();
            }
        }
        finally {
            zipFile.close();
        }
    }

    public static Material getNonWallMaterial(Material material) {
        if (!ASManager.isValid(material)) {
            return material;
        }
        String string = material.name();
        string = string.replace("WALL_", "");
        return Material.getMaterial((String)string);
    }

    public static Material getFixedMaterial(Material material) {
        if (material == null) {
            return null;
        }
        switch (material.name()) {
            case "CARROTS": {
                if (MinecraftVersion.isNew()) {
                    return Material.CARROT;
                }
                return Material.matchMaterial((String)"CARROT_ITEM");
            }
            case "POTATOES": {
                if (MinecraftVersion.isNew()) {
                    return Material.POTATO;
                }
                return Material.matchMaterial((String)"POTATO_ITEM");
            }
            case "BEETROOTS": {
                return Material.BEETROOT;
            }
            case "COCOA": {
                return Material.COCOA_BEANS;
            }
            case "KELP_PLANT": {
                return Material.KELP;
            }
            case "TRIPWIRE": {
                return Material.TRIPWIRE_HOOK;
            }
        }
        return material;
    }

    public static boolean isFortuneBlock(Material material) {
        boolean bl;
        String string = material.name();
        boolean bl2 = string.endsWith("_ORE");
        boolean bl3 = false;
        boolean bl4 = bl = bl2 && string.contains("GOLD") || string.contains("IRON");
        if (bl2 && !bl || bl2 && bl && bl3) {
            return true;
        }
        switch (string) {
            case "SEEDS": 
            case "WHEAT_SEEDS": 
            case "GLOWSTONE": 
            case "NETHER_WART": 
            case "SWEET_BERRIES": 
            case "SEA_LANTERN": 
            case "NETHER_GOLD_ORE": 
            case "MELON": 
            case "MELON_BLOCK": {
                return true;
            }
        }
        return false;
    }

    public static int getDropAmount(Block block, Material material, ItemStack itemStack) {
        Material material2 = block.getType();
        String string = material2.name().replace("LEGACY_", "");
        boolean bl = itemStack.getEnchantments().containsKey(Enchantment.SILK_TOUCH);
        int n = itemStack.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS);
        boolean bl2 = silkOnly.contains(string);
        if (bl2 && !bl) {
            return -1;
        }
        boolean bl3 = true;
        boolean bl4 = ASManager.isFortuneBlock(material2);
        int n2 = 1;
        int n3 = Integer.MAX_VALUE;
        if (!bl) {
            switch (material.name()) {
                case "IRON_INGOT": 
                case "RAW_IRON": 
                case "GOLD_INGOT": 
                case "RAW_GOLD": {
                    bl4 = true;
                    bl3 = true;
                    break;
                }
                case "ENDER_CHEST": {
                    bl4 = false;
                    bl3 = false;
                    break;
                }
            }
            switch (string) {
                case "DEEPSLATE_COPPER_ORE": 
                case "COPPER_ORE": {
                    n2 = MathUtils.randomBetween(2, 5);
                    break;
                }
                case "DEEPSLATE_LAPIS_ORE": 
                case "LAPIS_ORE": {
                    n2 = MathUtils.randomBetween(4, 9);
                    break;
                }
                case "SEA_LANTERN": {
                    if (material == material2) break;
                    n3 = 5;
                    break;
                }
                case "DEEPSLATE_REDSTONE_ORE": 
                case "REDSTONE_ORE": {
                    n2 = MathUtils.randomBetween(4, 5);
                    break;
                }
                case "NETHER_GOLD_ORE": {
                    n2 = MathUtils.randomBetween(2, 6);
                    break;
                }
                case "CLAY": 
                case "AMETHYST_CLUSTER": {
                    n2 = 4;
                    break;
                }
                case "MELON": 
                case "MELON_BLOCK": {
                    n2 = MathUtils.randomBetween(3, 7);
                    n3 = 9;
                    break;
                }
                case "GLOWSTONE": {
                    n2 = MathUtils.randomBetween(2, 4);
                    n3 = 4;
                    break;
                }
                case "ENDER_CHEST": {
                    n3 = 1;
                    bl3 = false;
                    bl4 = false;
                    break;
                }
                case "BOOKSHELF": {
                    n2 = 3;
                    n3 = 3;
                    bl3 = false;
                }
            }
        }
        if (CropUtils.isCrop(material2)) {
            n2 = CropUtils.getDropAmount(block, material, itemStack);
        } else {
            boolean bl5;
            boolean bl6 = bl5 = bl3 && material != material2 && n > 0 && !bl && bl4;
            if (bl5) {
                if (material2.name().endsWith("_ORE")) {
                    float f = ThreadLocalRandom.current().nextFloat();
                    if (f > 2.0f / ((float)n + 2.0f)) {
                        int n4 = n2;
                        for (int i = 0; i < n4; ++i) {
                            n2 += new UniformIntegerDistribution(2, n + 1).sample();
                        }
                    }
                } else {
                    n2 = new UniformIntegerDistribution(1, Math.min(n3, n2 * n)).sample();
                }
            }
        }
        return MathUtils.clamp(n2, Integer.MIN_VALUE, n3);
    }

    public static Set<Material> createMaterialSet(Collection<String> collection) {
        return collection.stream().map(Material::matchMaterial).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static boolean isUnbreakable(ItemStack itemStack) {
        return NBTapi.contains("Unbreakable", itemStack);
    }

    public static boolean isDamageable(Material material) {
        return material.getMaxDurability() > 0;
    }

    public static String tryOrElse(TryCatchMethodShort tryCatchMethodShort, String string) {
        try {
            return tryCatchMethodShort.tryCatch();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static void setByMatching(ItemStack itemStack, ItemStack itemStack2, LivingEntity livingEntity) {
        if (itemStack.isSimilar(livingEntity.getEquipment().getItemInMainHand())) {
            livingEntity.getEquipment().setItemInMainHand(itemStack2);
            return;
        }
        if (itemStack.isSimilar(livingEntity.getEquipment().getItemInOffHand())) {
            livingEntity.getEquipment().setItemInOffHand(itemStack2);
        }
    }

    public static boolean hasTotem(Player player) {
        ItemStack itemStack = player.getInventory().getItemInOffHand();
        return ASManager.isValid(itemStack) && itemStack.getType() == Material.TOTEM_OF_UNDYING;
    }

    public static void resetPlayerHealth(Player player, double d) {
        double d2 = MathUtils.clamp(d, player.getHealth(), player.getMaxHealth());
        player.setHealth(d2);
    }

    public static String getBlockMaterial(Block block) {
        if (block == null) {
            return "AIR";
        }
        return block.getType().name();
    }

    public static List<String> getVariables(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (String string4 : string.split(string2)) {
            if (++n == 1) continue;
            arrayList.add(string4.split(string3)[0]);
        }
        return arrayList;
    }

    public static <T extends Enum<T>> boolean isValidEnum(Class<T> clazz, String string) {
        try {
            Enum.valueOf(clazz, string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isCorrectTool(ItemStack itemStack, Material material) {
        Object object = ReflectionMethod.CRAFT_ItemStack_asNMSCopy.run(null, itemStack);
        Object object2 = ReflectionMethod.CRAFT_MagicNumbers_getBlock.run(null, material);
        Object object3 = ReflectionMethod.NMS_Block_getBlockData.run(object2, new Object[0]);
        return (Boolean)ReflectionMethod.NMS_ItemStack_canDestroySpecialBlock.run(object, object3);
    }

    public static boolean notNullAndTrue(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public static boolean sameBlock(Location location, Location location2) {
        return location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ();
    }

    public static void debug(String string) {
        if (!debug) {
            return;
        }
        Bukkit.getLogger().info(string);
        Bukkit.getOnlinePlayers().stream().filter(player -> player.hasPermission("advancedplugins.admin") || player.isOp()).forEach(player -> player.sendMessage(ColorUtils.format(string)));
    }

    public static String join(String[] stringArray, String string) {
        return ASManager.join(Arrays.asList(stringArray), string);
    }

    public static String join(Collection<String> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : collection) {
            stringBuilder.append(string2).append(string);
        }
        return stringBuilder.substring(0, stringBuilder.length() - string.length());
    }

    public static String join(Iterable<String> iterable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : iterable) {
            stringBuilder.append(string2).append(string);
        }
        return stringBuilder.substring(0, stringBuilder.length() - string.length());
    }

    public static String getMaterial(ItemStack itemStack) {
        if (itemStack == null) {
            return "AIR";
        }
        return itemStack.getType().name();
    }

    public static <T> T getFromArray(T[] TArray, int n) {
        if (n == -1) {
            n = TArray.length - 1;
        }
        return TArray[n];
    }

    public static String limit(String string, int n, String string2) {
        return string.length() < n ? string : string.substring(0, n - 1) + string2;
    }

    public static String join(String[] stringArray, String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        n2 = Math.max(stringArray.length, n2);
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(stringArray[i]).append(string);
        }
        return stringBuilder.substring(0, stringBuilder.length() - string.length());
    }

    public static int getEmptySlotCountInInventory(@NotNull Player player) {
        if (player.getInventory().firstEmpty() == -1) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack itemStack = player.getInventory().getItem(i);
            if (itemStack != null && !itemStack.getType().equals((Object)Material.AIR)) continue;
            ++n;
        }
        return n;
    }

    public static <K, V> ImmutableMap<K, V> toImmutable(Map<K, V> map) {
        return ImmutableMap.builder().putAll(map).build();
    }

    public static boolean isVegetation(Material material) {
        return vegetationBlockNames.contains((Object)material.name());
    }

    public static <V> List<String> toStringList(V ... VArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (V v : VArray) {
            arrayList.add(v.toString());
        }
        return arrayList;
    }

    public static int[] subarray(int[] nArray, int n, int n2) {
        if (nArray == null || n < 0 || n2 > nArray.length || n > n2) {
            throw new IllegalArgumentException("Invalid arguments");
        }
        return Arrays.copyOfRange(nArray, n, n2);
    }

    public static <V> V[] subarray(V[] VArray, int n, int n2) {
        if (VArray == null || n < 0 || n2 > VArray.length || n > n2) {
            throw new IllegalArgumentException("Invalid arguments");
        }
        return Arrays.copyOfRange(VArray, n, n2);
    }

    public static boolean isDay(long l) {
        return l > 0L && l < 12300L;
    }

    public static void fillEmptyInventorySlots(Inventory inventory, ItemStack itemStack) {
        IntStream.range(0, inventory.getSize()).filter(n -> inventory.getItem(n) == null).forEach(n -> inventory.setItem(n, itemStack));
    }

    public static Location offsetToLookingLocation(Location location, double d) {
        Location location2 = location.clone();
        Vector vector = location2.getDirection();
        vector.normalize();
        vector.multiply(d);
        location2.add(vector);
        return location2;
    }

    static {
        validSizes = new ArrayList<Integer>(Arrays.asList(9, 18, 27, 36, 45, 54));
        damages = new HashMap();
        newMaterials = new HashMap();
        if (damages.isEmpty()) {
            damages.put(0, "WHITE");
            damages.put(1, "ORANGE");
            damages.put(2, "MAGENTA");
            damages.put(3, "LIGHT_BLUE");
            damages.put(4, "YELLOW");
            damages.put(5, "LIME");
            damages.put(6, "PINK");
            damages.put(7, "GRAY");
            damages.put(8, "LIGHT_GRAY");
            damages.put(9, "CYAN");
            damages.put(10, "PURPLE");
            damages.put(11, "BLUE");
            damages.put(12, "BROWN");
            damages.put(13, "GREEN");
            damages.put(14, "RED");
            damages.put(15, "BLACK");
        }
        if (newMaterials.isEmpty()) {
            newMaterials.put("EYE_OF_ENDER", "ENDER_EYE");
            newMaterials.put("ENDER_PORTAL_FRAME", "END_PORTAL_FRAME");
            newMaterials.put("FIREWORK_CHARGE", "FIREWORK_STAR");
            newMaterials.put("FIREBALL", "FIRE_CHARGE");
            newMaterials.put("SULPHUR", "GUNPOWDER");
            newMaterials.put("WOOD_DOOR", "OAK_DOOR");
            newMaterials.put("COMMAND", "COMMAND_BLOCK");
            newMaterials.put("PISTON_BASE", "PISTON");
            newMaterials.put("SKULL_ITEM", "PLAYER_HEAD");
            newMaterials.put("WORKBENCH", "CRAFTING_TABLE");
            newMaterials.put("BOOK_AND_QUILL", "WRITABLE_BOOK");
            newMaterials.put("THIN_GLASS", "GLASS_PANE");
            newMaterials.put("STORAGE_MINECART", "CHEST_MINECART");
            newMaterials.put("BREWING_STAND_ITEM", "LEGACY_BREWING_STAND_ITEM");
        }
        debug = false;
        vegetationBlockNames = ImmutableList.builder().addAll(Arrays.asList("GRASS", "TALL_GRASS", "FERN", "LARGE_FERN", "SEAGRASS", "TALL_SEAGRASS", "DANDELION", "POPPY", "BLUE_ORCHID", "ALLIUM", "AZURE_BLUET", "RED_TULIP", "ORANGE_TULIP", "WHITE_TULIP", "PINK_TULIP", "OXEYE_DAISY", "CORNFLOWER", "LILY_OF_THE_VALLEY", "WITHER_ROSE", "SUNFLOWER", "LILAC", "ROSE_BUSH", "PEONY")).build();
    }
}

