/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils;

import java.util.HashSet;
import java.util.Set;
import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.configs.YamlFile;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class BreakWholeTree {
    private final int maxLeavesToSearch = 90;
    private final int maxLogsToSearch = 95;
    private int leavesScanned = 0;
    private final Set<Block> foundBlocks;

    public BreakWholeTree(Block block) {
        Location location = block.getLocation();
        this.foundBlocks = new HashSet<Block>();
        World world = location.getWorld();
        int n = 2;
        int n2 = location.getBlockX() + n;
        int n3 = location.getBlockZ() + n;
        for (int i = location.getBlockX(); i <= n2; ++i) {
            for (int j = location.getBlockZ(); j <= n3; ++j) {
                if (this.foundBlocks.size() >= 95 || this.leavesScanned >= 90) {
                    return;
                }
                Location location2 = new Location(world, (double)i, location.getY(), (double)j);
                Block block2 = location2.getBlock();
                if (!ASManager.isLog(block2.getType())) {
                    if (block2.getType().name().endsWith("LEAVES")) {
                        ++this.leavesScanned;
                        continue;
                    }
                    if (block2.getType().name().contains("AIR")) continue;
                }
                if (block2.hasMetadata("AE_Placed") || block2.hasMetadata("non-natural") && YamlFile.CONFIG.getBoolean("settings.respect-player-placed-blocks", true)) continue;
                block7: for (BlockFace blockFace : BlockFace.values()) {
                    Block block3 = block2.getRelative(blockFace);
                    if (!ASManager.isLog(block3.getType()) || block3.getType().name().endsWith("LEAVES")) continue;
                    this.foundBlocks.add(block3);
                    switch (blockFace) {
                        case UP: {
                            this.scanUp(block3);
                            continue block7;
                        }
                        case DOWN: {
                            this.scanDown(block3);
                            continue block7;
                        }
                        case NORTH_WEST: 
                        case NORTH_EAST: 
                        case SOUTH_WEST: 
                        case SOUTH_EAST: 
                        case NORTH: 
                        case WEST: 
                        case SOUTH: 
                        case EAST: {
                            this.scanDirectional(block3, blockFace);
                            continue block7;
                        }
                    }
                }
            }
        }
        this.foundBlocks.remove(block);
    }

    private void scanUp(Block block) {
        if (this.foundBlocks.size() >= 95 || this.leavesScanned >= 90) {
            return;
        }
        if (block.hasMetadata("AE_Placed")) {
            return;
        }
        if (block.hasMetadata("non-natural") && YamlFile.CONFIG.getBoolean("settings.respect-player-placed-blocks", true)) {
            return;
        }
        if (!ASManager.isLog(block.getType())) {
            if (block.getType().name().endsWith("LEAVES")) {
                ++this.leavesScanned;
                this.scanUp(block.getRelative(BlockFace.UP));
            }
        } else {
            this.foundBlocks.add(block);
            this.scanUp(block.getRelative(BlockFace.UP));
        }
    }

    private void scanDown(Block block) {
        if (this.foundBlocks.size() >= 95 || this.leavesScanned >= 90) {
            return;
        }
        if (block.hasMetadata("AE_Placed")) {
            return;
        }
        if (block.hasMetadata("non-natural") && YamlFile.CONFIG.getBoolean("settings.respect-player-placed-blocks", true)) {
            return;
        }
        if (!ASManager.isLog(block.getType())) {
            if (block.getType().name().endsWith("LEAVES")) {
                ++this.leavesScanned;
                this.scanDown(block.getRelative(BlockFace.DOWN));
            }
        } else {
            this.foundBlocks.add(block);
            this.scanUp(block.getRelative(BlockFace.DOWN));
        }
    }

    private void scanDirectional(Block block, BlockFace blockFace) {
        this.scanUp(block);
        this.scanDown(block);
    }

    public Set<Block> get() {
        return this.foundBlocks;
    }
}

