/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ColorUtils {
    private static final Pattern hexPattern = Pattern.compile("\\{#[a-fA-F0-9]{6}}");
    private static final Pattern normalPattern = Pattern.compile("([\u00a7&])[0-9a-fA-Fk-orK-OR]");

    public static String format(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        if (MinecraftVersion.getVersionNumber() >= 1160) {
            Matcher matcher = hexPattern.matcher(string);
            while (matcher.find()) {
                String string2 = string.substring(matcher.start(), matcher.end());
                string = StringUtils.replace((String)string, (String)string2, (String)("" + ChatColor.of((String)string2.replace("{", "").replace("}", ""))));
                matcher = hexPattern.matcher(string);
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static List<String> format(List<String> list) {
        list.replaceAll(ColorUtils::format);
        return list;
    }

    public static String stripColor(@NotNull String string) {
        return ChatColor.stripColor((String)string);
    }

    public static List<String> stripColor(List<String> list) {
        list.replaceAll(ColorUtils::stripColor);
        return list;
    }

    public static String getLastColor(String string) {
        String string2 = "";
        Matcher matcher = hexPattern.matcher(string);
        while (matcher.find()) {
            string2 = string.substring(matcher.start(), matcher.end());
        }
        Matcher matcher2 = normalPattern.matcher(string);
        while (matcher2.find()) {
            string2 = string.substring(matcher2.start(), matcher2.end());
        }
        return string2;
    }
}

