/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.nbt.backend.ClassWrapper;
import net.advancedplugins.bp.impl.utils.nbt.utils.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class ReallyFastBlockHandler {
    private static final Map<World, ReallyFastBlockHandler> handlers = new HashMap<World, ReallyFastBlockHandler>();
    private static Class<?> craftWorldClass;
    private static Class<?> craftBlockData;
    private static Class<?> craftMagicNumbersClass;
    private static Constructor<?> blockPos;
    private static Method getHandle;
    private static Method setType;
    private static Method getState;
    private static Method getMagicBlock;
    private static Method getMagicBlockData;
    private Object nmsWorld;

    public static ReallyFastBlockHandler getForWorld(World world) {
        if (handlers.containsKey(world)) {
            return handlers.get(world);
        }
        ReallyFastBlockHandler reallyFastBlockHandler = new ReallyFastBlockHandler(world);
        handlers.put(world, reallyFastBlockHandler);
        return reallyFastBlockHandler;
    }

    public ReallyFastBlockHandler(World world) {
        Object obj = craftWorldClass.cast(world);
        try {
            this.nmsWorld = getHandle.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
    }

    public void setType(Material material, Block ... blockArray) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)ASManager.getInstance(), () -> this.setType(material, blockArray));
            return;
        }
        try {
            Object object = MinecraftVersion.isNew() ? getState.invoke(craftBlockData.cast(material.createBlockData()), new Object[0]) : getMagicBlockData.invoke(getMagicBlock.invoke(craftMagicNumbersClass, material), new Object[0]);
            for (Block block : blockArray) {
                if (block.getType() == material) continue;
                Object obj = blockPos.newInstance(block.getX(), block.getY(), block.getZ());
                setType.invoke(this.nmsWorld, obj, object, 3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            Class<?> clazz = ClassWrapper.NMS_World.getClazz();
            craftWorldClass = ClassWrapper.CRAFT_World.getClazz();
            Class<?> clazz2 = ClassWrapper.NMS_BlockPosition.getClazz();
            Class<?> clazz3 = ClassWrapper.NMS_IBlockData.getClazz();
            if (MinecraftVersion.isNew()) {
                craftBlockData = ClassWrapper.CRAFT_BlockData.getClazz();
                getState = craftBlockData.getMethod("getState", new Class[0]);
            }
            blockPos = clazz2.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
            getHandle = craftWorldClass.getMethod("getHandle", new Class[0]);
            Method method = setType = MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_18_R1) ? clazz.getMethod("a", clazz2, clazz3, Integer.TYPE) : clazz.getMethod("setTypeAndData", clazz2, clazz3, Integer.TYPE);
            if (!MinecraftVersion.isNew()) {
                craftMagicNumbersClass = ClassWrapper.CRAFT_MagicNumbers.getClazz();
                getMagicBlock = craftMagicNumbersClass.getMethod("getBlock", Material.class);
                Class<?> clazz4 = ClassWrapper.NMS_Block.getClazz();
                getMagicBlockData = clazz4.getMethod("getBlockData", new Class[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }
}

