/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.economy.local;

import net.advancedplugins.bp.impl.utils.economy.AdvancedEconomy;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultEconomy
implements AdvancedEconomy {
    private Economy econ;

    public VaultEconomy() {
        this.setupEconomy();
    }

    private boolean setupEconomy() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return false;
        }
        this.econ = (Economy)registeredServiceProvider.getProvider();
        return this.econ != null;
    }

    @Override
    public boolean giveUser(Player player, double d) {
        return this.econ.depositPlayer((OfflinePlayer)player, d).transactionSuccess();
    }

    @Override
    public String getName() {
        return "MONEY";
    }

    @Override
    public boolean chargeUser(Player player, double d) {
        return this.econ.withdrawPlayer((OfflinePlayer)player, d).transactionSuccess();
    }

    @Override
    public double getBalance(Player player) {
        return this.econ.getBalance((OfflinePlayer)player);
    }
}

