/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.ColorUtils;
import net.advancedplugins.bp.impl.utils.SchedulerUtils;
import net.advancedplugins.bp.impl.utils.editor.ConfigEditorMenu;
import net.advancedplugins.bp.impl.utils.editor.KeyInfo;
import net.advancedplugins.bp.impl.utils.editor.KeyType;
import net.advancedplugins.bp.impl.utils.items.ItemBuilder;
import net.advancedplugins.bp.impl.utils.nbt.NBTapi;
import net.advancedplugins.bp.impl.utils.text.Text;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigEditorGui
implements Listener {
    private final JavaPlugin plugin;
    private final Player editor;
    private String defaultDesc = "";
    private String defaultMaterial = "PAPER";
    private final ConfigurationSection config;
    private final String baseSection;
    private String currentSection = "";
    private String lastCurrentSection = "";
    private String editingKey;
    private final KeyInfo editObject;
    private final LinkedList<KeyInfo> keyInfos = new LinkedList();
    private final Inventory inventory;
    private int page = 0;
    private static final int ITEMS_PER_PAGE = 27;
    private boolean enabled = true;
    private int editingLine = -2;
    private List<String> originalList;
    private List<String> list;
    private Inventory listEditor = null;

    public ConfigEditorGui(String string, String string2, ConfigurationSection configurationSection, Player player, LinkedList<KeyInfo> linkedList, KeyInfo keyInfo, JavaPlugin javaPlugin) {
        this.config = configurationSection;
        this.baseSection = string2;
        this.keyInfos.addAll(linkedList);
        this.editor = player;
        this.plugin = javaPlugin;
        this.editObject = keyInfo;
        this.inventory = Bukkit.createInventory(null, (int)18, (String)Text.modify(string));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)javaPlugin);
    }

    public ConfigEditorGui open() {
        Object object;
        if (!this.lastCurrentSection.equalsIgnoreCase(this.currentSection)) {
            this.lastCurrentSection = this.currentSection;
            this.page = 0;
        }
        this.inventory.clear();
        int n = this.page * 27;
        int n2 = Math.min(n + 27, this.config.getConfigurationSection(this.currentSection).getKeys(false).size());
        List list = new ArrayList(this.config.getConfigurationSection(this.currentSection).getKeys(false)).subList(n, n2);
        for (int i = this.inventory.getSize() - 9; i < this.inventory.getSize(); ++i) {
            this.inventory.setItem(i, new ItemBuilder(Material.matchMaterial((String)(ConfigEditorMenu.getHandler().getGlassColor() + "_STAINED_GLASS_PANE"))).setName(" ").setGlowing(true).toItemStack());
        }
        for (String string : list) {
            String object2 = this.getPathWithKey(string);
            KeyInfo keyInfo = this.matchInfo(object2);
            this.inventory.addItem(new ItemStack[]{this.getItemForKey(object2, keyInfo)});
        }
        for (KeyInfo keyInfo : this.getNotSetKeys()) {
            if (keyInfo.path.endsWith("*") || list.contains(this.getLastKey(keyInfo.path)) || this.config.isConfigurationSection(keyInfo.path) || this.config.contains(keyInfo.path)) continue;
            this.inventory.addItem(new ItemStack[]{this.getItemForKey(keyInfo.path, keyInfo)});
        }
        if (this.matchInfo(this.currentSection + ".*") != null) {
            this.inventory.addItem(new ItemStack[]{new ItemBuilder(Material.GREEN_WOOL).setName(Text.modify("&a&lAdd new entry.")).toItemStack()});
        }
        if (this.page > 0) {
            object = new ItemBuilder(Material.BOOK).setAmount(this.page).setName("Previous Page");
            this.inventory.setItem(this.inventory.getSize() - 6, ((ItemBuilder)object).toItemStack());
        }
        if (n2 < list.size()) {
            object = new ItemBuilder(Material.BOOK).setAmount(this.page + 2).setName("Next Page");
            this.inventory.setItem(this.inventory.getSize() - 4, ((ItemBuilder)object).toItemStack());
        }
        object = new ItemBuilder(Material.ARROW).setName("Back");
        this.inventory.setItem(this.inventory.getSize() - 1, ((ItemBuilder)object).toItemStack());
        ConfigEditorMenu.placeFiller(this.inventory, this.editor);
        this.editor.openInventory(this.inventory);
        return this;
    }

    public KeyInfo matchInfo(String string) {
        return this.keyInfos.stream().filter(keyInfo -> keyInfo.path.equalsIgnoreCase(string) || Pattern.matches(keyInfo.path.endsWith("*") ? keyInfo.path.replace(".", "\\.").replace("*", "[^\\.]*") + "$" : keyInfo.path.replace(".", "\\.").replace("*", "[^\\.]*"), string)).findFirst().orElse(null);
    }

    public String getDescription(String string) {
        KeyInfo keyInfo = this.matchInfo(string);
        if (keyInfo == null || keyInfo.description == null) {
            return this.defaultDesc;
        }
        return keyInfo.description;
    }

    public String getPathWithKey(String string) {
        if (this.currentSection.isEmpty()) {
            return string;
        }
        return this.currentSection + "." + string;
    }

    private KeyType getKeyType(String string) {
        if (this.matchInfo(string) != null) {
            KeyInfo keyInfo = this.matchInfo(string);
            if (keyInfo.type != null) {
                return keyInfo.type;
            }
        }
        try {
            return KeyType.getKeyType(this.config.get(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private ItemStack getItemForKey(String string, KeyInfo keyInfo) {
        Material material = keyInfo != null ? keyInfo.displayMaterial : Material.matchMaterial((String)this.defaultMaterial);
        ItemBuilder itemBuilder = new ItemBuilder(material).setName(Text.modify("&a&l" + this.getLastKey(string)));
        String string2 = this.getDescription(string);
        if (string2 != null && !string2.isEmpty()) {
            itemBuilder.addLoreLine(Text.modify(" &f&l\u24d8 &f" + string2));
        }
        if (this.config.contains(string)) {
            if (this.config.get(string) instanceof List) {
                this.addListValues(itemBuilder, string);
            } else if (!(this.config.get(string) instanceof ConfigurationSection)) {
                this.addNonSectionValues(itemBuilder, string);
            } else {
                this.addSectionValues(itemBuilder, string);
                itemBuilder.addLoreLine("");
                itemBuilder.addLoreLine(Text.modify("&fOpen a sub-menu to edit."));
            }
        } else {
            itemBuilder.addLoreLine(Text.modify("&eValue is not set in the configuration."));
        }
        this.addTypeInfo(itemBuilder, string);
        itemBuilder.addLoreLine(" ").addLoreLine(Text.modify(" &7\u27a4 &lLeft Click&7 here to edit this value"));
        if (this.config.contains(string)) {
            itemBuilder.addLoreLine(Text.modify(" &c\u2715 &lShift Left Click&c here to delete this value"));
        }
        if (keyInfo != null && keyInfo.wikiLink != null) {
            itemBuilder.addLoreLine(Text.modify(" &f\u24d8 &lRight Click&7 here to learn more"));
        }
        itemBuilder.addItemFlag(ItemFlag.values());
        return itemBuilder.toItemStack();
    }

    private void addListValues(ItemBuilder itemBuilder, String string) {
        List list = (List)this.config.get(string);
        itemBuilder.addLoreLine(Text.modify("&eCurrent values: "));
        for (String string2 : list) {
            itemBuilder.addLoreLine(Text.modify("&6&l \ud83d\udd39 &f" + ASManager.limit(string2, 40, "...")));
        }
    }

    private void addNonSectionValues(ItemBuilder itemBuilder, String string) {
        itemBuilder.addLoreLine(Text.modify("&eCurrent value&f: " + this.config.get(string).toString()));
        KeyType keyType = this.getKeyType(string);
        if (keyType != null) {
            if (keyType.equals((Object)KeyType.MATERIAL)) {
                Material material = Material.matchMaterial((String)this.config.getString(string));
                if (material != null) {
                    itemBuilder.setType(material);
                }
            } else if (keyType.equals((Object)KeyType.INTEGER)) {
                int n = Math.max(1, Math.min(64, this.config.getInt(string)));
                itemBuilder.setAmount(n);
            }
        }
    }

    private void addSectionValues(ItemBuilder itemBuilder, String string) {
        for (String string2 : this.config.getConfigurationSection(string).getKeys(false).stream().limit(8L).collect(Collectors.toList())) {
            Object object = this.config.get(string + "." + string2);
            KeyType keyType = KeyType.getKeyType(object);
            if (keyType == null) continue;
            object = this.formatSectionValue(object, keyType);
            itemBuilder.addLoreLine(Text.modify("&e\u2666 &6&l" + string2 + " &f" + object));
        }
    }

    private Object formatSectionValue(Object object, KeyType keyType) {
        if (keyType.equals((Object)KeyType.LIST)) {
            object = "List";
        } else if (keyType.equals((Object)KeyType.KEY)) {
            object = "sub-menu";
        } else if (keyType.equals((Object)KeyType.STRING)) {
            object = ((String)object).length() > 32 ? ((String)object).substring(0, 31) + "..." : object;
        }
        return object;
    }

    private void addTypeInfo(ItemBuilder itemBuilder, String string) {
        KeyType keyType = this.getKeyType(string);
        if (keyType != null) {
            itemBuilder.addLoreLine(Text.modify("&aValue Type: &f" + keyType.getFriendlyName()));
        }
    }

    private List<KeyInfo> getNotSetKeys() {
        String string = this.currentSection;
        if (string == null) {
            return Collections.emptyList();
        }
        return this.keyInfos.stream().filter(this::isSameBlock).collect(Collectors.toList());
    }

    private boolean isSameBlock(KeyInfo keyInfo) {
        if (keyInfo == null) {
            return false;
        }
        if (this.currentSection.isEmpty()) {
            return !keyInfo.path.contains(".");
        }
        String string = keyInfo.path.replace("*", this.getLastKey(this.currentSection)).replaceFirst(this.currentSection + ".", "");
        return keyInfo.path.replace("*", this.getLastKey(this.currentSection)).startsWith(this.currentSection) && !string.contains(".");
    }

    public void close() {
        this.enabled = false;
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        String string;
        ItemStack itemStack;
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        boolean bl = false;
        if (inventoryClickEvent.getInventory().equals(this.listEditor)) {
            inventoryClickEvent.setCancelled(true);
            itemStack = inventoryClickEvent.getCurrentItem();
            string = ColorUtils.stripColor(itemStack.getItemMeta().getDisplayName());
            if ("Go back".equals(itemStack.getItemMeta().getDisplayName())) {
                this.open();
                return;
            }
            if (inventoryClickEvent.isRightClick()) {
                this.list.remove(string);
                this.config.set(this.editingKey, this.list);
                this.close();
                ConfigEditorMenu.getHandler().updateFiles(this.editObject, this.editor, this.editingKey, this.currentSection);
                return;
            }
            this.editingLine = "Add new line".equals(string) ? -1 : this.list.indexOf(string);
            bl = true;
        }
        if (inventoryClickEvent.getInventory().equals(this.inventory) || bl) {
            inventoryClickEvent.setCancelled(true);
            itemStack = inventoryClickEvent.getCurrentItem();
            if (itemStack == null) {
                return;
            }
            string = ColorUtils.stripColor(itemStack.getItemMeta().getDisplayName());
            if (string.isEmpty() || string.equals(" ")) {
                return;
            }
            if ("Back".equals(string)) {
                if (this.baseSection.length() < this.currentSection.length()) {
                    this.currentSection = this.getPreviousSection();
                    this.open();
                } else {
                    this.close();
                    ConfigEditorMenu.getHandler().openMainMenu(this.editor);
                }
                return;
            }
            if ("Next Page".equals(string)) {
                ++this.page;
                this.open();
                return;
            }
            if ("Previous Page".equals(string)) {
                --this.page;
                this.open();
                return;
            }
            if ((string = this.getPathWithKey(string)).endsWith("Add new entry.")) {
                string = this.currentSection + ".*";
            }
            KeyInfo keyInfo = this.matchInfo(string);
            if (inventoryClickEvent.getClick().isRightClick() && keyInfo != null && keyInfo.wikiLink != null) {
                TextComponent textComponent = new TextComponent(Text.modify("&7&l\u24d8 &aClick here to open the page explaining '&f" + string + "&a' setting."));
                textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, keyInfo.wikiLink));
                this.editor.spigot().sendMessage((BaseComponent)textComponent);
                this.editor.closeInventory();
                return;
            }
            if (inventoryClickEvent.isLeftClick() && inventoryClickEvent.isShiftClick()) {
                this.config.set(string, null);
                this.close();
                ConfigEditorMenu.getHandler().updateFiles(this.editObject, this.editor, string, string);
                return;
            }
            if (this.config.get(string) instanceof ConfigurationSection || keyInfo != null && keyInfo.menu) {
                if (this.config.get(string) == null) {
                    this.config.createSection(string);
                }
                this.currentSection = string;
                this.open();
            } else {
                TextComponent textComponent;
                this.editingKey = !bl ? string : this.editingKey;
                Object object = this.config.get(this.editingKey);
                KeyType keyType = this.getKeyType(string);
                if (object instanceof List || keyType != null && keyType.equals((Object)KeyType.LIST)) {
                    if (!bl) {
                        this.editingKey = string;
                        this.openListEditorGui(string);
                        return;
                    }
                    object = this.editingLine < 0 ? null : ((List)object).get(this.editingLine);
                } else {
                    this.editingKey = string;
                }
                if (keyType != null && keyType.equals((Object)KeyType.BOOLEAN) && object != null) {
                    boolean bl2 = (Boolean)object;
                    this.processInput(!bl2 + "");
                    return;
                }
                this.editor.closeInventory();
                this.editor.sendMessage(Text.modify("&8-------------------------------------------------------"));
                this.editor.sendMessage(Text.modify(" "));
                this.editor.sendMessage(Text.modify(" "));
                this.editor.sendMessage(Text.modify(" "));
                this.editor.sendMessage(Text.modify(" "));
                String string2 = "Please enter a value for &e'" + string + "'&o";
                if (keyType != null) {
                    string2 = string2 + " (" + keyType.getFriendlyName() + ")";
                }
                string2 = string2 + "&f or type &e'cancel'&f to cancel. \n&f&nCurrent value:&e ";
                this.editor.sendMessage(Text.modify(string2) + (object == null ? "not set" : object.toString()));
                this.editor.sendMessage(Text.modify(" "));
                if (keyInfo != null && keyInfo.wikiLink != null) {
                    textComponent = new TextComponent(Text.modify("&7&l\u24d8 &eClick here to open the page explaining '&f" + string + "&e' setting."));
                    textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, keyInfo.wikiLink));
                    this.editor.spigot().sendMessage((BaseComponent)textComponent);
                }
                if (object != null) {
                    textComponent = new TextComponent(Text.modify("&7&l\u24d8 &aClick here to insert &f" + object.toString() + "&a to your chat."));
                    textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, object.toString()));
                    this.editor.spigot().sendMessage((BaseComponent)textComponent);
                }
                if (keyInfo != null && keyInfo.suggestions != null) {
                    this.editor.sendMessage(Text.modify("&7&oYou can use TAB to auto-complete suggestions for this value!"));
                    this.editor.addCustomChatCompletions(keyInfo.suggestions);
                }
            }
        }
    }

    private String getPreviousSection() {
        String[] stringArray = this.currentSection.split("\\.");
        if (stringArray.length == 1) {
            return "";
        }
        if (stringArray.length == 2) {
            return stringArray[0];
        }
        return String.join((CharSequence)".", Arrays.copyOfRange(stringArray, 0, stringArray.length - 1));
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.getPlayer().equals(this.editor) && this.editingKey != null) {
            SchedulerUtils.runTaskLater(() -> {
                if (this.validateInput(asyncPlayerChatEvent.getMessage())) {
                    this.processInput(asyncPlayerChatEvent.getMessage());
                    if (this.enabled) {
                        this.open();
                    }
                } else {
                    this.editor.sendMessage("Invalid input: " + asyncPlayerChatEvent.getMessage());
                }
            });
            asyncPlayerChatEvent.setCancelled(true);
            return;
        }
    }

    private void processInput(String string) {
        if (string.equalsIgnoreCase("cancel")) {
            this.open();
        } else {
            KeyType keyType = this.getKeyType(this.editingKey);
            if (keyType == null) {
                this.editor.sendMessage(Text.modify("&c&l(!) &cInvalid value type: " + string));
            } else {
                KeyInfo keyInfo = this.matchInfo(this.editingKey);
                if (keyInfo != null) {
                    if (keyInfo.addKeyToInput) {
                        string = this.editingKey + "." + string;
                    } else if (keyInfo.type.equals((Object)KeyType.KEY)) {
                        string = this.currentSection + "." + string;
                    }
                }
                Object object = keyType.process(string, this.config);
                if (this.editingLine == -2) {
                    if (!object.equals((Object)KeyType.KEY)) {
                        this.config.set(this.editingKey, object);
                    }
                } else {
                    List list = this.config.getList(this.editingKey);
                    if (this.editingLine != -1) {
                        list.set(this.editingLine, object);
                    } else {
                        list.add(object);
                    }
                    this.config.set(this.editingKey, (Object)list);
                    this.editingLine = -2;
                }
                this.close();
                ConfigEditorMenu.getHandler().updateFiles(this.editObject, this.editor, this.editingKey, this.currentSection);
            }
        }
        if (this.matchInfo(this.editingKey) != null && this.matchInfo((String)this.editingKey).suggestions != null) {
            this.editor.removeCustomChatCompletions(this.matchInfo((String)this.editingKey).suggestions);
        }
        this.editingKey = null;
    }

    public String getLastKey(String string) {
        String[] stringArray = string.split("\\.");
        return stringArray[stringArray.length - 1];
    }

    private boolean validateInput(String string) {
        if (string.equalsIgnoreCase("cancel")) {
            return true;
        }
        KeyType keyType = this.getKeyType(this.editingKey);
        return keyType != null && keyType.validate(string);
    }

    public ConfigEditorGui setDefaultDesc(String string) {
        this.defaultDesc = string;
        return this;
    }

    public ConfigEditorGui setCurrentSection(String string) {
        this.currentSection = string;
        return this;
    }

    public ConfigEditorGui setDefaultMaterial(String string) {
        this.defaultMaterial = string;
        return this;
    }

    public void openListEditorGui(String string) {
        ItemMeta itemMeta;
        ItemStack itemStack;
        String string22;
        this.list = this.config.contains(string) ? this.config.getStringList(string) : new ArrayList();
        this.listEditor = Bukkit.createInventory(null, (int)ASManager.getInvSize(this.list.size() + 1), (String)(Text.modify("&eEdit list: ") + string));
        for (String string22 : this.list) {
            itemStack = new ItemStack(Material.PAPER);
            itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(string22);
            itemMeta.setLore(Arrays.asList(Text.modify(" &7\u27a4 &nLeft Click&7 here to edit this line."), Text.modify(" &7\u2715 &nRight Click&7 here to remove this line.")));
            itemStack.setItemMeta(itemMeta);
            itemStack = NBTapi.addNBTTag("randomizer", UUID.randomUUID().toString(), itemStack);
            this.listEditor.addItem(new ItemStack[]{itemStack});
        }
        ItemStack itemStack2 = new ItemStack(Material.GREEN_WOOL);
        string22 = itemStack2.getItemMeta();
        string22.setDisplayName("Add new line");
        itemStack2.setItemMeta((ItemMeta)string22);
        this.listEditor.setItem(this.list.size(), itemStack2);
        itemStack = new ItemStack(Material.ARROW);
        itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName("Go back");
        itemStack.setItemMeta(itemMeta);
        this.listEditor.setItem(this.listEditor.getSize() - 1, itemStack);
        this.editor.openInventory(this.listEditor);
    }

    public void addItemForPath(String string) {
        if (this.matchInfo("item") == null) {
            this.keyInfos.add(new KeyInfo(string, Material.CRAFTING_TABLE, "Configure the item", null, "https://wiki.advancedplugins.net/configuration/config-items").setType(KeyType.KEY));
            this.keyInfos.add(new KeyInfo(string + ".type", Material.STICK, "Set item's material", null, "https://wiki.advancedplugins.net/configuration/config-items").setType(KeyType.MATERIAL).addSuggestions(Arrays.stream(Material.values()).map(Enum::name).collect(Collectors.toList())));
            this.keyInfos.add(new KeyInfo(string + ".amount", Material.CHEST, "Set item's amount", null, "https://wiki.advancedplugins.net/configuration/config-items").setType(KeyType.INTEGER).addSuggestions(Arrays.asList("1", "10", "16", "64")));
            this.keyInfos.add(new KeyInfo(string + ".name", Material.PAPER, "Set name", null, "https://wiki.advancedplugins.net/configuration/config-items").setType(KeyType.STRING));
            this.keyInfos.add(new KeyInfo(string + ".lore", Material.BOOK, "Set item's lore", null, "https://wiki.advancedplugins.net/configuration/config-items").setType(KeyType.LIST));
            this.keyInfos.add(new KeyInfo(string + ".force-glow", Material.GLOWSTONE, "Toggle item's glowing status", Arrays.asList("TRUE", "FALSE"), "https://wiki.advancedplugins.net/configuration/config-items").setType(KeyType.BOOLEAN));
            this.keyInfos.add(new KeyInfo(string + ".custom-model-data", Material.COMMAND_BLOCK, "Change item's custom model data", null, "https://wiki.advancedplugins.net/configuration/config-items").setType(KeyType.INTEGER));
            this.keyInfos.add(new KeyInfo(string + ".enchantments", Material.ENCHANTING_TABLE, "Change item's enchantments", null, "https://wiki.advancedplugins.net/configuration/config-items").setType(KeyType.LIST));
            this.keyInfos.add(new KeyInfo(string + ".custom-enchantments", Material.ENCHANTING_TABLE, "Change item's custom enchantments", null, "https://wiki.advancedplugins.net/configuration/config-items").setType(KeyType.LIST));
        }
    }

    public LinkedList<KeyInfo> getKeyInfos() {
        return this.keyInfos;
    }

    public ConfigurationSection getConfig() {
        return this.config;
    }
}

