/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.editor;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public enum KeyType {
    INTEGER{

        @Override
        public boolean validate(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        @Override
        public Object process(String string, ConfigurationSection configurationSection) {
            return Integer.parseInt(string);
        }

        @Override
        public String getFriendlyName() {
            return "Number";
        }
    }
    ,
    BOOLEAN{

        @Override
        public boolean validate(String string) {
            return "true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string);
        }

        @Override
        public Object process(String string, ConfigurationSection configurationSection) {
            return Boolean.parseBoolean(string);
        }

        @Override
        public String getFriendlyName() {
            return "true/false";
        }
    }
    ,
    LIST{

        @Override
        public boolean validate(String string) {
            return true;
        }

        @Override
        public Object process(String string, ConfigurationSection configurationSection) {
            return string;
        }

        @Override
        public String getFriendlyName() {
            return "List";
        }
    }
    ,
    DOUBLE{

        @Override
        public boolean validate(String string) {
            try {
                Double.parseDouble(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        @Override
        public Object process(String string, ConfigurationSection configurationSection) {
            return Double.parseDouble(string);
        }

        @Override
        public String getFriendlyName() {
            return "Decimal number";
        }
    }
    ,
    KEY{

        @Override
        public boolean validate(String string) {
            return true;
        }

        @Override
        public Object process(String string, ConfigurationSection configurationSection) {
            configurationSection.createSection(string);
            return KEY;
        }

        @Override
        public String getFriendlyName() {
            return "Config Section";
        }
    }
    ,
    ITEM{

        @Override
        public boolean validate(String string) {
            return true;
        }

        @Override
        public Object process(String string, ConfigurationSection configurationSection) {
            configurationSection.createSection(string);
            return KEY;
        }

        @Override
        public String getFriendlyName() {
            return "Item";
        }
    }
    ,
    STRING{

        @Override
        public boolean validate(String string) {
            return true;
        }

        @Override
        public Object process(String string, ConfigurationSection configurationSection) {
            return string;
        }

        @Override
        public String getFriendlyName() {
            return "Text";
        }
    }
    ,
    MATERIAL{

        @Override
        public boolean validate(String string) {
            return Material.matchMaterial((String)string) != null;
        }

        @Override
        public Object process(String string, ConfigurationSection configurationSection) {
            return Material.matchMaterial((String)string).name();
        }

        @Override
        public String getFriendlyName() {
            return "Material";
        }
    };


    public abstract String getFriendlyName();

    public abstract boolean validate(String var1);

    public abstract Object process(String var1, ConfigurationSection var2);

    public static KeyType getKeyType(Object object) {
        if (object instanceof Integer) {
            return INTEGER;
        }
        if (object instanceof Boolean) {
            return BOOLEAN;
        }
        if (object instanceof List) {
            return LIST;
        }
        if (object instanceof String) {
            return STRING;
        }
        if (object instanceof ConfigurationSection) {
            return KEY;
        }
        return null;
    }
}

