/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.hooks.plugins;

import com.archyx.aureliumskills.api.event.LootDropCause;
import com.archyx.aureliumskills.api.event.PlayerLootDropEvent;
import com.archyx.aureliumskills.api.event.TerraformBlockBreakEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.LocalLocation;
import net.advancedplugins.bp.impl.utils.SchedulerUtils;
import net.advancedplugins.bp.impl.utils.abilities.DropsSettings;
import net.advancedplugins.bp.impl.utils.abilities.SmeltMaterial;
import net.advancedplugins.bp.impl.utils.hooks.HookPlugin;
import net.advancedplugins.bp.impl.utils.hooks.PluginHookInstance;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class AureliumSkillsHook
extends PluginHookInstance
implements Listener {
    private final ConcurrentHashMap<Vector, BrokenBlockInformation> brokenBlocksMap = new ConcurrentHashMap();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return HookPlugin.AURELIUMSKILLS.getPluginName();
    }

    @EventHandler(ignoreCancelled=true)
    public void onLoot(PlayerLootDropEvent playerLootDropEvent) {
        if (playerLootDropEvent.getCause().equals((Object)LootDropCause.EPIC_CATCH)) {
            return;
        }
        if (playerLootDropEvent.isCancelled()) {
            return;
        }
        if (playerLootDropEvent.getCause().name().contains("CATCH")) {
            return;
        }
        Player player = playerLootDropEvent.getPlayer();
        ItemStack itemStack = playerLootDropEvent.getItemStack();
        Location location = playerLootDropEvent.getLocation().clone();
        playerLootDropEvent.setCancelled(true);
        playerLootDropEvent.setLocation(playerLootDropEvent.getLocation().clone().subtract(0.0, 10000.0, 0.0));
        ASManager.debug("[aureliumskills extra loot] Dropped " + itemStack.getType().name() + " for " + player.getName() + " at " + new LocalLocation(location).getEncode());
        this.executorService.schedule(() -> {
            Vector vector = location.getBlock().getLocation().toVector();
            if (!this.brokenBlocksMap.containsKey(vector)) {
                SchedulerUtils.runTaskLater(() -> location.getWorld().dropItem(location, itemStack));
                return;
            }
            ItemStack itemStack2 = itemStack;
            BrokenBlockInformation brokenBlockInformation = this.brokenBlocksMap.get(vector);
            if (brokenBlockInformation.settings.isSmelt()) {
                itemStack2 = SmeltMaterial.material(itemStack);
            }
            if (brokenBlockInformation.settings.isAddToInventory() && !player.getInventory().addItem(new ItemStack[]{itemStack2}).isEmpty()) {
                if (!Bukkit.isPrimaryThread()) {
                    ItemStack itemStack3 = itemStack2;
                    SchedulerUtils.runTaskLater(() -> ASManager.dropItem(location, itemStack3));
                } else {
                    ASManager.dropItem(location, itemStack2);
                }
            }
        }, 20L, TimeUnit.MILLISECONDS);
    }

    public boolean isTerraformEvent(BlockBreakEvent blockBreakEvent) {
        return blockBreakEvent instanceof TerraformBlockBreakEvent;
    }

    public void addBrokenBlockToMap(Block block, Player player, DropsSettings dropsSettings) {
        Location location = block.getLocation();
        this.brokenBlocksMap.put(location.toVector(), new BrokenBlockInformation(player, dropsSettings));
        this.executorService.schedule(() -> this.brokenBlocksMap.remove(location.toVector()), 2000L, TimeUnit.MILLISECONDS);
    }

    class BrokenBlockInformation {
        public final Player player;
        public final DropsSettings settings;

        public BrokenBlockInformation(Player player, DropsSettings dropsSettings) {
            this.player = player;
            this.settings = dropsSettings;
        }
    }
}

