/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.hooks.plugins;

import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.CustomStack;
import dev.lone.itemsadder.api.Events.CustomBlockBreakEvent;
import java.util.List;
import net.advancedplugins.bp.impl.utils.hooks.HookPlugin;
import net.advancedplugins.bp.impl.utils.hooks.PluginHookInstance;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemsAdderHook
extends PluginHookInstance
implements Listener {
    private final Plugin plugin;

    public ItemsAdderHook(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return HookPlugin.ITEMSADDER.getPluginName();
    }

    public boolean isCustomItem(ItemStack itemStack) {
        return CustomStack.byItemStack((ItemStack)itemStack) != null;
    }

    public boolean isCustomBlock(Block block) {
        return CustomBlock.byAlreadyPlaced((Block)block) != null;
    }

    public List<ItemStack> getLootForCustomBlock(Block block) {
        if (!this.isCustomBlock(block)) {
            return null;
        }
        return CustomBlock.byAlreadyPlaced((Block)block).getLoot();
    }

    public ItemStack setCustomItemDurability(ItemStack itemStack, int n) {
        CustomStack customStack = CustomStack.byItemStack((ItemStack)itemStack);
        customStack.setDurability(n);
        return customStack.getItemStack();
    }

    public ItemStack getByName(String string) {
        CustomStack customStack = CustomStack.getInstance((String)string);
        if (customStack == null) {
            return null;
        }
        return customStack.getItemStack();
    }

    public int getCustomItemDurability(ItemStack itemStack) {
        return CustomStack.byItemStack((ItemStack)itemStack).getDurability();
    }

    public int getCustomItemMaxDurability(ItemStack itemStack) {
        return CustomStack.byItemStack((ItemStack)itemStack).getMaxDurability();
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    private void onCustomBlockBreak(CustomBlockBreakEvent customBlockBreakEvent) {
        Block block = customBlockBreakEvent.getBlock();
        if (block.hasMetadata("telepathy-broken-itemsadder")) {
            block.removeMetadata("telepathy-broken-itemsadder", this.plugin);
            customBlockBreakEvent.setCancelled(true);
            CustomBlock.byAlreadyPlaced((Block)block).remove();
        }
    }
}

