/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.bp.impl.utils.menus.item;

import net.advancedplugins.bp.impl.utils.ASManager;
import net.advancedplugins.bp.impl.utils.items.ConfigItemCreator;
import net.advancedplugins.bp.impl.utils.items.ItemBuilder;
import net.advancedplugins.bp.impl.utils.text.Replace;
import net.advancedplugins.bp.impl.utils.text.Replacer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class AdvancedMenuItem {
    private ConfigurationSection section;
    private Replace replace;
    private int[] slots;
    private String action = null;
    private ItemStack item;
    private boolean glow = false;
    private int amount = 0;

    public AdvancedMenuItem(String string, ConfigurationSection configurationSection, Replace replace) {
        this.slots = ASManager.getSlots(string);
        this.replace = replace;
        this.section = configurationSection;
        if (configurationSection.contains("action")) {
            this.action = configurationSection.getString("action");
        }
    }

    public AdvancedMenuItem(int n, ConfigurationSection configurationSection, Replace replace) {
        this.slots = new int[]{n};
        this.replace = replace;
        this.section = configurationSection;
        if (configurationSection.contains("action")) {
            this.action = configurationSection.getString("action");
        }
    }

    public AdvancedMenuItem(int[] nArray, ConfigurationSection configurationSection, Replace replace) {
        this.slots = nArray;
        this.replace = replace;
        this.section = configurationSection;
        if (configurationSection.contains("action")) {
            this.action = configurationSection.getString("action");
        }
    }

    public AdvancedMenuItem(ItemStack itemStack) {
        this.item = itemStack;
    }

    public void addToInventory(Inventory inventory) {
        ItemStack itemStack = this.getItem();
        for (int n : this.slots) {
            inventory.setItem(n, itemStack);
        }
    }

    public AdvancedMenuItem setGlow() {
        this.glow = true;
        return this;
    }

    public AdvancedMenuItem setAmount(int n) {
        this.amount = n;
        return this;
    }

    public ItemStack getItem() {
        if (this.item != null) {
            return this.item;
        }
        ItemStack itemStack = ConfigItemCreator.fromConfigSection(this.section, "", this.replace == null ? null : ((Replacer)this.replace.apply(new Replacer())).getPlaceholders(), null);
        if (this.glow) {
            ItemBuilder itemBuilder = new ItemBuilder(itemStack);
            itemBuilder.addUnsafeEnchantment(Enchantment.LOOT_BONUS_MOBS, 1);
            itemBuilder.addItemFlag(ItemFlag.HIDE_ENCHANTS);
            itemStack = itemBuilder.toItemStack();
        }
        if (this.amount != 0) {
            itemStack.setAmount(this.amount);
        }
        return itemStack;
    }

    public String getAction() {
        return this.action;
    }
}

