/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.DifferentiableMultivariateFunction;
import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.function.Identity;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;

public class FunctionUtils {
    private FunctionUtils() {
    }

    public static UnivariateFunction compose(final UnivariateFunction ... univariateFunctionArray) {
        return new UnivariateFunction(){

            public double value(double d) {
                double d2 = d;
                for (int i = univariateFunctionArray.length - 1; i >= 0; --i) {
                    d2 = univariateFunctionArray[i].value(d2);
                }
                return d2;
            }
        };
    }

    public static UnivariateDifferentiableFunction compose(final UnivariateDifferentiableFunction ... univariateDifferentiableFunctionArray) {
        return new UnivariateDifferentiableFunction(){

            public double value(double d) {
                double d2 = d;
                for (int i = univariateDifferentiableFunctionArray.length - 1; i >= 0; --i) {
                    d2 = univariateDifferentiableFunctionArray[i].value(d2);
                }
                return d2;
            }

            public DerivativeStructure value(DerivativeStructure derivativeStructure) {
                DerivativeStructure derivativeStructure2 = derivativeStructure;
                for (int i = univariateDifferentiableFunctionArray.length - 1; i >= 0; --i) {
                    derivativeStructure2 = univariateDifferentiableFunctionArray[i].value(derivativeStructure2);
                }
                return derivativeStructure2;
            }
        };
    }

    @Deprecated
    public static DifferentiableUnivariateFunction compose(final DifferentiableUnivariateFunction ... differentiableUnivariateFunctionArray) {
        return new DifferentiableUnivariateFunction(){

            public double value(double d) {
                double d2 = d;
                for (int i = differentiableUnivariateFunctionArray.length - 1; i >= 0; --i) {
                    d2 = differentiableUnivariateFunctionArray[i].value(d2);
                }
                return d2;
            }

            public UnivariateFunction derivative() {
                return new UnivariateFunction(){

                    public double value(double d) {
                        double d2 = 1.0;
                        double d3 = d;
                        for (int i = differentiableUnivariateFunctionArray.length - 1; i >= 0; --i) {
                            d2 *= differentiableUnivariateFunctionArray[i].derivative().value(d3);
                            d3 = differentiableUnivariateFunctionArray[i].value(d3);
                        }
                        return d2;
                    }
                };
            }
        };
    }

    public static UnivariateFunction add(final UnivariateFunction ... univariateFunctionArray) {
        return new UnivariateFunction(){

            public double value(double d) {
                double d2 = univariateFunctionArray[0].value(d);
                for (int i = 1; i < univariateFunctionArray.length; ++i) {
                    d2 += univariateFunctionArray[i].value(d);
                }
                return d2;
            }
        };
    }

    public static UnivariateDifferentiableFunction add(final UnivariateDifferentiableFunction ... univariateDifferentiableFunctionArray) {
        return new UnivariateDifferentiableFunction(){

            public double value(double d) {
                double d2 = univariateDifferentiableFunctionArray[0].value(d);
                for (int i = 1; i < univariateDifferentiableFunctionArray.length; ++i) {
                    d2 += univariateDifferentiableFunctionArray[i].value(d);
                }
                return d2;
            }

            public DerivativeStructure value(DerivativeStructure derivativeStructure) {
                DerivativeStructure derivativeStructure2 = univariateDifferentiableFunctionArray[0].value(derivativeStructure);
                for (int i = 1; i < univariateDifferentiableFunctionArray.length; ++i) {
                    derivativeStructure2 = derivativeStructure2.add(univariateDifferentiableFunctionArray[i].value(derivativeStructure));
                }
                return derivativeStructure2;
            }
        };
    }

    @Deprecated
    public static DifferentiableUnivariateFunction add(final DifferentiableUnivariateFunction ... differentiableUnivariateFunctionArray) {
        return new DifferentiableUnivariateFunction(){

            public double value(double d) {
                double d2 = differentiableUnivariateFunctionArray[0].value(d);
                for (int i = 1; i < differentiableUnivariateFunctionArray.length; ++i) {
                    d2 += differentiableUnivariateFunctionArray[i].value(d);
                }
                return d2;
            }

            public UnivariateFunction derivative() {
                return new UnivariateFunction(){

                    public double value(double d) {
                        double d2 = differentiableUnivariateFunctionArray[0].derivative().value(d);
                        for (int i = 1; i < differentiableUnivariateFunctionArray.length; ++i) {
                            d2 += differentiableUnivariateFunctionArray[i].derivative().value(d);
                        }
                        return d2;
                    }
                };
            }
        };
    }

    public static UnivariateFunction multiply(final UnivariateFunction ... univariateFunctionArray) {
        return new UnivariateFunction(){

            public double value(double d) {
                double d2 = univariateFunctionArray[0].value(d);
                for (int i = 1; i < univariateFunctionArray.length; ++i) {
                    d2 *= univariateFunctionArray[i].value(d);
                }
                return d2;
            }
        };
    }

    public static UnivariateDifferentiableFunction multiply(final UnivariateDifferentiableFunction ... univariateDifferentiableFunctionArray) {
        return new UnivariateDifferentiableFunction(){

            public double value(double d) {
                double d2 = univariateDifferentiableFunctionArray[0].value(d);
                for (int i = 1; i < univariateDifferentiableFunctionArray.length; ++i) {
                    d2 *= univariateDifferentiableFunctionArray[i].value(d);
                }
                return d2;
            }

            public DerivativeStructure value(DerivativeStructure derivativeStructure) {
                DerivativeStructure derivativeStructure2 = univariateDifferentiableFunctionArray[0].value(derivativeStructure);
                for (int i = 1; i < univariateDifferentiableFunctionArray.length; ++i) {
                    derivativeStructure2 = derivativeStructure2.multiply(univariateDifferentiableFunctionArray[i].value(derivativeStructure));
                }
                return derivativeStructure2;
            }
        };
    }

    @Deprecated
    public static DifferentiableUnivariateFunction multiply(final DifferentiableUnivariateFunction ... differentiableUnivariateFunctionArray) {
        return new DifferentiableUnivariateFunction(){

            public double value(double d) {
                double d2 = differentiableUnivariateFunctionArray[0].value(d);
                for (int i = 1; i < differentiableUnivariateFunctionArray.length; ++i) {
                    d2 *= differentiableUnivariateFunctionArray[i].value(d);
                }
                return d2;
            }

            public UnivariateFunction derivative() {
                return new UnivariateFunction(){

                    public double value(double d) {
                        double d2 = 0.0;
                        for (int i = 0; i < differentiableUnivariateFunctionArray.length; ++i) {
                            double d3 = differentiableUnivariateFunctionArray[i].derivative().value(d);
                            for (int j = 0; j < differentiableUnivariateFunctionArray.length; ++j) {
                                if (i == j) continue;
                                d3 *= differentiableUnivariateFunctionArray[j].value(d);
                            }
                            d2 += d3;
                        }
                        return d2;
                    }
                };
            }
        };
    }

    public static UnivariateFunction combine(final BivariateFunction bivariateFunction, final UnivariateFunction univariateFunction, final UnivariateFunction univariateFunction2) {
        return new UnivariateFunction(){

            public double value(double d) {
                return bivariateFunction.value(univariateFunction.value(d), univariateFunction2.value(d));
            }
        };
    }

    public static MultivariateFunction collector(final BivariateFunction bivariateFunction, final UnivariateFunction univariateFunction, final double d) {
        return new MultivariateFunction(){

            public double value(double[] dArray) {
                double d2 = bivariateFunction.value(d, univariateFunction.value(dArray[0]));
                for (int i = 1; i < dArray.length; ++i) {
                    d2 = bivariateFunction.value(d2, univariateFunction.value(dArray[i]));
                }
                return d2;
            }
        };
    }

    public static MultivariateFunction collector(BivariateFunction bivariateFunction, double d) {
        return FunctionUtils.collector(bivariateFunction, new Identity(), d);
    }

    public static UnivariateFunction fix1stArgument(final BivariateFunction bivariateFunction, final double d) {
        return new UnivariateFunction(){

            public double value(double d2) {
                return bivariateFunction.value(d, d2);
            }
        };
    }

    public static UnivariateFunction fix2ndArgument(final BivariateFunction bivariateFunction, final double d) {
        return new UnivariateFunction(){

            public double value(double d2) {
                return bivariateFunction.value(d2, d);
            }
        };
    }

    public static double[] sample(UnivariateFunction univariateFunction, double d, double d2, int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        if (d >= d2) {
            throw new NumberIsTooLargeException(d, (Number)d2, false);
        }
        double[] dArray = new double[n];
        double d3 = (d2 - d) / (double)n;
        for (int i = 0; i < n; ++i) {
            dArray[i] = univariateFunction.value(d + (double)i * d3);
        }
        return dArray;
    }

    @Deprecated
    public static DifferentiableUnivariateFunction toDifferentiableUnivariateFunction(final UnivariateDifferentiableFunction univariateDifferentiableFunction) {
        return new DifferentiableUnivariateFunction(){

            public double value(double d) {
                return univariateDifferentiableFunction.value(d);
            }

            public UnivariateFunction derivative() {
                return new UnivariateFunction(){

                    public double value(double d) {
                        return univariateDifferentiableFunction.value(new DerivativeStructure(1, 1, 0, d)).getPartialDerivative(1);
                    }
                };
            }
        };
    }

    @Deprecated
    public static UnivariateDifferentiableFunction toUnivariateDifferential(final DifferentiableUnivariateFunction differentiableUnivariateFunction) {
        return new UnivariateDifferentiableFunction(){

            public double value(double d) {
                return differentiableUnivariateFunction.value(d);
            }

            public DerivativeStructure value(DerivativeStructure derivativeStructure) {
                switch (derivativeStructure.getOrder()) {
                    case 0: {
                        return new DerivativeStructure(derivativeStructure.getFreeParameters(), 0, differentiableUnivariateFunction.value(derivativeStructure.getValue()));
                    }
                    case 1: {
                        int n = derivativeStructure.getFreeParameters();
                        double[] dArray = new double[n + 1];
                        dArray[0] = differentiableUnivariateFunction.value(derivativeStructure.getValue());
                        double d = differentiableUnivariateFunction.derivative().value(derivativeStructure.getValue());
                        int[] nArray = new int[n];
                        for (int i = 0; i < n; ++i) {
                            nArray[i] = 1;
                            dArray[i + 1] = d * derivativeStructure.getPartialDerivative(nArray);
                            nArray[i] = 0;
                        }
                        return new DerivativeStructure(n, 1, dArray);
                    }
                }
                throw new NumberIsTooLargeException(derivativeStructure.getOrder(), (Number)1, true);
            }
        };
    }

    @Deprecated
    public static DifferentiableMultivariateFunction toDifferentiableMultivariateFunction(final MultivariateDifferentiableFunction multivariateDifferentiableFunction) {
        return new DifferentiableMultivariateFunction(){

            public double value(double[] dArray) {
                return multivariateDifferentiableFunction.value(dArray);
            }

            public MultivariateFunction partialDerivative(final int n) {
                return new MultivariateFunction(){

                    public double value(double[] dArray) {
                        int n2 = dArray.length;
                        DerivativeStructure[] derivativeStructureArray = new DerivativeStructure[n2];
                        for (int i = 0; i < n2; ++i) {
                            derivativeStructureArray[i] = i == n ? new DerivativeStructure(1, 1, 0, dArray[i]) : new DerivativeStructure(1, 1, dArray[i]);
                        }
                        DerivativeStructure derivativeStructure = multivariateDifferentiableFunction.value(derivativeStructureArray);
                        return derivativeStructure.getPartialDerivative(1);
                    }
                };
            }

            public MultivariateVectorFunction gradient() {
                return new MultivariateVectorFunction(){

                    public double[] value(double[] dArray) {
                        int n = dArray.length;
                        DerivativeStructure[] derivativeStructureArray = new DerivativeStructure[n];
                        for (int i = 0; i < n; ++i) {
                            derivativeStructureArray[i] = new DerivativeStructure(n, 1, i, dArray[i]);
                        }
                        DerivativeStructure derivativeStructure = multivariateDifferentiableFunction.value(derivativeStructureArray);
                        double[] dArray2 = new double[n];
                        int[] nArray = new int[n];
                        for (int i = 0; i < n; ++i) {
                            nArray[i] = 1;
                            dArray2[i] = derivativeStructure.getPartialDerivative(nArray);
                            nArray[i] = 0;
                        }
                        return dArray2;
                    }
                };
            }
        };
    }

    @Deprecated
    public static MultivariateDifferentiableFunction toMultivariateDifferentiableFunction(final DifferentiableMultivariateFunction differentiableMultivariateFunction) {
        return new MultivariateDifferentiableFunction(){

            public double value(double[] dArray) {
                return differentiableMultivariateFunction.value(dArray);
            }

            public DerivativeStructure value(DerivativeStructure[] derivativeStructureArray) {
                int n = derivativeStructureArray[0].getFreeParameters();
                int n2 = derivativeStructureArray[0].getOrder();
                int n3 = derivativeStructureArray.length;
                if (n2 > 1) {
                    throw new NumberIsTooLargeException(n2, (Number)1, true);
                }
                for (int i = 0; i < n3; ++i) {
                    if (derivativeStructureArray[i].getFreeParameters() != n) {
                        throw new DimensionMismatchException(derivativeStructureArray[i].getFreeParameters(), n);
                    }
                    if (derivativeStructureArray[i].getOrder() == n2) continue;
                    throw new DimensionMismatchException(derivativeStructureArray[i].getOrder(), n2);
                }
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = derivativeStructureArray[i].getValue();
                }
                double d = differentiableMultivariateFunction.value(dArray);
                double[] dArray2 = differentiableMultivariateFunction.gradient().value(dArray);
                double[] dArray3 = new double[n + 1];
                dArray3[0] = d;
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = 1;
                    for (int j = 0; j < n3; ++j) {
                        int n4 = i + 1;
                        dArray3[n4] = dArray3[n4] + dArray2[j] * derivativeStructureArray[j].getPartialDerivative(nArray);
                    }
                    nArray[i] = 0;
                }
                return new DerivativeStructure(n, n2, dArray3);
            }
        };
    }

    @Deprecated
    public static DifferentiableMultivariateVectorFunction toDifferentiableMultivariateVectorFunction(final MultivariateDifferentiableVectorFunction multivariateDifferentiableVectorFunction) {
        return new DifferentiableMultivariateVectorFunction(){

            public double[] value(double[] dArray) {
                return multivariateDifferentiableVectorFunction.value(dArray);
            }

            public MultivariateMatrixFunction jacobian() {
                return new MultivariateMatrixFunction(){

                    public double[][] value(double[] dArray) {
                        int n = dArray.length;
                        DerivativeStructure[] derivativeStructureArray = new DerivativeStructure[n];
                        for (int i = 0; i < n; ++i) {
                            derivativeStructureArray[i] = new DerivativeStructure(n, 1, i, dArray[i]);
                        }
                        DerivativeStructure[] derivativeStructureArray2 = multivariateDifferentiableVectorFunction.value(derivativeStructureArray);
                        double[][] dArray2 = new double[derivativeStructureArray2.length][n];
                        int[] nArray = new int[n];
                        for (int i = 0; i < derivativeStructureArray2.length; ++i) {
                            for (int j = 0; j < n; ++j) {
                                nArray[j] = 1;
                                dArray2[i][j] = derivativeStructureArray2[i].getPartialDerivative(nArray);
                                nArray[j] = 0;
                            }
                        }
                        return dArray2;
                    }
                };
            }
        };
    }

    @Deprecated
    public static MultivariateDifferentiableVectorFunction toMultivariateDifferentiableVectorFunction(final DifferentiableMultivariateVectorFunction differentiableMultivariateVectorFunction) {
        return new MultivariateDifferentiableVectorFunction(){

            public double[] value(double[] dArray) {
                return differentiableMultivariateVectorFunction.value(dArray);
            }

            public DerivativeStructure[] value(DerivativeStructure[] derivativeStructureArray) {
                int n = derivativeStructureArray[0].getFreeParameters();
                int n2 = derivativeStructureArray[0].getOrder();
                int n3 = derivativeStructureArray.length;
                if (n2 > 1) {
                    throw new NumberIsTooLargeException(n2, (Number)1, true);
                }
                for (int i = 0; i < n3; ++i) {
                    if (derivativeStructureArray[i].getFreeParameters() != n) {
                        throw new DimensionMismatchException(derivativeStructureArray[i].getFreeParameters(), n);
                    }
                    if (derivativeStructureArray[i].getOrder() == n2) continue;
                    throw new DimensionMismatchException(derivativeStructureArray[i].getOrder(), n2);
                }
                double[] dArray = new double[n3];
                for (int i = 0; i < n3; ++i) {
                    dArray[i] = derivativeStructureArray[i].getValue();
                }
                double[] dArray2 = differentiableMultivariateVectorFunction.value(dArray);
                double[][] dArray3 = differentiableMultivariateVectorFunction.jacobian().value(dArray);
                DerivativeStructure[] derivativeStructureArray2 = new DerivativeStructure[dArray2.length];
                for (int i = 0; i < derivativeStructureArray2.length; ++i) {
                    double[] dArray4 = new double[n + 1];
                    dArray4[0] = dArray2[i];
                    int[] nArray = new int[n];
                    for (int j = 0; j < n; ++j) {
                        nArray[j] = 1;
                        for (int k = 0; k < n3; ++k) {
                            int n4 = j + 1;
                            dArray4[n4] = dArray4[n4] + dArray3[i][k] * derivativeStructureArray[k].getPartialDerivative(nArray);
                        }
                        nArray[j] = 0;
                    }
                    derivativeStructureArray2[i] = new DerivativeStructure(n, n2, dArray4);
                }
                return derivativeStructureArray2;
            }
        };
    }
}

