/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import java.io.Serializable;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateMatrixFunction;
import org.apache.commons.math3.analysis.UnivariateVectorFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableMatrixFunction;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import org.apache.commons.math3.analysis.differentiation.UnivariateFunctionDifferentiator;
import org.apache.commons.math3.analysis.differentiation.UnivariateMatrixFunctionDifferentiator;
import org.apache.commons.math3.analysis.differentiation.UnivariateVectorFunctionDifferentiator;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;

public class FiniteDifferencesDifferentiator
implements UnivariateFunctionDifferentiator,
UnivariateVectorFunctionDifferentiator,
UnivariateMatrixFunctionDifferentiator,
Serializable {
    private static final long serialVersionUID = 20120917L;
    private final int nbPoints;
    private final double stepSize;
    private final double halfSampleSpan;
    private final double tMin;
    private final double tMax;

    public FiniteDifferencesDifferentiator(int n, double d) {
        this(n, d, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public FiniteDifferencesDifferentiator(int n, double d, double d2, double d3) {
        if (n <= 1) {
            throw new NumberIsTooSmallException(d, (Number)1, false);
        }
        this.nbPoints = n;
        if (d <= 0.0) {
            throw new NotPositiveException(d);
        }
        this.stepSize = d;
        this.halfSampleSpan = 0.5 * d * (double)(n - 1);
        if (2.0 * this.halfSampleSpan >= d3 - d2) {
            throw new NumberIsTooLargeException(2.0 * this.halfSampleSpan, (Number)(d3 - d2), false);
        }
        double d4 = FastMath.ulp(this.halfSampleSpan);
        this.tMin = d2 + this.halfSampleSpan + d4;
        this.tMax = d3 - this.halfSampleSpan - d4;
    }

    public int getNbPoints() {
        return this.nbPoints;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    private DerivativeStructure evaluate(DerivativeStructure derivativeStructure, double d, double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = new double[this.nbPoints];
        double[] dArray3 = new double[this.nbPoints];
        for (n2 = 0; n2 < this.nbPoints; ++n2) {
            dArray3[n2] = dArray[n2];
            for (n = 1; n <= n2; ++n) {
                dArray3[n2 - n] = (dArray3[n2 - n + 1] - dArray3[n2 - n]) / ((double)n * this.stepSize);
            }
            dArray2[n2] = dArray3[0];
        }
        n2 = derivativeStructure.getOrder();
        n = derivativeStructure.getFreeParameters();
        double[] dArray4 = derivativeStructure.getAllDerivatives();
        double d2 = derivativeStructure.getValue() - d;
        DerivativeStructure derivativeStructure2 = new DerivativeStructure(n, n2, 0.0);
        DerivativeStructure derivativeStructure3 = null;
        for (int i = 0; i < this.nbPoints; ++i) {
            if (i == 0) {
                derivativeStructure3 = new DerivativeStructure(n, n2, 1.0);
            } else {
                dArray4[0] = d2 - (double)(i - 1) * this.stepSize;
                DerivativeStructure derivativeStructure4 = new DerivativeStructure(n, n2, dArray4);
                derivativeStructure3 = derivativeStructure3.multiply(derivativeStructure4);
            }
            derivativeStructure2 = derivativeStructure2.add(derivativeStructure3.multiply(dArray2[i]));
        }
        return derivativeStructure2;
    }

    public UnivariateDifferentiableFunction differentiate(final UnivariateFunction univariateFunction) {
        return new UnivariateDifferentiableFunction(){

            public double value(double d) {
                return univariateFunction.value(d);
            }

            public DerivativeStructure value(DerivativeStructure derivativeStructure) {
                if (derivativeStructure.getOrder() >= FiniteDifferencesDifferentiator.this.nbPoints) {
                    throw new NumberIsTooLargeException(derivativeStructure.getOrder(), (Number)FiniteDifferencesDifferentiator.this.nbPoints, false);
                }
                double d = FastMath.max(FastMath.min(derivativeStructure.getValue(), FiniteDifferencesDifferentiator.this.tMax), FiniteDifferencesDifferentiator.this.tMin) - FiniteDifferencesDifferentiator.this.halfSampleSpan;
                double[] dArray = new double[FiniteDifferencesDifferentiator.this.nbPoints];
                for (int i = 0; i < FiniteDifferencesDifferentiator.this.nbPoints; ++i) {
                    dArray[i] = univariateFunction.value(d + (double)i * FiniteDifferencesDifferentiator.this.stepSize);
                }
                return FiniteDifferencesDifferentiator.this.evaluate(derivativeStructure, d, dArray);
            }
        };
    }

    public UnivariateDifferentiableVectorFunction differentiate(final UnivariateVectorFunction univariateVectorFunction) {
        return new UnivariateDifferentiableVectorFunction(){

            public double[] value(double d) {
                return univariateVectorFunction.value(d);
            }

            public DerivativeStructure[] value(DerivativeStructure derivativeStructure) {
                if (derivativeStructure.getOrder() >= FiniteDifferencesDifferentiator.this.nbPoints) {
                    throw new NumberIsTooLargeException(derivativeStructure.getOrder(), (Number)FiniteDifferencesDifferentiator.this.nbPoints, false);
                }
                double d = FastMath.max(FastMath.min(derivativeStructure.getValue(), FiniteDifferencesDifferentiator.this.tMax), FiniteDifferencesDifferentiator.this.tMin) - FiniteDifferencesDifferentiator.this.halfSampleSpan;
                double[][] dArray = null;
                for (int i = 0; i < FiniteDifferencesDifferentiator.this.nbPoints; ++i) {
                    double[] dArray2 = univariateVectorFunction.value(d + (double)i * FiniteDifferencesDifferentiator.this.stepSize);
                    if (i == 0) {
                        dArray = new double[dArray2.length][FiniteDifferencesDifferentiator.this.nbPoints];
                    }
                    for (int j = 0; j < dArray2.length; ++j) {
                        dArray[j][i] = dArray2[j];
                    }
                }
                DerivativeStructure[] derivativeStructureArray = new DerivativeStructure[dArray.length];
                for (int i = 0; i < derivativeStructureArray.length; ++i) {
                    derivativeStructureArray[i] = FiniteDifferencesDifferentiator.this.evaluate(derivativeStructure, d, dArray[i]);
                }
                return derivativeStructureArray;
            }
        };
    }

    public UnivariateDifferentiableMatrixFunction differentiate(final UnivariateMatrixFunction univariateMatrixFunction) {
        return new UnivariateDifferentiableMatrixFunction(){

            public double[][] value(double d) {
                return univariateMatrixFunction.value(d);
            }

            public DerivativeStructure[][] value(DerivativeStructure derivativeStructure) {
                int n;
                if (derivativeStructure.getOrder() >= FiniteDifferencesDifferentiator.this.nbPoints) {
                    throw new NumberIsTooLargeException(derivativeStructure.getOrder(), (Number)FiniteDifferencesDifferentiator.this.nbPoints, false);
                }
                double d = FastMath.max(FastMath.min(derivativeStructure.getValue(), FiniteDifferencesDifferentiator.this.tMax), FiniteDifferencesDifferentiator.this.tMin) - FiniteDifferencesDifferentiator.this.halfSampleSpan;
                double[][][] dArray = null;
                for (int i = 0; i < FiniteDifferencesDifferentiator.this.nbPoints; ++i) {
                    double[][] dArray2 = univariateMatrixFunction.value(d + (double)i * FiniteDifferencesDifferentiator.this.stepSize);
                    if (i == 0) {
                        dArray = new double[dArray2.length][dArray2[0].length][FiniteDifferencesDifferentiator.this.nbPoints];
                    }
                    for (n = 0; n < dArray2.length; ++n) {
                        for (int j = 0; j < dArray2[n].length; ++j) {
                            dArray[n][j][i] = dArray2[n][j];
                        }
                    }
                }
                DerivativeStructure[][] derivativeStructureArray = new DerivativeStructure[dArray.length][dArray[0].length];
                for (int i = 0; i < derivativeStructureArray.length; ++i) {
                    for (n = 0; n < dArray[i].length; ++n) {
                        derivativeStructureArray[i][n] = FiniteDifferencesDifferentiator.this.evaluate(derivativeStructure, d, dArray[i][n]);
                    }
                }
                return derivativeStructureArray;
            }
        };
    }
}

