/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import java.util.Arrays;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class Gaussian
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double mean;
    private final double is;
    private final double i2s2;
    private final double norm;

    public Gaussian(double d, double d2, double d3) {
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException(d3);
        }
        this.norm = d;
        this.mean = d2;
        this.is = 1.0 / d3;
        this.i2s2 = 0.5 * this.is * this.is;
    }

    public Gaussian(double d, double d2) {
        this(1.0 / (d2 * FastMath.sqrt(Math.PI * 2)), d, d2);
    }

    public Gaussian() {
        this(0.0, 1.0);
    }

    public double value(double d) {
        return Gaussian.value(d - this.mean, this.norm, this.i2s2);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double d, double d2, double d3) {
        return d2 * FastMath.exp(-d * d * d3);
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        double d = this.is * (derivativeStructure.getValue() - this.mean);
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = 1.0;
        double d2 = d * d;
        double d3 = this.norm * FastMath.exp(-0.5 * d2);
        if (d3 <= Precision.SAFE_MIN) {
            Arrays.fill(dArray, 0.0);
        } else {
            dArray[0] = d3;
            for (int i = 1; i < dArray.length; ++i) {
                double d4 = 0.0;
                dArray2[i] = -dArray2[i - 1];
                for (int j = i; j >= 0; j -= 2) {
                    d4 = d4 * d2 + dArray2[j];
                    if (j > 2) {
                        dArray2[j - 2] = (double)(j - 1) * dArray2[j - 1] - dArray2[j - 3];
                        continue;
                    }
                    if (j != 2) continue;
                    dArray2[0] = dArray2[1];
                }
                if ((i & 1) == 1) {
                    d4 *= d;
                }
                dArray[i] = (d3 *= this.is) * d4;
            }
        }
        return derivativeStructure.compose(dArray);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double d, double ... dArray) {
            this.validateParameters(dArray);
            double d2 = d - dArray[1];
            double d3 = 1.0 / (2.0 * dArray[2] * dArray[2]);
            return Gaussian.value(d2, dArray[0], d3);
        }

        public double[] gradient(double d, double ... dArray) {
            this.validateParameters(dArray);
            double d2 = dArray[0];
            double d3 = d - dArray[1];
            double d4 = dArray[2];
            double d5 = 1.0 / (2.0 * d4 * d4);
            double d6 = Gaussian.value(d3, 1.0, d5);
            double d7 = d2 * d6 * 2.0 * d5 * d3;
            double d8 = d7 * d3 / d4;
            return new double[]{d6, d7, d8};
        }

        private void validateParameters(double[] dArray) {
            if (dArray == null) {
                throw new NullArgumentException();
            }
            if (dArray.length != 3) {
                throw new DimensionMismatchException(dArray.length, 3);
            }
            if (dArray[2] <= 0.0) {
                throw new NotStrictlyPositiveException(dArray[2]);
            }
        }
    }
}

