/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;

public class Logistic
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double a;
    private final double k;
    private final double b;
    private final double oneOverN;
    private final double q;
    private final double m;

    public Logistic(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d6 <= 0.0) {
            throw new NotStrictlyPositiveException(d6);
        }
        this.k = d;
        this.m = d2;
        this.b = d3;
        this.q = d4;
        this.a = d5;
        this.oneOverN = 1.0 / d6;
    }

    public double value(double d) {
        return Logistic.value(this.m - d, this.k, this.b, this.q, this.a, this.oneOverN);
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    private static double value(double d, double d2, double d3, double d4, double d5, double d6) {
        return d5 + (d2 - d5) / FastMath.pow(1.0 + d4 * FastMath.exp(d3 * d), d6);
    }

    public DerivativeStructure value(DerivativeStructure derivativeStructure) {
        return derivativeStructure.negate().add(this.m).multiply(this.b).exp().multiply(this.q).add(1.0).pow(this.oneOverN).reciprocal().multiply(this.k - this.a).add(this.a);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double d, double ... dArray) {
            this.validateParameters(dArray);
            return Logistic.value(dArray[1] - d, dArray[0], dArray[2], dArray[3], dArray[4], 1.0 / dArray[5]);
        }

        public double[] gradient(double d, double ... dArray) {
            this.validateParameters(dArray);
            double d2 = dArray[2];
            double d3 = dArray[3];
            double d4 = dArray[1] - d;
            double d5 = 1.0 / dArray[5];
            double d6 = FastMath.exp(d2 * d4);
            double d7 = d3 * d6;
            double d8 = d7 + 1.0;
            double d9 = (dArray[0] - dArray[4]) * d5 / FastMath.pow(d8, d5);
            double d10 = -d9 / d8;
            double d11 = Logistic.value(d4, 1.0, d2, d3, 0.0, d5);
            double d12 = d10 * d2 * d7;
            double d13 = d10 * d4 * d7;
            double d14 = d10 * d6;
            double d15 = Logistic.value(d4, 0.0, d2, d3, 1.0, d5);
            double d16 = d9 * FastMath.log(d8) * d5;
            return new double[]{d11, d12, d13, d14, d15, d16};
        }

        private void validateParameters(double[] dArray) {
            if (dArray == null) {
                throw new NullArgumentException();
            }
            if (dArray.length != 6) {
                throw new DimensionMismatchException(dArray.length, 6);
            }
            if (dArray[5] <= 0.0) {
                throw new NotStrictlyPositiveException(dArray[5]);
            }
        }
    }
}

