/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration;

import org.apache.commons.math3.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math3.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.util.FastMath;

public class SimpsonIntegrator
extends BaseAbstractUnivariateIntegrator {
    public static final int SIMPSON_MAX_ITERATIONS_COUNT = 64;

    public SimpsonIntegrator(double d, double d2, int n, int n2) {
        super(d, d2, n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public SimpsonIntegrator(int n, int n2) {
        super(n, n2);
        if (n2 > 64) {
            throw new NumberIsTooLargeException(n2, (Number)64, false);
        }
    }

    public SimpsonIntegrator() {
        super(3, 64);
    }

    protected double doIntegrate() {
        TrapezoidIntegrator trapezoidIntegrator = new TrapezoidIntegrator();
        if (this.getMinimalIterationCount() == 1) {
            return (4.0 * trapezoidIntegrator.stage(this, 1) - trapezoidIntegrator.stage(this, 0)) / 3.0;
        }
        double d = 0.0;
        double d2 = trapezoidIntegrator.stage(this, 0);
        while (true) {
            double d3;
            double d4;
            double d5 = trapezoidIntegrator.stage(this, this.getIterations());
            this.incrementCount();
            double d6 = (4.0 * d5 - d2) / 3.0;
            if (this.getIterations() >= this.getMinimalIterationCount() && ((d4 = FastMath.abs(d6 - d)) <= (d3 = this.getRelativeAccuracy() * (FastMath.abs(d) + FastMath.abs(d6)) * 0.5) || d4 <= this.getAbsoluteAccuracy())) {
                return d6;
            }
            d = d6;
            d2 = d5;
        }
    }
}

