/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration.gauss;

import org.apache.commons.math3.analysis.integration.gauss.BaseRuleFactory;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegendreRuleFactory
extends BaseRuleFactory<Double> {
    @Override
    protected Pair<Double[], Double[]> computeRule(int n) {
        if (n == 1) {
            return new Pair<Double[], Double[]>(new Double[]{0.0}, new Double[]{2.0});
        }
        Double[] doubleArray = (Double[])this.getRuleInternal(n - 1).getFirst();
        Double[] doubleArray2 = new Double[n];
        Double[] doubleArray3 = new Double[n];
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            double d = i == 0 ? -1.0 : doubleArray[i - 1];
            double d2 = n2 == 1 ? 1.0 : doubleArray[i];
            double d3 = 1.0;
            double d4 = d;
            double d5 = 1.0;
            double d6 = d2;
            for (int j = 1; j < n; ++j) {
                int n3 = 2 * j + 1;
                int n4 = j + 1;
                double d7 = ((double)n3 * d * d4 - (double)j * d3) / (double)n4;
                double d8 = ((double)n3 * d2 * d6 - (double)j * d5) / (double)n4;
                d3 = d4;
                d4 = d7;
                d5 = d6;
                d6 = d8;
            }
            double d9 = 0.5 * (d + d2);
            double d10 = 1.0;
            double d11 = d9;
            boolean bl = false;
            while (!bl) {
                bl = d2 - d <= Math.ulp(d9);
                d10 = 1.0;
                d11 = d9;
                for (int j = 1; j < n; ++j) {
                    double d12 = ((double)(2 * j + 1) * d9 * d11 - (double)j * d10) / (double)(j + 1);
                    d10 = d11;
                    d11 = d12;
                }
                if (bl) continue;
                if (d4 * d11 <= 0.0) {
                    d2 = d9;
                    d5 = d10;
                    d6 = d11;
                } else {
                    d = d9;
                    d3 = d10;
                    d4 = d11;
                }
                d9 = 0.5 * (d + d2);
            }
            double d13 = (double)n * (d10 - d9 * d11);
            double d14 = 2.0 * (1.0 - d9 * d9) / (d13 * d13);
            doubleArray2[i] = d9;
            doubleArray3[i] = d14;
            int n5 = n - i - 1;
            doubleArray2[n5] = -d9;
            doubleArray3[n5] = d14;
        }
        if (n % 2 != 0) {
            double d = 1.0;
            for (int i = 1; i < n; i += 2) {
                d = (double)(-i) * d / (double)(i + 1);
            }
            double d15 = (double)n * d;
            double d16 = 2.0 / (d15 * d15);
            doubleArray2[n2] = 0.0;
            doubleArray3[n2] = d16;
        }
        return new Pair<Double[], Double[]>(doubleArray2, doubleArray3);
    }
}

