/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.exception.OutOfRangeException;

class BicubicSplineFunction
implements BivariateFunction {
    private static final short N = 4;
    private final double[][] a = new double[4][4];
    private final BivariateFunction partialDerivativeX;
    private final BivariateFunction partialDerivativeY;
    private final BivariateFunction partialDerivativeXX;
    private final BivariateFunction partialDerivativeYY;
    private final BivariateFunction partialDerivativeXY;

    BicubicSplineFunction(double[] dArray) {
        this(dArray, false);
    }

    BicubicSplineFunction(double[] dArray, boolean bl) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.a[i][j] = dArray[i * 4 + j];
            }
        }
        if (bl) {
            final double[][] dArray2 = new double[4][4];
            final double[][] dArray3 = new double[4][4];
            final double[][] dArray4 = new double[4][4];
            final double[][] dArray5 = new double[4][4];
            final double[][] dArray6 = new double[4][4];
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    double d = this.a[i][j];
                    dArray2[i][j] = (double)i * d;
                    dArray3[i][j] = (double)j * d;
                    dArray4[i][j] = (double)(i - 1) * dArray2[i][j];
                    dArray5[i][j] = (double)(j - 1) * dArray3[i][j];
                    dArray6[i][j] = (double)j * dArray2[i][j];
                }
            }
            this.partialDerivativeX = new BivariateFunction(){

                public double value(double d, double d2) {
                    double d3 = d * d;
                    double[] dArray = new double[]{0.0, 1.0, d, d3};
                    double d4 = d2 * d2;
                    double d5 = d4 * d2;
                    double[] dArray22 = new double[]{1.0, d2, d4, d5};
                    return BicubicSplineFunction.this.apply(dArray, dArray22, dArray2);
                }
            };
            this.partialDerivativeY = new BivariateFunction(){

                public double value(double d, double d2) {
                    double d3 = d * d;
                    double d4 = d3 * d;
                    double[] dArray = new double[]{1.0, d, d3, d4};
                    double d5 = d2 * d2;
                    double[] dArray2 = new double[]{0.0, 1.0, d2, d5};
                    return BicubicSplineFunction.this.apply(dArray, dArray2, dArray3);
                }
            };
            this.partialDerivativeXX = new BivariateFunction(){

                public double value(double d, double d2) {
                    double[] dArray = new double[]{0.0, 0.0, 1.0, d};
                    double d3 = d2 * d2;
                    double d4 = d3 * d2;
                    double[] dArray2 = new double[]{1.0, d2, d3, d4};
                    return BicubicSplineFunction.this.apply(dArray, dArray2, dArray4);
                }
            };
            this.partialDerivativeYY = new BivariateFunction(){

                public double value(double d, double d2) {
                    double d3 = d * d;
                    double d4 = d3 * d;
                    double[] dArray = new double[]{1.0, d, d3, d4};
                    double[] dArray2 = new double[]{0.0, 0.0, 1.0, d2};
                    return BicubicSplineFunction.this.apply(dArray, dArray2, dArray5);
                }
            };
            this.partialDerivativeXY = new BivariateFunction(){

                public double value(double d, double d2) {
                    double d3 = d * d;
                    double[] dArray = new double[]{0.0, 1.0, d, d3};
                    double d4 = d2 * d2;
                    double[] dArray2 = new double[]{0.0, 1.0, d2, d4};
                    return BicubicSplineFunction.this.apply(dArray, dArray2, dArray6);
                }
            };
        } else {
            this.partialDerivativeX = null;
            this.partialDerivativeY = null;
            this.partialDerivativeXX = null;
            this.partialDerivativeYY = null;
            this.partialDerivativeXY = null;
        }
    }

    public double value(double d, double d2) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        double d3 = d * d;
        double d4 = d3 * d;
        double[] dArray = new double[]{1.0, d, d3, d4};
        double d5 = d2 * d2;
        double d6 = d5 * d2;
        double[] dArray2 = new double[]{1.0, d2, d5, d6};
        return this.apply(dArray, dArray2, this.a);
    }

    private double apply(double[] dArray, double[] dArray2, double[][] dArray3) {
        double d = 0.0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                d += dArray3[i][j] * dArray[i] * dArray2[j];
            }
        }
        return d;
    }

    public BivariateFunction partialDerivativeX() {
        return this.partialDerivativeX;
    }

    public BivariateFunction partialDerivativeY() {
        return this.partialDerivativeY;
    }

    public BivariateFunction partialDerivativeXX() {
        return this.partialDerivativeXX;
    }

    public BivariateFunction partialDerivativeYY() {
        return this.partialDerivativeYY;
    }

    public BivariateFunction partialDerivativeXY() {
        return this.partialDerivativeXY;
    }
}

