/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldHermiteInterpolator<T extends FieldElement<T>> {
    private final List<T> abscissae = new ArrayList<T>();
    private final List<T[]> topDiagonal = new ArrayList<T[]>();
    private final List<T[]> bottomDiagonal = new ArrayList<T[]>();

    public void addSamplePoint(T t, T[] ... TArray) {
        MathUtils.checkNotNull(t);
        FieldElement fieldElement = (FieldElement)t.getField().getOne();
        for (int i = 0; i < TArray.length; ++i) {
            FieldElement[] fieldElementArray = (FieldElement[])TArray[i].clone();
            if (i > 1) {
                fieldElement = (FieldElement)fieldElement.multiply(i);
                FieldElement fieldElement2 = (FieldElement)fieldElement.reciprocal();
                for (int j = 0; j < fieldElementArray.length; ++j) {
                    fieldElementArray[j] = fieldElementArray[j].multiply(fieldElement2);
                }
            }
            int n = this.abscissae.size();
            this.bottomDiagonal.add(n - i, fieldElementArray);
            FieldElement[] fieldElementArray2 = fieldElementArray;
            for (int j = i; j < n; ++j) {
                FieldElement[] fieldElementArray3 = (FieldElement[])this.bottomDiagonal.get(n - (j + 1));
                if (t.equals(this.abscissae.get(n - (j + 1)))) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, t);
                }
                FieldElement fieldElement3 = (FieldElement)((FieldElement)t.subtract(this.abscissae.get(n - (j + 1)))).reciprocal();
                for (int k = 0; k < fieldElementArray.length; ++k) {
                    fieldElementArray3[k] = fieldElement3.multiply(fieldElementArray2[k].subtract(fieldElementArray3[k]));
                }
                fieldElementArray2 = fieldElementArray3;
            }
            this.topDiagonal.add((T[])fieldElementArray2.clone());
            this.abscissae.add(t);
        }
    }

    public T[] value(T t) {
        MathUtils.checkNotNull(t);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(t.getField(), ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement fieldElement = (FieldElement)t.getField().getOne();
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            FieldElement[] fieldElementArray2 = (FieldElement[])this.topDiagonal.get(i);
            for (int j = 0; j < fieldElementArray.length; ++j) {
                fieldElementArray[j] = fieldElementArray[j].add(fieldElementArray2[j].multiply(fieldElement));
            }
            FieldElement fieldElement2 = (FieldElement)t.subtract(this.abscissae.get(i));
            fieldElement = fieldElement.multiply(fieldElement2);
        }
        return fieldElementArray;
    }

    public T[][] derivatives(T t, int n) {
        MathUtils.checkNotNull(t);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement fieldElement = (FieldElement)t.getField().getZero();
        FieldElement fieldElement2 = (FieldElement)t.getField().getOne();
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(t.getField(), n + 1);
        fieldElementArray[0] = fieldElement;
        for (int i = 0; i < n; ++i) {
            fieldElementArray[i + 1] = fieldElementArray[i].add(fieldElement2);
        }
        FieldElement[][] fieldElementArray2 = (FieldElement[][])MathArrays.buildArray(t.getField(), n + 1, ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement[] fieldElementArray3 = (FieldElement[])MathArrays.buildArray(t.getField(), n + 1);
        fieldElementArray3[0] = (FieldElement)t.getField().getOne();
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            FieldElement[] fieldElementArray4 = (FieldElement[])this.topDiagonal.get(i);
            FieldElement fieldElement3 = (FieldElement)t.subtract(this.abscissae.get(i));
            for (int j = n; j >= 0; --j) {
                for (int k = 0; k < fieldElementArray2[j].length; ++k) {
                    fieldElementArray2[j][k] = fieldElementArray2[j][k].add(fieldElementArray4[k].multiply(fieldElementArray3[j]));
                }
                fieldElementArray3[j] = fieldElementArray3[j].multiply(fieldElement3);
                if (j <= 0) continue;
                fieldElementArray3[j] = fieldElementArray3[j].add(fieldElementArray[j].multiply(fieldElementArray3[j - 1]));
            }
        }
        return fieldElementArray2;
    }
}

