/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.random.UnitSphereRandomVectorGenerator;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class InterpolatingMicrosphere {
    private final List<Facet> microsphere;
    private final List<FacetData> microsphereData;
    private final int dimension;
    private final int size;
    private final double maxDarkFraction;
    private final double darkThreshold;
    private final double background;

    protected InterpolatingMicrosphere(int n, int n2, double d, double d2, double d3) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException(n);
        }
        if (n2 <= 0) {
            throw new NotStrictlyPositiveException(n2);
        }
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        if (d2 < 0.0) {
            throw new NotPositiveException(d2);
        }
        this.dimension = n;
        this.size = n2;
        this.maxDarkFraction = d;
        this.darkThreshold = d2;
        this.background = d3;
        this.microsphere = new ArrayList<Facet>(n2);
        this.microsphereData = new ArrayList<FacetData>(n2);
    }

    public InterpolatingMicrosphere(int n, int n2, double d, double d2, double d3, UnitSphereRandomVectorGenerator unitSphereRandomVectorGenerator) {
        this(n, n2, d, d2, d3);
        for (int i = 0; i < n2; ++i) {
            this.add(unitSphereRandomVectorGenerator.nextVector(), false);
        }
    }

    protected InterpolatingMicrosphere(InterpolatingMicrosphere interpolatingMicrosphere) {
        this.dimension = interpolatingMicrosphere.dimension;
        this.size = interpolatingMicrosphere.size;
        this.maxDarkFraction = interpolatingMicrosphere.maxDarkFraction;
        this.darkThreshold = interpolatingMicrosphere.darkThreshold;
        this.background = interpolatingMicrosphere.background;
        this.microsphere = interpolatingMicrosphere.microsphere;
        this.microsphereData = new ArrayList<FacetData>(this.size);
        for (FacetData facetData : interpolatingMicrosphere.microsphereData) {
            this.microsphereData.add(new FacetData(facetData.illumination(), facetData.sample()));
        }
    }

    public InterpolatingMicrosphere copy() {
        return new InterpolatingMicrosphere(this);
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getSize() {
        return this.size;
    }

    public double value(double[] dArray, double[][] dArray2, double[] dArray3, double d, double d2) {
        if (d < 0.0) {
            throw new NotPositiveException(d);
        }
        this.clear();
        int n = dArray2.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray4 = MathArrays.ebeSubtract(dArray2[i], dArray);
            double d3 = MathArrays.safeNorm(dArray4);
            if (FastMath.abs(d3) < d2) {
                return dArray3[i];
            }
            double d4 = FastMath.pow(d3, -d);
            this.illuminate(dArray4, dArray3[i], d4);
        }
        return this.interpolate();
    }

    protected void add(double[] dArray, boolean bl) {
        if (this.microsphere.size() >= this.size) {
            throw new MaxCountExceededException(this.size);
        }
        if (dArray.length > this.dimension) {
            throw new DimensionMismatchException(dArray.length, this.dimension);
        }
        this.microsphere.add(new Facet(bl ? (double[])dArray.clone() : dArray));
        this.microsphereData.add(new FacetData(0.0, 0.0));
    }

    private double interpolate() {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (FacetData facetData : this.microsphereData) {
            double d3 = facetData.illumination();
            if (d3 != 0.0) {
                d += d3 * facetData.sample();
                d2 += d3;
                continue;
            }
            ++n;
        }
        double d4 = (double)n / (double)this.size;
        return d4 <= this.maxDarkFraction ? d / d2 : this.background;
    }

    private void illuminate(double[] dArray, double d, double d2) {
        for (int i = 0; i < this.size; ++i) {
            double d3;
            double[] dArray2 = this.microsphere.get(i).getNormal();
            double d4 = MathArrays.cosAngle(dArray2, dArray);
            if (!(d4 > 0.0) || !((d3 = d4 * d2) > this.darkThreshold) || !(d3 > this.microsphereData.get(i).illumination())) continue;
            this.microsphereData.set(i, new FacetData(d3, d));
        }
    }

    private void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.microsphereData.set(i, new FacetData(0.0, 0.0));
        }
    }

    private static class FacetData {
        private final double illumination;
        private final double sample;

        FacetData(double d, double d2) {
            this.illumination = d;
            this.sample = d2;
        }

        public double illumination() {
            return this.illumination;
        }

        public double sample() {
            return this.sample;
        }
    }

    private static class Facet {
        private final double[] normal;

        Facet(double[] dArray) {
            this.normal = dArray;
        }

        public double[] getNormal() {
            return this.normal;
        }
    }
}

