/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.random.UnitSphereRandomVectorGenerator;
import org.apache.commons.math3.util.FastMath;

@Deprecated
public class MicrosphereInterpolatingFunction
implements MultivariateFunction {
    private final int dimension;
    private final List<MicrosphereSurfaceElement> microsphere;
    private final double brightnessExponent;
    private final Map<RealVector, Double> samples;

    public MicrosphereInterpolatingFunction(double[][] dArray, double[] dArray2, int n, int n2, UnitSphereRandomVectorGenerator unitSphereRandomVectorGenerator) {
        int n3;
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        if (dArray[0] == null) {
            throw new NullArgumentException();
        }
        this.dimension = dArray[0].length;
        this.brightnessExponent = n;
        this.samples = new HashMap<RealVector, Double>(dArray2.length);
        for (n3 = 0; n3 < dArray.length; ++n3) {
            double[] dArray3 = dArray[n3];
            if (dArray3 == null) {
                throw new NullArgumentException();
            }
            if (dArray3.length != this.dimension) {
                throw new DimensionMismatchException(dArray3.length, this.dimension);
            }
            this.samples.put(new ArrayRealVector(dArray3), dArray2[n3]);
        }
        this.microsphere = new ArrayList<MicrosphereSurfaceElement>(n2);
        for (n3 = 0; n3 < n2; ++n3) {
            this.microsphere.add(new MicrosphereSurfaceElement(unitSphereRandomVectorGenerator.nextVector()));
        }
    }

    public double value(double[] dArray) {
        ArrayRealVector arrayRealVector = new ArrayRealVector(dArray);
        for (MicrosphereSurfaceElement object : this.microsphere) {
            object.reset();
        }
        for (Map.Entry entry : this.samples.entrySet()) {
            RealVector realVector = ((RealVector)entry.getKey()).subtract(arrayRealVector);
            double d = realVector.getNorm();
            if (FastMath.abs(d) < FastMath.ulp(1.0)) {
                return (Double)entry.getValue();
            }
            for (MicrosphereSurfaceElement microsphereSurfaceElement : this.microsphere) {
                double d2 = FastMath.pow(d, -this.brightnessExponent);
                microsphereSurfaceElement.store(this.cosAngle(realVector, microsphereSurfaceElement.normal()) * d2, entry);
            }
        }
        double d = 0.0;
        double d3 = 0.0;
        for (MicrosphereSurfaceElement microsphereSurfaceElement : this.microsphere) {
            double d4 = microsphereSurfaceElement.illumination();
            Map.Entry<RealVector, Double> entry = microsphereSurfaceElement.sample();
            if (entry == null) continue;
            d += d4 * entry.getValue();
            d3 += d4;
        }
        return d / d3;
    }

    private double cosAngle(RealVector realVector, RealVector realVector2) {
        return realVector.dotProduct(realVector2) / (realVector.getNorm() * realVector2.getNorm());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MicrosphereSurfaceElement {
        private final RealVector normal;
        private double brightestIllumination;
        private Map.Entry<RealVector, Double> brightestSample;

        MicrosphereSurfaceElement(double[] dArray) {
            this.normal = new ArrayRealVector(dArray);
        }

        RealVector normal() {
            return this.normal;
        }

        void reset() {
            this.brightestIllumination = 0.0;
            this.brightestSample = null;
        }

        void store(double d, Map.Entry<RealVector, Double> entry) {
            if (d > this.brightestIllumination) {
                this.brightestIllumination = d;
                this.brightestSample = entry;
            }
        }

        double illumination() {
            return this.brightestIllumination;
        }

        Map.Entry<RealVector, Double> sample() {
            return this.brightestSample;
        }
    }
}

