/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.interpolation.TricubicInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.TrivariateGridInterpolator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.util.MathArrays;

public class TricubicInterpolator
implements TrivariateGridInterpolator {
    public TricubicInterpolatingFunction interpolate(final double[] dArray, final double[] dArray2, final double[] dArray3, double[][][] dArray4) {
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0 || dArray4.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray4.length) {
            throw new DimensionMismatchException(dArray.length, dArray4.length);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        MathArrays.checkOrder(dArray3);
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = dArray3.length;
        double[][][] dArray5 = new double[n][n2][n3];
        double[][][] dArray6 = new double[n][n2][n3];
        double[][][] dArray7 = new double[n][n2][n3];
        double[][][] dArray8 = new double[n][n2][n3];
        double[][][] dArray9 = new double[n][n2][n3];
        double[][][] dArray10 = new double[n][n2][n3];
        double[][][] dArray11 = new double[n][n2][n3];
        for (int i = 1; i < n - 1; ++i) {
            if (dArray2.length != dArray4[i].length) {
                throw new DimensionMismatchException(dArray2.length, dArray4[i].length);
            }
            int n4 = i + 1;
            int n5 = i - 1;
            double d = dArray[n4];
            double d2 = dArray[n5];
            double d3 = d - d2;
            for (int j = 1; j < n2 - 1; ++j) {
                if (dArray3.length != dArray4[i][j].length) {
                    throw new DimensionMismatchException(dArray3.length, dArray4[i][j].length);
                }
                int n6 = j + 1;
                int n7 = j - 1;
                double d4 = dArray2[n6];
                double d5 = dArray2[n7];
                double d6 = d4 - d5;
                double d7 = d3 * d6;
                for (int k = 1; k < n3 - 1; ++k) {
                    int n8 = k + 1;
                    int n9 = k - 1;
                    double d8 = dArray3[n8];
                    double d9 = dArray3[n9];
                    double d10 = d8 - d9;
                    dArray5[i][j][k] = (dArray4[n4][j][k] - dArray4[n5][j][k]) / d3;
                    dArray6[i][j][k] = (dArray4[i][n6][k] - dArray4[i][n7][k]) / d6;
                    dArray7[i][j][k] = (dArray4[i][j][n8] - dArray4[i][j][n9]) / d10;
                    double d11 = d3 * d10;
                    double d12 = d6 * d10;
                    dArray8[i][j][k] = (dArray4[n4][n6][k] - dArray4[n4][n7][k] - dArray4[n5][n6][k] + dArray4[n5][n7][k]) / d7;
                    dArray9[i][j][k] = (dArray4[n4][j][n8] - dArray4[n4][j][n9] - dArray4[n5][j][n8] + dArray4[n5][j][n9]) / d11;
                    dArray10[i][j][k] = (dArray4[i][n6][n8] - dArray4[i][n6][n9] - dArray4[i][n7][n8] + dArray4[i][n7][n9]) / d12;
                    double d13 = d7 * d10;
                    dArray11[i][j][k] = (dArray4[n4][n6][n8] - dArray4[n4][n7][n8] - dArray4[n5][n6][n8] + dArray4[n5][n7][n8] - dArray4[n4][n6][n9] + dArray4[n4][n7][n9] + dArray4[n5][n6][n9] - dArray4[n5][n7][n9]) / d13;
                }
            }
        }
        return new TricubicInterpolatingFunction(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9, dArray10, dArray11){

            public boolean isValidPoint(double d, double d2, double d3) {
                return !(d < dArray[1] || d > dArray[dArray.length - 2] || d2 < dArray2[1] || d2 > dArray2[dArray2.length - 2] || d3 < dArray3[1]) && !(d3 > dArray3[dArray3.length - 2]);
            }
        };
    }
}

