/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.util.FastMath;

public class BisectionSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BisectionSolver() {
        this(1.0E-6);
    }

    public BisectionSolver(double d) {
        super(d);
    }

    public BisectionSolver(double d, double d2) {
        super(d, d2);
    }

    protected double doSolve() {
        double d;
        double d2 = this.getMin();
        double d3 = this.getMax();
        this.verifyInterval(d2, d3);
        double d4 = this.getAbsoluteAccuracy();
        do {
            d = UnivariateSolverUtils.midpoint(d2, d3);
            double d5 = this.computeObjectiveValue(d2);
            double d6 = this.computeObjectiveValue(d);
            if (d6 * d5 > 0.0) {
                d2 = d;
                continue;
            }
            d3 = d;
        } while (!(FastMath.abs(d3 - d2) <= d4));
        d = UnivariateSolverUtils.midpoint(d2, d3);
        return d;
    }
}

