/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.util.FastMath;

public class MullerSolver2
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public MullerSolver2() {
        this(1.0E-6);
    }

    public MullerSolver2(double d) {
        super(d);
    }

    public MullerSolver2(double d, double d2) {
        super(d, d2);
    }

    protected double doSolve() {
        double d = this.getMin();
        double d2 = this.getMax();
        this.verifyInterval(d, d2);
        double d3 = this.getRelativeAccuracy();
        double d4 = this.getAbsoluteAccuracy();
        double d5 = this.getFunctionValueAccuracy();
        double d6 = d;
        double d7 = this.computeObjectiveValue(d6);
        if (FastMath.abs(d7) < d5) {
            return d6;
        }
        double d8 = d2;
        double d9 = this.computeObjectiveValue(d8);
        if (FastMath.abs(d9) < d5) {
            return d8;
        }
        if (d7 * d9 > 0.0) {
            throw new NoBracketingException(d6, d8, d7, d9);
        }
        double d10 = 0.5 * (d6 + d8);
        double d11 = this.computeObjectiveValue(d10);
        double d12 = Double.POSITIVE_INFINITY;
        while (true) {
            double d13;
            double d14;
            double d15;
            double d16;
            double d17;
            double d18;
            double d19;
            double d20;
            double d21;
            if ((d21 = (d20 = (2.0 * (d19 = (d10 - d8) / (d8 - d6)) + 1.0) * d11 - (1.0 + d19) * (1.0 + d19) * d9 + d19 * d19 * d7) * d20 - 4.0 * (d18 = d19 * (d11 - (1.0 + d19) * d9 + d19 * d7)) * (d17 = (1.0 + d19) * d11)) >= 0.0) {
                d16 = d20 + FastMath.sqrt(d21);
                d15 = d20 - FastMath.sqrt(d21);
                d14 = FastMath.abs(d16) > FastMath.abs(d15) ? d16 : d15;
            } else {
                d14 = FastMath.sqrt(d20 * d20 - d21);
            }
            if (d14 != 0.0) {
                for (d13 = d10 - 2.0 * d17 * (d10 - d8) / d14; d13 == d8 || d13 == d10; d13 += d4) {
                }
            } else {
                d13 = d + FastMath.random() * (d2 - d);
                d12 = Double.POSITIVE_INFINITY;
            }
            d16 = this.computeObjectiveValue(d13);
            d15 = FastMath.max(d3 * FastMath.abs(d13), d4);
            if (FastMath.abs(d13 - d12) <= d15 || FastMath.abs(d16) <= d5) {
                return d13;
            }
            d6 = d8;
            d7 = d9;
            d8 = d10;
            d9 = d11;
            d10 = d13;
            d11 = d16;
            d12 = d13;
        }
    }
}

