/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.util.FastMath;

public class SecantSolver
extends AbstractUnivariateSolver {
    protected static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public SecantSolver() {
        super(1.0E-6);
    }

    public SecantSolver(double d) {
        super(d);
    }

    public SecantSolver(double d, double d2) {
        super(d, d2);
    }

    protected final double doSolve() {
        double d = this.getMin();
        double d2 = this.getMax();
        double d3 = this.computeObjectiveValue(d);
        double d4 = this.computeObjectiveValue(d2);
        if (d3 == 0.0) {
            return d;
        }
        if (d4 == 0.0) {
            return d2;
        }
        this.verifyBracketing(d, d2);
        double d5 = this.getFunctionValueAccuracy();
        double d6 = this.getAbsoluteAccuracy();
        double d7 = this.getRelativeAccuracy();
        do {
            double d8;
            double d9;
            if ((d9 = this.computeObjectiveValue(d8 = d2 - d4 * (d2 - d) / (d4 - d3))) == 0.0) {
                return d8;
            }
            d = d2;
            d3 = d4;
            d2 = d8;
            d4 = d9;
            if (!(FastMath.abs(d4) <= d5)) continue;
            return d2;
        } while (!(FastMath.abs(d2 - d) < FastMath.max(d7 * FastMath.abs(d2), d6)));
        return d2;
    }
}

