/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.complex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.complex.ComplexField;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Complex
implements FieldElement<Complex>,
Serializable {
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex NaN = new Complex(Double.NaN, Double.NaN);
    public static final Complex INF = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    private static final long serialVersionUID = -6195664516687396620L;
    private final double imaginary;
    private final double real;
    private final transient boolean isNaN;
    private final transient boolean isInfinite;

    public Complex(double d) {
        this(d, 0.0);
    }

    public Complex(double d, double d2) {
        this.real = d;
        this.imaginary = d2;
        this.isNaN = Double.isNaN(d) || Double.isNaN(d2);
        this.isInfinite = !this.isNaN && (Double.isInfinite(d) || Double.isInfinite(d2));
    }

    public double abs() {
        if (this.isNaN) {
            return Double.NaN;
        }
        if (this.isInfinite()) {
            return Double.POSITIVE_INFINITY;
        }
        if (FastMath.abs(this.real) < FastMath.abs(this.imaginary)) {
            if (this.imaginary == 0.0) {
                return FastMath.abs(this.real);
            }
            double d = this.real / this.imaginary;
            return FastMath.abs(this.imaginary) * FastMath.sqrt(1.0 + d * d);
        }
        if (this.real == 0.0) {
            return FastMath.abs(this.imaginary);
        }
        double d = this.imaginary / this.real;
        return FastMath.abs(this.real) * FastMath.sqrt(1.0 + d * d);
    }

    @Override
    public Complex add(Complex complex) {
        MathUtils.checkNotNull(complex);
        if (this.isNaN || complex.isNaN) {
            return NaN;
        }
        return this.createComplex(this.real + complex.getReal(), this.imaginary + complex.getImaginary());
    }

    @Override
    public Complex add(double d) {
        if (this.isNaN || Double.isNaN(d)) {
            return NaN;
        }
        return this.createComplex(this.real + d, this.imaginary);
    }

    public Complex conjugate() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(this.real, -this.imaginary);
    }

    @Override
    public Complex divide(Complex complex) {
        MathUtils.checkNotNull(complex);
        if (this.isNaN || complex.isNaN) {
            return NaN;
        }
        double d = complex.getReal();
        double d2 = complex.getImaginary();
        if (d == 0.0 && d2 == 0.0) {
            return NaN;
        }
        if (complex.isInfinite() && !this.isInfinite()) {
            return ZERO;
        }
        if (FastMath.abs(d) < FastMath.abs(d2)) {
            double d3 = d / d2;
            double d4 = d * d3 + d2;
            return this.createComplex((this.real * d3 + this.imaginary) / d4, (this.imaginary * d3 - this.real) / d4);
        }
        double d5 = d2 / d;
        double d6 = d2 * d5 + d;
        return this.createComplex((this.imaginary * d5 + this.real) / d6, (this.imaginary - this.real * d5) / d6);
    }

    @Override
    public Complex divide(double d) {
        if (this.isNaN || Double.isNaN(d)) {
            return NaN;
        }
        if (d == 0.0) {
            return NaN;
        }
        if (Double.isInfinite(d)) {
            return !this.isInfinite() ? ZERO : NaN;
        }
        return this.createComplex(this.real / d, this.imaginary / d);
    }

    @Override
    public Complex reciprocal() {
        if (this.isNaN) {
            return NaN;
        }
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return INF;
        }
        if (this.isInfinite) {
            return ZERO;
        }
        if (FastMath.abs(this.real) < FastMath.abs(this.imaginary)) {
            double d = this.real / this.imaginary;
            double d2 = 1.0 / (this.real * d + this.imaginary);
            return this.createComplex(d2 * d, -d2);
        }
        double d = this.imaginary / this.real;
        double d3 = 1.0 / (this.imaginary * d + this.real);
        return this.createComplex(d3, -d3 * d);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            if (complex.isNaN) {
                return this.isNaN;
            }
            return MathUtils.equals(this.real, complex.real) && MathUtils.equals(this.imaginary, complex.imaginary);
        }
        return false;
    }

    public static boolean equals(Complex complex, Complex complex2, int n) {
        return Precision.equals(complex.real, complex2.real, n) && Precision.equals(complex.imaginary, complex2.imaginary, n);
    }

    public static boolean equals(Complex complex, Complex complex2) {
        return Complex.equals(complex, complex2, 1);
    }

    public static boolean equals(Complex complex, Complex complex2, double d) {
        return Precision.equals(complex.real, complex2.real, d) && Precision.equals(complex.imaginary, complex2.imaginary, d);
    }

    public static boolean equalsWithRelativeTolerance(Complex complex, Complex complex2, double d) {
        return Precision.equalsWithRelativeTolerance(complex.real, complex2.real, d) && Precision.equalsWithRelativeTolerance(complex.imaginary, complex2.imaginary, d);
    }

    public int hashCode() {
        if (this.isNaN) {
            return 7;
        }
        return 37 * (17 * MathUtils.hash(this.imaginary) + MathUtils.hash(this.real));
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public double getReal() {
        return this.real;
    }

    public boolean isNaN() {
        return this.isNaN;
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    @Override
    public Complex multiply(Complex complex) {
        MathUtils.checkNotNull(complex);
        if (this.isNaN || complex.isNaN) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary) || Double.isInfinite(complex.real) || Double.isInfinite(complex.imaginary)) {
            return INF;
        }
        return this.createComplex(this.real * complex.real - this.imaginary * complex.imaginary, this.real * complex.imaginary + this.imaginary * complex.real);
    }

    @Override
    public Complex multiply(int n) {
        if (this.isNaN) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary)) {
            return INF;
        }
        return this.createComplex(this.real * (double)n, this.imaginary * (double)n);
    }

    @Override
    public Complex multiply(double d) {
        if (this.isNaN || Double.isNaN(d)) {
            return NaN;
        }
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary) || Double.isInfinite(d)) {
            return INF;
        }
        return this.createComplex(this.real * d, this.imaginary * d);
    }

    @Override
    public Complex negate() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(-this.real, -this.imaginary);
    }

    @Override
    public Complex subtract(Complex complex) {
        MathUtils.checkNotNull(complex);
        if (this.isNaN || complex.isNaN) {
            return NaN;
        }
        return this.createComplex(this.real - complex.getReal(), this.imaginary - complex.getImaginary());
    }

    @Override
    public Complex subtract(double d) {
        if (this.isNaN || Double.isNaN(d)) {
            return NaN;
        }
        return this.createComplex(this.real - d, this.imaginary);
    }

    public Complex acos() {
        if (this.isNaN) {
            return NaN;
        }
        return this.add(this.sqrt1z().multiply(I)).log().multiply(I.negate());
    }

    public Complex asin() {
        if (this.isNaN) {
            return NaN;
        }
        return this.sqrt1z().add(this.multiply(I)).log().multiply(I.negate());
    }

    public Complex atan() {
        if (this.isNaN) {
            return NaN;
        }
        return this.add(I).divide(I.subtract(this)).log().multiply(I.divide(this.createComplex(2.0, 0.0)));
    }

    public Complex cos() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(FastMath.cos(this.real) * FastMath.cosh(this.imaginary), -FastMath.sin(this.real) * FastMath.sinh(this.imaginary));
    }

    public Complex cosh() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(FastMath.cosh(this.real) * FastMath.cos(this.imaginary), FastMath.sinh(this.real) * FastMath.sin(this.imaginary));
    }

    public Complex exp() {
        if (this.isNaN) {
            return NaN;
        }
        double d = FastMath.exp(this.real);
        return this.createComplex(d * FastMath.cos(this.imaginary), d * FastMath.sin(this.imaginary));
    }

    public Complex log() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(FastMath.log(this.abs()), FastMath.atan2(this.imaginary, this.real));
    }

    public Complex pow(Complex complex) {
        MathUtils.checkNotNull(complex);
        return this.log().multiply(complex).exp();
    }

    public Complex pow(double d) {
        return this.log().multiply(d).exp();
    }

    public Complex sin() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(FastMath.sin(this.real) * FastMath.cosh(this.imaginary), FastMath.cos(this.real) * FastMath.sinh(this.imaginary));
    }

    public Complex sinh() {
        if (this.isNaN) {
            return NaN;
        }
        return this.createComplex(FastMath.sinh(this.real) * FastMath.cos(this.imaginary), FastMath.cosh(this.real) * FastMath.sin(this.imaginary));
    }

    public Complex sqrt() {
        if (this.isNaN) {
            return NaN;
        }
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return this.createComplex(0.0, 0.0);
        }
        double d = FastMath.sqrt((FastMath.abs(this.real) + this.abs()) / 2.0);
        if (this.real >= 0.0) {
            return this.createComplex(d, this.imaginary / (2.0 * d));
        }
        return this.createComplex(FastMath.abs(this.imaginary) / (2.0 * d), FastMath.copySign(1.0, this.imaginary) * d);
    }

    public Complex sqrt1z() {
        return this.createComplex(1.0, 0.0).subtract(this.multiply(this)).sqrt();
    }

    public Complex tan() {
        if (this.isNaN || Double.isInfinite(this.real)) {
            return NaN;
        }
        if (this.imaginary > 20.0) {
            return this.createComplex(0.0, 1.0);
        }
        if (this.imaginary < -20.0) {
            return this.createComplex(0.0, -1.0);
        }
        double d = 2.0 * this.real;
        double d2 = 2.0 * this.imaginary;
        double d3 = FastMath.cos(d) + FastMath.cosh(d2);
        return this.createComplex(FastMath.sin(d) / d3, FastMath.sinh(d2) / d3);
    }

    public Complex tanh() {
        if (this.isNaN || Double.isInfinite(this.imaginary)) {
            return NaN;
        }
        if (this.real > 20.0) {
            return this.createComplex(1.0, 0.0);
        }
        if (this.real < -20.0) {
            return this.createComplex(-1.0, 0.0);
        }
        double d = 2.0 * this.real;
        double d2 = 2.0 * this.imaginary;
        double d3 = FastMath.cosh(d) + FastMath.cos(d2);
        return this.createComplex(FastMath.sinh(d) / d3, FastMath.sin(d2) / d3);
    }

    public double getArgument() {
        return FastMath.atan2(this.getImaginary(), this.getReal());
    }

    public List<Complex> nthRoot(int n) {
        if (n <= 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.CANNOT_COMPUTE_NTH_ROOT_FOR_NEGATIVE_N, n);
        }
        ArrayList<Complex> arrayList = new ArrayList<Complex>();
        if (this.isNaN) {
            arrayList.add(NaN);
            return arrayList;
        }
        if (this.isInfinite()) {
            arrayList.add(INF);
            return arrayList;
        }
        double d = FastMath.pow(this.abs(), 1.0 / (double)n);
        double d2 = this.getArgument() / (double)n;
        double d3 = Math.PI * 2 / (double)n;
        double d4 = d2;
        for (int i = 0; i < n; ++i) {
            double d5 = d * FastMath.cos(d4);
            double d6 = d * FastMath.sin(d4);
            arrayList.add(this.createComplex(d5, d6));
            d4 += d3;
        }
        return arrayList;
    }

    protected Complex createComplex(double d, double d2) {
        return new Complex(d, d2);
    }

    public static Complex valueOf(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return NaN;
        }
        return new Complex(d, d2);
    }

    public static Complex valueOf(double d) {
        if (Double.isNaN(d)) {
            return NaN;
        }
        return new Complex(d);
    }

    protected final Object readResolve() {
        return this.createComplex(this.real, this.imaginary);
    }

    public ComplexField getField() {
        return ComplexField.getInstance();
    }

    public String toString() {
        return "(" + this.real + ", " + this.imaginary + ")";
    }
}

