/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.complex;

import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;

public class ComplexUtils {
    private ComplexUtils() {
    }

    public static Complex polar2Complex(double d, double d2) {
        if (d < 0.0) {
            throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_COMPLEX_MODULE, d);
        }
        return new Complex(d * FastMath.cos(d2), d * FastMath.sin(d2));
    }

    public static Complex[] convertToComplex(double[] dArray) {
        Complex[] complexArray = new Complex[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            complexArray[i] = new Complex(dArray[i], 0.0);
        }
        return complexArray;
    }
}

