/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.dfp;

import java.util.Arrays;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.dfp.DfpField;
import org.apache.commons.math3.dfp.DfpMath;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dfp
implements RealFieldElement<Dfp> {
    public static final int RADIX = 10000;
    public static final int MIN_EXP = -32767;
    public static final int MAX_EXP = 32768;
    public static final int ERR_SCALE = 32760;
    public static final byte FINITE = 0;
    public static final byte INFINITE = 1;
    public static final byte SNAN = 2;
    public static final byte QNAN = 3;
    private static final String NAN_STRING = "NaN";
    private static final String POS_INFINITY_STRING = "Infinity";
    private static final String NEG_INFINITY_STRING = "-Infinity";
    private static final String ADD_TRAP = "add";
    private static final String MULTIPLY_TRAP = "multiply";
    private static final String DIVIDE_TRAP = "divide";
    private static final String SQRT_TRAP = "sqrt";
    private static final String ALIGN_TRAP = "align";
    private static final String TRUNC_TRAP = "trunc";
    private static final String NEXT_AFTER_TRAP = "nextAfter";
    private static final String LESS_THAN_TRAP = "lessThan";
    private static final String GREATER_THAN_TRAP = "greaterThan";
    private static final String NEW_INSTANCE_TRAP = "newInstance";
    protected int[] mant;
    protected byte sign;
    protected int exp;
    protected byte nans;
    private final DfpField field;

    protected Dfp(DfpField dfpField) {
        this.mant = new int[dfpField.getRadixDigits()];
        this.sign = 1;
        this.exp = 0;
        this.nans = 0;
        this.field = dfpField;
    }

    protected Dfp(DfpField dfpField, byte by) {
        this(dfpField, (long)by);
    }

    protected Dfp(DfpField dfpField, int n) {
        this(dfpField, (long)n);
    }

    protected Dfp(DfpField dfpField, long l) {
        this.mant = new int[dfpField.getRadixDigits()];
        this.nans = 0;
        this.field = dfpField;
        boolean bl = false;
        if (l == Long.MIN_VALUE) {
            bl = true;
            ++l;
        }
        if (l < 0L) {
            this.sign = (byte)-1;
            l = -l;
        } else {
            this.sign = 1;
        }
        this.exp = 0;
        while (l != 0L) {
            System.arraycopy(this.mant, this.mant.length - this.exp, this.mant, this.mant.length - 1 - this.exp, this.exp);
            this.mant[this.mant.length - 1] = (int)(l % 10000L);
            l /= 10000L;
            ++this.exp;
        }
        if (bl) {
            for (int i = 0; i < this.mant.length - 1; ++i) {
                if (this.mant[i] == 0) continue;
                int n = i;
                this.mant[n] = this.mant[n] + 1;
                break;
            }
        }
    }

    protected Dfp(DfpField dfpField, double d) {
        this.mant = new int[dfpField.getRadixDigits()];
        this.sign = 1;
        this.exp = 0;
        this.nans = 0;
        this.field = dfpField;
        long l = Double.doubleToLongBits(d);
        long l2 = l & 0xFFFFFFFFFFFFFL;
        int n = (int)((l & 0x7FF0000000000000L) >> 52) - 1023;
        if (n == -1023) {
            if (d == 0.0) {
                if ((l & Long.MIN_VALUE) != 0L) {
                    this.sign = (byte)-1;
                }
                return;
            }
            ++n;
            while ((l2 & 0x10000000000000L) == 0L) {
                --n;
                l2 <<= 1;
            }
            l2 &= 0xFFFFFFFFFFFFFL;
        }
        if (n == 1024) {
            if (d != d) {
                this.sign = 1;
                this.nans = (byte)3;
            } else if (d < 0.0) {
                this.sign = (byte)-1;
                this.nans = 1;
            } else {
                this.sign = 1;
                this.nans = 1;
            }
            return;
        }
        Dfp dfp = new Dfp(dfpField, l2);
        dfp = dfp.divide(new Dfp(dfpField, 0x10000000000000L)).add(dfpField.getOne());
        dfp = dfp.multiply(DfpMath.pow(dfpField.getTwo(), n));
        if ((l & Long.MIN_VALUE) != 0L) {
            dfp = dfp.negate();
        }
        System.arraycopy(dfp.mant, 0, this.mant, 0, this.mant.length);
        this.sign = dfp.sign;
        this.exp = dfp.exp;
        this.nans = dfp.nans;
    }

    public Dfp(Dfp dfp) {
        this.mant = (int[])dfp.mant.clone();
        this.sign = dfp.sign;
        this.exp = dfp.exp;
        this.nans = dfp.nans;
        this.field = dfp.field;
    }

    protected Dfp(DfpField dfpField, String string) {
        int n;
        int n2;
        String string2;
        this.mant = new int[dfpField.getRadixDigits()];
        this.sign = 1;
        this.exp = 0;
        this.nans = 0;
        this.field = dfpField;
        boolean bl = false;
        int n3 = 4;
        int n4 = 4;
        char[] cArray = new char[this.getRadixDigits() * 4 + 8];
        if (string.equals(POS_INFINITY_STRING)) {
            this.sign = 1;
            this.nans = 1;
            return;
        }
        if (string.equals(NEG_INFINITY_STRING)) {
            this.sign = (byte)-1;
            this.nans = 1;
            return;
        }
        if (string.equals(NAN_STRING)) {
            this.sign = 1;
            this.nans = (byte)3;
            return;
        }
        int n5 = string.indexOf("e");
        if (n5 == -1) {
            n5 = string.indexOf("E");
        }
        int n6 = 0;
        if (n5 != -1) {
            string2 = string.substring(0, n5);
            String string3 = string.substring(n5 + 1);
            n2 = 0;
            for (n = 0; n < string3.length(); ++n) {
                if (string3.charAt(n) == '-') {
                    n2 = 1;
                    continue;
                }
                if (string3.charAt(n) < '0' || string3.charAt(n) > '9') continue;
                n6 = n6 * 10 + string3.charAt(n) - 48;
            }
            if (n2 != 0) {
                n6 = -n6;
            }
        } else {
            string2 = string;
        }
        if (string2.indexOf("-") != -1) {
            this.sign = (byte)-1;
        }
        n5 = 0;
        int n7 = 0;
        while (string2.charAt(n5) < '1' || string2.charAt(n5) > '9') {
            if (bl && string2.charAt(n5) == '0') {
                --n7;
            }
            if (string2.charAt(n5) == '.') {
                bl = true;
            }
            if (++n5 != string2.length()) continue;
        }
        n2 = 4;
        cArray[0] = 48;
        cArray[1] = 48;
        cArray[2] = 48;
        cArray[3] = 48;
        n = 0;
        while (n5 != string2.length() && n2 != this.mant.length * 4 + 4 + 1) {
            if (string2.charAt(n5) == '.') {
                bl = true;
                n7 = n;
                ++n5;
                continue;
            }
            if (string2.charAt(n5) < '0' || string2.charAt(n5) > '9') {
                ++n5;
                continue;
            }
            cArray[n2] = string2.charAt(n5);
            ++n2;
            ++n5;
            ++n;
        }
        if (bl && n2 != 4) {
            while (--n2 != 4 && cArray[n2] == '0') {
                --n;
            }
        }
        if (bl && n == 0) {
            n7 = 0;
        }
        if (!bl) {
            n7 = n2 - 4;
        }
        n2 = 4;
        for (n5 = n - 1 + 4; n5 > n2 && cArray[n5] == '0'; --n5) {
        }
        int n8 = (400 - n7 - n6 % 4) % 4;
        n2 -= n8;
        n7 += n8;
        while (n5 - n2 < this.mant.length * 4) {
            for (n8 = 0; n8 < 4; ++n8) {
                cArray[++n5] = 48;
            }
        }
        for (n8 = this.mant.length - 1; n8 >= 0; --n8) {
            this.mant[n8] = (cArray[n2] - 48) * 1000 + (cArray[n2 + 1] - 48) * 100 + (cArray[n2 + 2] - 48) * 10 + (cArray[n2 + 3] - 48);
            n2 += 4;
        }
        this.exp = (n7 + n6) / 4;
        if (n2 < cArray.length) {
            this.round((cArray[n2] - 48) * 1000);
        }
    }

    protected Dfp(DfpField dfpField, byte by, byte by2) {
        this.field = dfpField;
        this.mant = new int[dfpField.getRadixDigits()];
        this.sign = by;
        this.exp = 0;
        this.nans = by2;
    }

    public Dfp newInstance() {
        return new Dfp(this.getField());
    }

    public Dfp newInstance(byte by) {
        return new Dfp(this.getField(), by);
    }

    public Dfp newInstance(int n) {
        return new Dfp(this.getField(), n);
    }

    public Dfp newInstance(long l) {
        return new Dfp(this.getField(), l);
    }

    public Dfp newInstance(double d) {
        return new Dfp(this.getField(), d);
    }

    public Dfp newInstance(Dfp dfp) {
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this.newInstance(this.getZero());
            dfp2.nans = (byte)3;
            return this.dotrap(1, NEW_INSTANCE_TRAP, dfp, dfp2);
        }
        return new Dfp(dfp);
    }

    public Dfp newInstance(String string) {
        return new Dfp(this.field, string);
    }

    public Dfp newInstance(byte by, byte by2) {
        return this.field.newDfp(by, by2);
    }

    public DfpField getField() {
        return this.field;
    }

    public int getRadixDigits() {
        return this.field.getRadixDigits();
    }

    public Dfp getZero() {
        return this.field.getZero();
    }

    public Dfp getOne() {
        return this.field.getOne();
    }

    public Dfp getTwo() {
        return this.field.getTwo();
    }

    protected void shiftLeft() {
        for (int i = this.mant.length - 1; i > 0; --i) {
            this.mant[i] = this.mant[i - 1];
        }
        this.mant[0] = 0;
        --this.exp;
    }

    protected void shiftRight() {
        for (int i = 0; i < this.mant.length - 1; ++i) {
            this.mant[i] = this.mant[i + 1];
        }
        this.mant[this.mant.length - 1] = 0;
        ++this.exp;
    }

    protected int align(int n) {
        int n2 = 0;
        boolean bl = false;
        int n3 = this.exp - n;
        int n4 = n3;
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n3 == 0) {
            return 0;
        }
        if (n4 > this.mant.length + 1) {
            Arrays.fill(this.mant, 0);
            this.exp = n;
            this.field.setIEEEFlagsBits(16);
            this.dotrap(16, ALIGN_TRAP, this, this);
            return 0;
        }
        for (int i = 0; i < n4; ++i) {
            if (n3 < 0) {
                if (n2 != 0) {
                    bl = true;
                }
                n2 = this.mant[0];
                this.shiftRight();
                continue;
            }
            this.shiftLeft();
        }
        if (bl) {
            this.field.setIEEEFlagsBits(16);
            this.dotrap(16, ALIGN_TRAP, this, this);
        }
        return n2;
    }

    public boolean lessThan(Dfp dfp) {
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this.newInstance(this.getZero());
            dfp2.nans = (byte)3;
            this.dotrap(1, LESS_THAN_TRAP, dfp, dfp2);
            return false;
        }
        if (this.isNaN() || dfp.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            this.dotrap(1, LESS_THAN_TRAP, dfp, this.newInstance(this.getZero()));
            return false;
        }
        return Dfp.compare(this, dfp) < 0;
    }

    public boolean greaterThan(Dfp dfp) {
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this.newInstance(this.getZero());
            dfp2.nans = (byte)3;
            this.dotrap(1, GREATER_THAN_TRAP, dfp, dfp2);
            return false;
        }
        if (this.isNaN() || dfp.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            this.dotrap(1, GREATER_THAN_TRAP, dfp, this.newInstance(this.getZero()));
            return false;
        }
        return Dfp.compare(this, dfp) > 0;
    }

    public boolean negativeOrNull() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            this.dotrap(1, LESS_THAN_TRAP, this, this.newInstance(this.getZero()));
            return false;
        }
        return this.sign < 0 || this.mant[this.mant.length - 1] == 0 && !this.isInfinite();
    }

    public boolean strictlyNegative() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            this.dotrap(1, LESS_THAN_TRAP, this, this.newInstance(this.getZero()));
            return false;
        }
        return this.sign < 0 && (this.mant[this.mant.length - 1] != 0 || this.isInfinite());
    }

    public boolean positiveOrNull() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            this.dotrap(1, LESS_THAN_TRAP, this, this.newInstance(this.getZero()));
            return false;
        }
        return this.sign > 0 || this.mant[this.mant.length - 1] == 0 && !this.isInfinite();
    }

    public boolean strictlyPositive() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            this.dotrap(1, LESS_THAN_TRAP, this, this.newInstance(this.getZero()));
            return false;
        }
        return this.sign > 0 && (this.mant[this.mant.length - 1] != 0 || this.isInfinite());
    }

    @Override
    public Dfp abs() {
        Dfp dfp = this.newInstance(this);
        dfp.sign = 1;
        return dfp;
    }

    public boolean isInfinite() {
        return this.nans == 1;
    }

    public boolean isNaN() {
        return this.nans == 3 || this.nans == 2;
    }

    public boolean isZero() {
        if (this.isNaN()) {
            this.field.setIEEEFlagsBits(1);
            this.dotrap(1, LESS_THAN_TRAP, this, this.newInstance(this.getZero()));
            return false;
        }
        return this.mant[this.mant.length - 1] == 0 && !this.isInfinite();
    }

    public boolean equals(Object object) {
        if (object instanceof Dfp) {
            Dfp dfp = (Dfp)object;
            if (this.isNaN() || dfp.isNaN() || this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
                return false;
            }
            return Dfp.compare(this, dfp) == 0;
        }
        return false;
    }

    public int hashCode() {
        return 17 + (this.isZero() ? 0 : this.sign << 8) + (this.nans << 16) + this.exp + Arrays.hashCode(this.mant);
    }

    public boolean unequal(Dfp dfp) {
        if (this.isNaN() || dfp.isNaN() || this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            return false;
        }
        return this.greaterThan(dfp) || this.lessThan(dfp);
    }

    private static int compare(Dfp dfp, Dfp dfp2) {
        if (dfp.mant[dfp.mant.length - 1] == 0 && dfp2.mant[dfp2.mant.length - 1] == 0 && dfp.nans == 0 && dfp2.nans == 0) {
            return 0;
        }
        if (dfp.sign != dfp2.sign) {
            if (dfp.sign == -1) {
                return -1;
            }
            return 1;
        }
        if (dfp.nans == 1 && dfp2.nans == 0) {
            return dfp.sign;
        }
        if (dfp.nans == 0 && dfp2.nans == 1) {
            return -dfp2.sign;
        }
        if (dfp.nans == 1 && dfp2.nans == 1) {
            return 0;
        }
        if (dfp2.mant[dfp2.mant.length - 1] != 0 && dfp.mant[dfp2.mant.length - 1] != 0) {
            if (dfp.exp < dfp2.exp) {
                return -dfp.sign;
            }
            if (dfp.exp > dfp2.exp) {
                return dfp.sign;
            }
        }
        for (int i = dfp.mant.length - 1; i >= 0; --i) {
            if (dfp.mant[i] > dfp2.mant[i]) {
                return dfp.sign;
            }
            if (dfp.mant[i] >= dfp2.mant[i]) continue;
            return -dfp.sign;
        }
        return 0;
    }

    @Override
    public Dfp rint() {
        return this.trunc(DfpField.RoundingMode.ROUND_HALF_EVEN);
    }

    @Override
    public Dfp floor() {
        return this.trunc(DfpField.RoundingMode.ROUND_FLOOR);
    }

    @Override
    public Dfp ceil() {
        return this.trunc(DfpField.RoundingMode.ROUND_CEIL);
    }

    @Override
    public Dfp remainder(Dfp dfp) {
        Dfp dfp2 = this.subtract(this.divide(dfp).rint().multiply(dfp));
        if (dfp2.mant[this.mant.length - 1] == 0) {
            dfp2.sign = this.sign;
        }
        return dfp2;
    }

    protected Dfp trunc(DfpField.RoundingMode roundingMode) {
        boolean bl = false;
        if (this.isNaN()) {
            return this.newInstance(this);
        }
        if (this.nans == 1) {
            return this.newInstance(this);
        }
        if (this.mant[this.mant.length - 1] == 0) {
            return this.newInstance(this);
        }
        if (this.exp < 0) {
            this.field.setIEEEFlagsBits(16);
            Dfp dfp = this.newInstance(this.getZero());
            dfp = this.dotrap(16, TRUNC_TRAP, this, dfp);
            return dfp;
        }
        if (this.exp >= this.mant.length) {
            return this.newInstance(this);
        }
        Dfp dfp = this.newInstance(this);
        for (int i = 0; i < this.mant.length - dfp.exp; ++i) {
            bl |= dfp.mant[i] != 0;
            dfp.mant[i] = 0;
        }
        if (bl) {
            switch (roundingMode) {
                case ROUND_FLOOR: {
                    if (dfp.sign != -1) break;
                    dfp = dfp.add(this.newInstance(-1));
                    break;
                }
                case ROUND_CEIL: {
                    if (dfp.sign != 1) break;
                    dfp = dfp.add(this.getOne());
                    break;
                }
                default: {
                    Dfp dfp2 = this.newInstance("0.5");
                    Dfp dfp3 = this.subtract(dfp);
                    dfp3.sign = 1;
                    if (dfp3.greaterThan(dfp2)) {
                        dfp3 = this.newInstance(this.getOne());
                        dfp3.sign = this.sign;
                        dfp = dfp.add(dfp3);
                    }
                    if (!dfp3.equals(dfp2) || dfp.exp <= 0 || (dfp.mant[this.mant.length - dfp.exp] & 1) == 0) break;
                    dfp3 = this.newInstance(this.getOne());
                    dfp3.sign = this.sign;
                    dfp = dfp.add(dfp3);
                }
            }
            this.field.setIEEEFlagsBits(16);
            dfp = this.dotrap(16, TRUNC_TRAP, this, dfp);
            return dfp;
        }
        return dfp;
    }

    public int intValue() {
        int n = 0;
        Dfp dfp = this.rint();
        if (dfp.greaterThan(this.newInstance(Integer.MAX_VALUE))) {
            return Integer.MAX_VALUE;
        }
        if (dfp.lessThan(this.newInstance(Integer.MIN_VALUE))) {
            return Integer.MIN_VALUE;
        }
        for (int i = this.mant.length - 1; i >= this.mant.length - dfp.exp; --i) {
            n = n * 10000 + dfp.mant[i];
        }
        if (dfp.sign == -1) {
            n = -n;
        }
        return n;
    }

    public int log10K() {
        return this.exp - 1;
    }

    public Dfp power10K(int n) {
        Dfp dfp = this.newInstance(this.getOne());
        dfp.exp = n + 1;
        return dfp;
    }

    public int intLog10() {
        if (this.mant[this.mant.length - 1] > 1000) {
            return this.exp * 4 - 1;
        }
        if (this.mant[this.mant.length - 1] > 100) {
            return this.exp * 4 - 2;
        }
        if (this.mant[this.mant.length - 1] > 10) {
            return this.exp * 4 - 3;
        }
        return this.exp * 4 - 4;
    }

    public Dfp power10(int n) {
        Dfp dfp = this.newInstance(this.getOne());
        dfp.exp = n >= 0 ? n / 4 + 1 : (n + 1) / 4;
        switch ((n % 4 + 4) % 4) {
            case 0: {
                break;
            }
            case 1: {
                dfp = dfp.multiply(10);
                break;
            }
            case 2: {
                dfp = dfp.multiply(100);
                break;
            }
            default: {
                dfp = dfp.multiply(1000);
            }
        }
        return dfp;
    }

    protected int complement(int n) {
        int n2;
        n = 10000 - n;
        for (n2 = 0; n2 < this.mant.length; ++n2) {
            this.mant[n2] = 10000 - this.mant[n2] - 1;
        }
        n2 = n / 10000;
        n -= n2 * 10000;
        for (int i = 0; i < this.mant.length; ++i) {
            int n3 = this.mant[i] + n2;
            n2 = n3 / 10000;
            this.mant[i] = n3 - n2 * 10000;
        }
        return n;
    }

    @Override
    public Dfp add(Dfp dfp) {
        int n;
        int n2;
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this.newInstance(this.getZero());
            dfp2.nans = (byte)3;
            return this.dotrap(1, ADD_TRAP, dfp, dfp2);
        }
        if (this.nans != 0 || dfp.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (dfp.isNaN()) {
                return dfp;
            }
            if (this.nans == 1 && dfp.nans == 0) {
                return this;
            }
            if (dfp.nans == 1 && this.nans == 0) {
                return dfp;
            }
            if (dfp.nans == 1 && this.nans == 1 && this.sign == dfp.sign) {
                return dfp;
            }
            if (dfp.nans == 1 && this.nans == 1 && this.sign != dfp.sign) {
                this.field.setIEEEFlagsBits(1);
                Dfp dfp3 = this.newInstance(this.getZero());
                dfp3.nans = (byte)3;
                dfp3 = this.dotrap(1, ADD_TRAP, dfp, dfp3);
                return dfp3;
            }
        }
        Dfp dfp4 = this.newInstance(this);
        Dfp dfp5 = this.newInstance(dfp);
        Dfp dfp6 = this.newInstance(this.getZero());
        byte by = dfp4.sign;
        byte by2 = dfp5.sign;
        dfp4.sign = 1;
        dfp5.sign = 1;
        byte by3 = by2;
        if (Dfp.compare(dfp4, dfp5) > 0) {
            by3 = by;
        }
        if (dfp5.mant[this.mant.length - 1] == 0) {
            dfp5.exp = dfp4.exp;
        }
        if (dfp4.mant[this.mant.length - 1] == 0) {
            dfp4.exp = dfp5.exp;
        }
        int n3 = 0;
        int n4 = 0;
        if (dfp4.exp < dfp5.exp) {
            n3 = dfp4.align(dfp5.exp);
        } else {
            n4 = dfp5.align(dfp4.exp);
        }
        if (by != by2) {
            if (by == by3) {
                n4 = dfp5.complement(n4);
            } else {
                n3 = dfp4.complement(n3);
            }
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.mant.length; ++n2) {
            n = dfp4.mant[n2] + dfp5.mant[n2] + n5;
            n5 = n / 10000;
            dfp6.mant[n2] = n - n5 * 10000;
        }
        dfp6.exp = dfp4.exp;
        dfp6.sign = by3;
        if (n5 != 0 && by == by2) {
            n2 = dfp6.mant[0];
            dfp6.shiftRight();
            dfp6.mant[this.mant.length - 1] = n5;
            n = dfp6.round(n2);
            if (n != 0) {
                dfp6 = this.dotrap(n, ADD_TRAP, dfp, dfp6);
            }
        }
        for (n2 = 0; n2 < this.mant.length && dfp6.mant[this.mant.length - 1] == 0; ++n2) {
            dfp6.shiftLeft();
            if (n2 != 0) continue;
            dfp6.mant[0] = n3 + n4;
            n3 = 0;
            n4 = 0;
        }
        if (dfp6.mant[this.mant.length - 1] == 0) {
            dfp6.exp = 0;
            if (by != by2) {
                dfp6.sign = 1;
            }
        }
        if ((n2 = dfp6.round(n3 + n4)) != 0) {
            dfp6 = this.dotrap(n2, ADD_TRAP, dfp, dfp6);
        }
        return dfp6;
    }

    @Override
    public Dfp negate() {
        Dfp dfp = this.newInstance(this);
        dfp.sign = -dfp.sign;
        return dfp;
    }

    @Override
    public Dfp subtract(Dfp dfp) {
        return this.add(dfp.negate());
    }

    protected int round(int n) {
        boolean bl = false;
        switch (this.field.getRoundingMode()) {
            case ROUND_DOWN: {
                bl = false;
                break;
            }
            case ROUND_UP: {
                bl = n != 0;
                break;
            }
            case ROUND_HALF_UP: {
                bl = n >= 5000;
                break;
            }
            case ROUND_HALF_DOWN: {
                bl = n > 5000;
                break;
            }
            case ROUND_HALF_EVEN: {
                bl = n > 5000 || n == 5000 && (this.mant[0] & 1) == 1;
                break;
            }
            case ROUND_HALF_ODD: {
                bl = n > 5000 || n == 5000 && (this.mant[0] & 1) == 0;
                break;
            }
            case ROUND_CEIL: {
                bl = this.sign == 1 && n != 0;
                break;
            }
            default: {
                boolean bl2 = bl = this.sign == -1 && n != 0;
            }
        }
        if (bl) {
            int n2 = 1;
            for (int i = 0; i < this.mant.length; ++i) {
                int n3 = this.mant[i] + n2;
                n2 = n3 / 10000;
                this.mant[i] = n3 - n2 * 10000;
            }
            if (n2 != 0) {
                this.shiftRight();
                this.mant[this.mant.length - 1] = n2;
            }
        }
        if (this.exp < -32767) {
            this.field.setIEEEFlagsBits(8);
            return 8;
        }
        if (this.exp > 32768) {
            this.field.setIEEEFlagsBits(4);
            return 4;
        }
        if (n != 0) {
            this.field.setIEEEFlagsBits(16);
            return 16;
        }
        return 0;
    }

    @Override
    public Dfp multiply(Dfp dfp) {
        int n;
        int n2;
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this.newInstance(this.getZero());
            dfp2.nans = (byte)3;
            return this.dotrap(1, MULTIPLY_TRAP, dfp, dfp2);
        }
        Dfp dfp3 = this.newInstance(this.getZero());
        if (this.nans != 0 || dfp.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (dfp.isNaN()) {
                return dfp;
            }
            if (this.nans == 1 && dfp.nans == 0 && dfp.mant[this.mant.length - 1] != 0) {
                dfp3 = this.newInstance(this);
                dfp3.sign = (byte)(this.sign * dfp.sign);
                return dfp3;
            }
            if (dfp.nans == 1 && this.nans == 0 && this.mant[this.mant.length - 1] != 0) {
                dfp3 = this.newInstance(dfp);
                dfp3.sign = (byte)(this.sign * dfp.sign);
                return dfp3;
            }
            if (dfp.nans == 1 && this.nans == 1) {
                dfp3 = this.newInstance(this);
                dfp3.sign = (byte)(this.sign * dfp.sign);
                return dfp3;
            }
            if (dfp.nans == 1 && this.nans == 0 && this.mant[this.mant.length - 1] == 0 || this.nans == 1 && dfp.nans == 0 && dfp.mant[this.mant.length - 1] == 0) {
                this.field.setIEEEFlagsBits(1);
                dfp3 = this.newInstance(this.getZero());
                dfp3.nans = (byte)3;
                dfp3 = this.dotrap(1, MULTIPLY_TRAP, dfp, dfp3);
                return dfp3;
            }
        }
        int[] nArray = new int[this.mant.length * 2];
        for (n2 = 0; n2 < this.mant.length; ++n2) {
            n = 0;
            for (int i = 0; i < this.mant.length; ++i) {
                int n3 = this.mant[n2] * dfp.mant[i];
                n = (n3 += nArray[n2 + i] + n) / 10000;
                nArray[n2 + i] = n3 - n * 10000;
            }
            nArray[n2 + this.mant.length] = n;
        }
        n2 = this.mant.length * 2 - 1;
        for (n = this.mant.length * 2 - 1; n >= 0; --n) {
            if (nArray[n] == 0) continue;
            n2 = n;
            break;
        }
        for (n = 0; n < this.mant.length; ++n) {
            dfp3.mant[this.mant.length - n - 1] = nArray[n2 - n];
        }
        dfp3.exp = this.exp + dfp.exp + n2 - 2 * this.mant.length + 1;
        dfp3.sign = (byte)(this.sign == dfp.sign ? 1 : -1);
        if (dfp3.mant[this.mant.length - 1] == 0) {
            dfp3.exp = 0;
        }
        if ((n = n2 > this.mant.length - 1 ? dfp3.round(nArray[n2 - this.mant.length]) : dfp3.round(0)) != 0) {
            dfp3 = this.dotrap(n, MULTIPLY_TRAP, dfp, dfp3);
        }
        return dfp3;
    }

    @Override
    public Dfp multiply(int n) {
        if (n >= 0 && n < 10000) {
            return this.multiplyFast(n);
        }
        return this.multiply(this.newInstance(n));
    }

    private Dfp multiplyFast(int n) {
        int n2;
        int n3;
        Dfp dfp = this.newInstance(this);
        if (this.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (this.nans == 1 && n != 0) {
                dfp = this.newInstance(this);
                return dfp;
            }
            if (this.nans == 1 && n == 0) {
                this.field.setIEEEFlagsBits(1);
                dfp = this.newInstance(this.getZero());
                dfp.nans = (byte)3;
                dfp = this.dotrap(1, MULTIPLY_TRAP, this.newInstance(this.getZero()), dfp);
                return dfp;
            }
        }
        if (n < 0 || n >= 10000) {
            this.field.setIEEEFlagsBits(1);
            dfp = this.newInstance(this.getZero());
            dfp.nans = (byte)3;
            dfp = this.dotrap(1, MULTIPLY_TRAP, dfp, dfp);
            return dfp;
        }
        int n4 = 0;
        for (n3 = 0; n3 < this.mant.length; ++n3) {
            n2 = this.mant[n3] * n + n4;
            n4 = n2 / 10000;
            dfp.mant[n3] = n2 - n4 * 10000;
        }
        n3 = 0;
        if (n4 != 0) {
            n3 = dfp.mant[0];
            dfp.shiftRight();
            dfp.mant[this.mant.length - 1] = n4;
        }
        if (dfp.mant[this.mant.length - 1] == 0) {
            dfp.exp = 0;
        }
        if ((n2 = dfp.round(n3)) != 0) {
            dfp = this.dotrap(n2, MULTIPLY_TRAP, dfp, dfp);
        }
        return dfp;
    }

    @Override
    public Dfp divide(Dfp dfp) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp2 = this.newInstance(this.getZero());
            dfp2.nans = (byte)3;
            return this.dotrap(1, DIVIDE_TRAP, dfp, dfp2);
        }
        Dfp dfp3 = this.newInstance(this.getZero());
        if (this.nans != 0 || dfp.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (dfp.isNaN()) {
                return dfp;
            }
            if (this.nans == 1 && dfp.nans == 0) {
                dfp3 = this.newInstance(this);
                dfp3.sign = (byte)(this.sign * dfp.sign);
                return dfp3;
            }
            if (dfp.nans == 1 && this.nans == 0) {
                dfp3 = this.newInstance(this.getZero());
                dfp3.sign = (byte)(this.sign * dfp.sign);
                return dfp3;
            }
            if (dfp.nans == 1 && this.nans == 1) {
                this.field.setIEEEFlagsBits(1);
                dfp3 = this.newInstance(this.getZero());
                dfp3.nans = (byte)3;
                dfp3 = this.dotrap(1, DIVIDE_TRAP, dfp, dfp3);
                return dfp3;
            }
        }
        if (dfp.mant[this.mant.length - 1] == 0) {
            this.field.setIEEEFlagsBits(2);
            dfp3 = this.newInstance(this.getZero());
            dfp3.sign = (byte)(this.sign * dfp.sign);
            dfp3.nans = 1;
            dfp3 = this.dotrap(2, DIVIDE_TRAP, dfp, dfp3);
            return dfp3;
        }
        int[] nArray = new int[this.mant.length + 1];
        int[] nArray2 = new int[this.mant.length + 2];
        int[] nArray3 = new int[this.mant.length + 1];
        nArray[this.mant.length] = 0;
        nArray2[this.mant.length] = 0;
        nArray2[this.mant.length + 1] = 0;
        nArray3[this.mant.length] = 0;
        for (n2 = 0; n2 < this.mant.length; ++n2) {
            nArray[n2] = this.mant[n2];
            nArray2[n2] = 0;
            nArray3[n2] = 0;
        }
        int n5 = 0;
        for (int i = this.mant.length + 1; i >= 0; --i) {
            int n6;
            n2 = nArray[this.mant.length] * 10000 + nArray[this.mant.length - 1];
            int n7 = n2 / (dfp.mant[this.mant.length - 1] + 1);
            int n8 = (n2 + 1) / dfp.mant[this.mant.length - 1];
            boolean bl = false;
            while (!bl) {
                int n9;
                int n10;
                n3 = (n7 + n8) / 2;
                n6 = 0;
                for (n10 = 0; n10 < this.mant.length + 1; ++n10) {
                    n9 = n10 < this.mant.length ? dfp.mant[n10] : 0;
                    int n11 = n9 * n3 + n6;
                    n6 = n11 / 10000;
                    nArray3[n10] = n11 - n6 * 10000;
                }
                n6 = 1;
                for (n10 = 0; n10 < this.mant.length + 1; ++n10) {
                    n9 = 9999 - nArray3[n10] + nArray[n10] + n6;
                    n6 = n9 / 10000;
                    nArray3[n10] = n9 - n6 * 10000;
                }
                if (n6 == 0) {
                    n8 = n3 - 1;
                    continue;
                }
                int n12 = nArray3[this.mant.length] * 10000 + nArray3[this.mant.length - 1];
                if ((n12 /= dfp.mant[this.mant.length - 1] + 1) >= 2) {
                    n7 = n3 + n12;
                    continue;
                }
                bl = false;
                for (n10 = this.mant.length - 1; n10 >= 0; --n10) {
                    if (dfp.mant[n10] > nArray3[n10]) {
                        bl = true;
                    }
                    if (dfp.mant[n10] < nArray3[n10]) break;
                }
                if (nArray3[this.mant.length] != 0) {
                    bl = false;
                }
                if (bl) continue;
                n7 = n3 + 1;
            }
            nArray2[i] = n3;
            if (n3 != 0 || n5 != 0) {
                ++n5;
            }
            if (this.field.getRoundingMode() == DfpField.RoundingMode.ROUND_DOWN && n5 == this.mant.length || n5 > this.mant.length) break;
            nArray[0] = 0;
            for (n6 = 0; n6 < this.mant.length; ++n6) {
                nArray[n6 + 1] = nArray3[n6];
            }
        }
        n4 = this.mant.length;
        for (n2 = this.mant.length + 1; n2 >= 0; --n2) {
            if (nArray2[n2] == 0) continue;
            n4 = n2;
            break;
        }
        for (n2 = 0; n2 < this.mant.length; ++n2) {
            dfp3.mant[this.mant.length - n2 - 1] = nArray2[n4 - n2];
        }
        dfp3.exp = this.exp - dfp.exp + n4 - this.mant.length;
        dfp3.sign = (byte)(this.sign == dfp.sign ? 1 : -1);
        if (dfp3.mant[this.mant.length - 1] == 0) {
            dfp3.exp = 0;
        }
        if ((n = n4 > this.mant.length - 1 ? dfp3.round(nArray2[n4 - this.mant.length]) : dfp3.round(0)) != 0) {
            dfp3 = this.dotrap(n, DIVIDE_TRAP, dfp, dfp3);
        }
        return dfp3;
    }

    @Override
    public Dfp divide(int n) {
        int n2;
        int n3;
        if (this.nans != 0) {
            if (this.isNaN()) {
                return this;
            }
            if (this.nans == 1) {
                return this.newInstance(this);
            }
        }
        if (n == 0) {
            this.field.setIEEEFlagsBits(2);
            Dfp dfp = this.newInstance(this.getZero());
            dfp.sign = this.sign;
            dfp.nans = 1;
            dfp = this.dotrap(2, DIVIDE_TRAP, this.getZero(), dfp);
            return dfp;
        }
        if (n < 0 || n >= 10000) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp = this.newInstance(this.getZero());
            dfp.nans = (byte)3;
            dfp = this.dotrap(1, DIVIDE_TRAP, dfp, dfp);
            return dfp;
        }
        Dfp dfp = this.newInstance(this);
        int n4 = 0;
        for (n3 = this.mant.length - 1; n3 >= 0; --n3) {
            n2 = n4 * 10000 + dfp.mant[n3];
            int n5 = n2 / n;
            n4 = n2 - n5 * n;
            dfp.mant[n3] = n5;
        }
        if (dfp.mant[this.mant.length - 1] == 0) {
            dfp.shiftLeft();
            n3 = n4 * 10000;
            n2 = n3 / n;
            n4 = n3 - n2 * n;
            dfp.mant[0] = n2;
        }
        if ((n3 = dfp.round(n4 * 10000 / n)) != 0) {
            dfp = this.dotrap(n3, DIVIDE_TRAP, dfp, dfp);
        }
        return dfp;
    }

    @Override
    public Dfp reciprocal() {
        return this.field.getOne().divide(this);
    }

    @Override
    public Dfp sqrt() {
        if (this.nans == 0 && this.mant[this.mant.length - 1] == 0) {
            return this.newInstance(this);
        }
        if (this.nans != 0) {
            if (this.nans == 1 && this.sign == 1) {
                return this.newInstance(this);
            }
            if (this.nans == 3) {
                return this.newInstance(this);
            }
            if (this.nans == 2) {
                this.field.setIEEEFlagsBits(1);
                Dfp dfp = this.newInstance(this);
                dfp = this.dotrap(1, SQRT_TRAP, null, dfp);
                return dfp;
            }
        }
        if (this.sign == -1) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp = this.newInstance(this);
            dfp.nans = (byte)3;
            dfp = this.dotrap(1, SQRT_TRAP, null, dfp);
            return dfp;
        }
        Dfp dfp = this.newInstance(this);
        if (dfp.exp < -1 || dfp.exp > 1) {
            dfp.exp = this.exp / 2;
        }
        switch (dfp.mant[this.mant.length - 1] / 2000) {
            case 0: {
                dfp.mant[this.mant.length - 1] = dfp.mant[this.mant.length - 1] / 2 + 1;
                break;
            }
            case 2: {
                dfp.mant[this.mant.length - 1] = 1500;
                break;
            }
            case 3: {
                dfp.mant[this.mant.length - 1] = 2200;
                break;
            }
            default: {
                dfp.mant[this.mant.length - 1] = 3000;
            }
        }
        Dfp dfp2 = this.newInstance(dfp);
        Dfp dfp3 = this.getZero();
        Dfp dfp4 = this.getZero();
        while (dfp.unequal(dfp3)) {
            dfp2 = this.newInstance(dfp);
            dfp2.sign = (byte)-1;
            dfp2 = dfp2.add(this.divide(dfp));
            dfp2 = dfp2.divide(2);
            dfp4 = dfp3;
            dfp3 = dfp;
            if (!(dfp = dfp.add(dfp2)).equals(dfp4) && dfp2.mant[this.mant.length - 1] != 0) continue;
            break;
        }
        return dfp;
    }

    public String toString() {
        if (this.nans != 0) {
            if (this.nans == 1) {
                return this.sign < 0 ? NEG_INFINITY_STRING : POS_INFINITY_STRING;
            }
            return NAN_STRING;
        }
        if (this.exp > this.mant.length || this.exp < -1) {
            return this.dfp2sci();
        }
        return this.dfp2string();
    }

    protected String dfp2sci() {
        int n;
        char[] cArray = new char[this.mant.length * 4];
        char[] cArray2 = new char[this.mant.length * 4 + 20];
        int n2 = 0;
        for (int i = this.mant.length - 1; i >= 0; --i) {
            cArray[n2++] = (char)(this.mant[i] / 1000 + 48);
            cArray[n2++] = (char)(this.mant[i] / 100 % 10 + 48);
            cArray[n2++] = (char)(this.mant[i] / 10 % 10 + 48);
            cArray[n2++] = (char)(this.mant[i] % 10 + 48);
        }
        for (n2 = 0; n2 < cArray.length && cArray[n2] == '0'; ++n2) {
        }
        int n3 = n2;
        int n4 = 0;
        if (this.sign == -1) {
            cArray2[n4++] = 45;
        }
        if (n2 != cArray.length) {
            cArray2[n4++] = cArray[n2++];
            cArray2[n4++] = 46;
            while (n2 < cArray.length) {
                cArray2[n4++] = cArray[n2++];
            }
        } else {
            cArray2[n4++] = 48;
            cArray2[n4++] = 46;
            cArray2[n4++] = 48;
            cArray2[n4++] = 101;
            cArray2[n4++] = 48;
            return new String(cArray2, 0, 5);
        }
        cArray2[n4++] = 101;
        int n5 = n = this.exp * 4 - n3 - 1;
        if (n < 0) {
            n5 = -n;
        }
        for (n2 = 1000000000; n2 > n5; n2 /= 10) {
        }
        if (n < 0) {
            cArray2[n4++] = 45;
        }
        while (n2 > 0) {
            cArray2[n4++] = (char)(n5 / n2 + 48);
            n5 %= n2;
            n2 /= 10;
        }
        return new String(cArray2, 0, n4);
    }

    protected String dfp2string() {
        char[] cArray = new char[this.mant.length * 4 + 20];
        int n = 1;
        int n2 = this.exp;
        boolean bl = false;
        cArray[0] = 32;
        if (n2 <= 0) {
            cArray[n++] = 48;
            cArray[n++] = 46;
            bl = true;
        }
        while (n2 < 0) {
            cArray[n++] = 48;
            cArray[n++] = 48;
            cArray[n++] = 48;
            cArray[n++] = 48;
            ++n2;
        }
        for (int i = this.mant.length - 1; i >= 0; --i) {
            cArray[n++] = (char)(this.mant[i] / 1000 + 48);
            cArray[n++] = (char)(this.mant[i] / 100 % 10 + 48);
            cArray[n++] = (char)(this.mant[i] / 10 % 10 + 48);
            cArray[n++] = (char)(this.mant[i] % 10 + 48);
            if (--n2 != 0) continue;
            cArray[n++] = 46;
            bl = true;
        }
        while (n2 > 0) {
            cArray[n++] = 48;
            cArray[n++] = 48;
            cArray[n++] = 48;
            cArray[n++] = 48;
            --n2;
        }
        if (!bl) {
            cArray[n++] = 46;
        }
        int n3 = 1;
        while (cArray[n3] == '0') {
            ++n3;
        }
        if (cArray[n3] == '.') {
            --n3;
        }
        while (cArray[n - 1] == '0') {
            --n;
        }
        if (this.sign < 0) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, n - n3);
    }

    public Dfp dotrap(int n, String string, Dfp dfp, Dfp dfp2) {
        Dfp dfp3 = dfp2;
        switch (n) {
            case 1: {
                dfp3 = this.newInstance(this.getZero());
                dfp3.sign = dfp2.sign;
                dfp3.nans = (byte)3;
                break;
            }
            case 2: {
                if (this.nans == 0 && this.mant[this.mant.length - 1] != 0) {
                    dfp3 = this.newInstance(this.getZero());
                    dfp3.sign = (byte)(this.sign * dfp.sign);
                    dfp3.nans = 1;
                }
                if (this.nans == 0 && this.mant[this.mant.length - 1] == 0) {
                    dfp3 = this.newInstance(this.getZero());
                    dfp3.nans = (byte)3;
                }
                if (this.nans == 1 || this.nans == 3) {
                    dfp3 = this.newInstance(this.getZero());
                    dfp3.nans = (byte)3;
                }
                if (this.nans != 1 && this.nans != 2) break;
                dfp3 = this.newInstance(this.getZero());
                dfp3.nans = (byte)3;
                break;
            }
            case 8: {
                if (dfp2.exp + this.mant.length < -32767) {
                    dfp3 = this.newInstance(this.getZero());
                    dfp3.sign = dfp2.sign;
                } else {
                    dfp3 = this.newInstance(dfp2);
                }
                dfp2.exp += 32760;
                break;
            }
            case 4: {
                dfp2.exp -= 32760;
                dfp3 = this.newInstance(this.getZero());
                dfp3.sign = dfp2.sign;
                dfp3.nans = 1;
                break;
            }
            default: {
                dfp3 = dfp2;
            }
        }
        return this.trap(n, string, dfp, dfp3, dfp2);
    }

    protected Dfp trap(int n, String string, Dfp dfp, Dfp dfp2, Dfp dfp3) {
        return dfp2;
    }

    public int classify() {
        return this.nans;
    }

    public static Dfp copysign(Dfp dfp, Dfp dfp2) {
        Dfp dfp3 = dfp.newInstance(dfp);
        dfp3.sign = dfp2.sign;
        return dfp3;
    }

    public Dfp nextAfter(Dfp dfp) {
        Dfp dfp2;
        if (this.field.getRadixDigits() != dfp.field.getRadixDigits()) {
            this.field.setIEEEFlagsBits(1);
            Dfp dfp3 = this.newInstance(this.getZero());
            dfp3.nans = (byte)3;
            return this.dotrap(1, NEXT_AFTER_TRAP, dfp, dfp3);
        }
        boolean bl = false;
        if (this.lessThan(dfp)) {
            bl = true;
        }
        if (Dfp.compare(this, dfp) == 0) {
            return this.newInstance(dfp);
        }
        if (this.lessThan(this.getZero())) {
            boolean bl2 = bl = !bl;
        }
        if (bl) {
            Dfp dfp4 = this.newInstance(this.getOne());
            dfp4.exp = this.exp - this.mant.length + 1;
            dfp4.sign = this.sign;
            if (this.equals(this.getZero())) {
                dfp4.exp = -32767 - this.mant.length;
            }
            dfp2 = this.add(dfp4);
        } else {
            Dfp dfp5 = this.newInstance(this.getOne());
            dfp5.exp = this.exp;
            dfp5.sign = this.sign;
            dfp5.exp = this.equals(dfp5) ? this.exp - this.mant.length : this.exp - this.mant.length + 1;
            if (this.equals(this.getZero())) {
                dfp5.exp = -32767 - this.mant.length;
            }
            dfp2 = this.subtract(dfp5);
        }
        if (dfp2.classify() == 1 && this.classify() != 1) {
            this.field.setIEEEFlagsBits(16);
            dfp2 = this.dotrap(16, NEXT_AFTER_TRAP, dfp, dfp2);
        }
        if (dfp2.equals(this.getZero()) && !this.equals(this.getZero())) {
            this.field.setIEEEFlagsBits(16);
            dfp2 = this.dotrap(16, NEXT_AFTER_TRAP, dfp, dfp2);
        }
        return dfp2;
    }

    public double toDouble() {
        int n;
        if (this.isInfinite()) {
            if (this.lessThan(this.getZero())) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (this.isNaN()) {
            return Double.NaN;
        }
        Dfp dfp = this;
        boolean bl = false;
        int n2 = Dfp.compare(this, this.getZero());
        if (n2 == 0) {
            return this.sign < 0 ? -0.0 : 0.0;
        }
        if (n2 < 0) {
            dfp = this.negate();
            bl = true;
        }
        if ((n = (int)((double)dfp.intLog10() * 3.32)) < 0) {
            --n;
        }
        Dfp dfp2 = DfpMath.pow(this.getTwo(), n);
        while (dfp2.lessThan(dfp) || dfp2.equals(dfp)) {
            dfp2 = dfp2.multiply(2);
            ++n;
        }
        dfp = dfp.divide(DfpMath.pow(this.getTwo(), --n));
        if (n > -1023) {
            dfp = dfp.subtract(this.getOne());
        }
        if (n < -1074) {
            return 0.0;
        }
        if (n > 1023) {
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        dfp = dfp.multiply(this.newInstance(0x10000000000000L)).rint();
        String string = dfp.toString();
        long l = Long.parseLong(string = string.substring(0, string.length() - 1));
        if (l == 0x10000000000000L) {
            l = 0L;
            ++n;
        }
        if (n <= -1023) {
            --n;
        }
        while (n < -1023) {
            ++n;
            l >>>= 1;
        }
        long l2 = l | (long)n + 1023L << 52;
        double d = Double.longBitsToDouble(l2);
        if (bl) {
            d = -d;
        }
        return d;
    }

    public double[] toSplitDouble() {
        double[] dArray = new double[2];
        long l = -1073741824L;
        dArray[0] = Double.longBitsToDouble(Double.doubleToLongBits(this.toDouble()) & l);
        dArray[1] = this.subtract(this.newInstance(dArray[0])).toDouble();
        return dArray;
    }

    @Override
    public double getReal() {
        return this.toDouble();
    }

    @Override
    public Dfp add(double d) {
        return this.add(this.newInstance(d));
    }

    @Override
    public Dfp subtract(double d) {
        return this.subtract(this.newInstance(d));
    }

    @Override
    public Dfp multiply(double d) {
        return this.multiply(this.newInstance(d));
    }

    @Override
    public Dfp divide(double d) {
        return this.divide(this.newInstance(d));
    }

    @Override
    public Dfp remainder(double d) {
        return this.remainder(this.newInstance(d));
    }

    @Override
    public long round() {
        return FastMath.round(this.toDouble());
    }

    @Override
    public Dfp signum() {
        if (this.isNaN() || this.isZero()) {
            return this;
        }
        return this.newInstance(this.sign > 0 ? 1 : -1);
    }

    @Override
    public Dfp copySign(Dfp dfp) {
        if (this.sign >= 0 && dfp.sign >= 0 || this.sign < 0 && dfp.sign < 0) {
            return this;
        }
        return this.negate();
    }

    @Override
    public Dfp copySign(double d) {
        long l = Double.doubleToLongBits(d);
        if (this.sign >= 0 && l >= 0L || this.sign < 0 && l < 0L) {
            return this;
        }
        return this.negate();
    }

    @Override
    public Dfp scalb(int n) {
        return this.multiply(DfpMath.pow(this.getTwo(), n));
    }

    @Override
    public Dfp hypot(Dfp dfp) {
        return this.multiply(this).add(dfp.multiply(dfp)).sqrt();
    }

    @Override
    public Dfp cbrt() {
        return this.rootN(3);
    }

    @Override
    public Dfp rootN(int n) {
        return this.sign >= 0 ? DfpMath.pow(this, this.getOne().divide(n)) : DfpMath.pow(this.negate(), this.getOne().divide(n)).negate();
    }

    @Override
    public Dfp pow(double d) {
        return DfpMath.pow(this, this.newInstance(d));
    }

    @Override
    public Dfp pow(int n) {
        return DfpMath.pow(this, n);
    }

    @Override
    public Dfp pow(Dfp dfp) {
        return DfpMath.pow(this, dfp);
    }

    @Override
    public Dfp exp() {
        return DfpMath.exp(this);
    }

    @Override
    public Dfp expm1() {
        return DfpMath.exp(this).subtract(this.getOne());
    }

    @Override
    public Dfp log() {
        return DfpMath.log(this);
    }

    @Override
    public Dfp log1p() {
        return DfpMath.log(this.add(this.getOne()));
    }

    @Deprecated
    public int log10() {
        return this.intLog10();
    }

    @Override
    public Dfp cos() {
        return DfpMath.cos(this);
    }

    @Override
    public Dfp sin() {
        return DfpMath.sin(this);
    }

    @Override
    public Dfp tan() {
        return DfpMath.tan(this);
    }

    @Override
    public Dfp acos() {
        return DfpMath.acos(this);
    }

    @Override
    public Dfp asin() {
        return DfpMath.asin(this);
    }

    @Override
    public Dfp atan() {
        return DfpMath.atan(this);
    }

    @Override
    public Dfp atan2(Dfp dfp) {
        Dfp dfp2 = dfp.multiply(dfp).add(this.multiply(this)).sqrt();
        if (dfp.sign >= 0) {
            return this.getTwo().multiply(this.divide(dfp2.add(dfp)).atan());
        }
        Dfp dfp3 = this.getTwo().multiply(this.divide(dfp2.subtract(dfp)).atan());
        Dfp dfp4 = this.newInstance(dfp3.sign <= 0 ? -Math.PI : Math.PI);
        return dfp4.subtract(dfp3);
    }

    @Override
    public Dfp cosh() {
        return DfpMath.exp(this).add(DfpMath.exp(this.negate())).divide(2);
    }

    @Override
    public Dfp sinh() {
        return DfpMath.exp(this).subtract(DfpMath.exp(this.negate())).divide(2);
    }

    @Override
    public Dfp tanh() {
        Dfp dfp = DfpMath.exp(this);
        Dfp dfp2 = DfpMath.exp(this.negate());
        return dfp.subtract(dfp2).divide(dfp.add(dfp2));
    }

    @Override
    public Dfp acosh() {
        return this.multiply(this).subtract(this.getOne()).sqrt().add(this).log();
    }

    @Override
    public Dfp asinh() {
        return this.multiply(this).add(this.getOne()).sqrt().add(this).log();
    }

    @Override
    public Dfp atanh() {
        return this.getOne().add(this).divide(this.getOne().subtract(this)).log().divide(2);
    }

    public Dfp linearCombination(Dfp[] dfpArray, Dfp[] dfpArray2) {
        if (dfpArray.length != dfpArray2.length) {
            throw new DimensionMismatchException(dfpArray.length, dfpArray2.length);
        }
        Dfp dfp = this.getZero();
        for (int i = 0; i < dfpArray.length; ++i) {
            dfp = dfp.add(dfpArray[i].multiply(dfpArray2[i]));
        }
        return dfp;
    }

    public Dfp linearCombination(double[] dArray, Dfp[] dfpArray) {
        if (dArray.length != dfpArray.length) {
            throw new DimensionMismatchException(dArray.length, dfpArray.length);
        }
        Dfp dfp = this.getZero();
        for (int i = 0; i < dArray.length; ++i) {
            dfp = dfp.add(dfpArray[i].multiply(dArray[i]));
        }
        return dfp;
    }

    @Override
    public Dfp linearCombination(Dfp dfp, Dfp dfp2, Dfp dfp3, Dfp dfp4) {
        return dfp.multiply(dfp2).add(dfp3.multiply(dfp4));
    }

    @Override
    public Dfp linearCombination(double d, Dfp dfp, double d2, Dfp dfp2) {
        return dfp.multiply(d).add(dfp2.multiply(d2));
    }

    @Override
    public Dfp linearCombination(Dfp dfp, Dfp dfp2, Dfp dfp3, Dfp dfp4, Dfp dfp5, Dfp dfp6) {
        return dfp.multiply(dfp2).add(dfp3.multiply(dfp4)).add(dfp5.multiply(dfp6));
    }

    @Override
    public Dfp linearCombination(double d, Dfp dfp, double d2, Dfp dfp2, double d3, Dfp dfp3) {
        return dfp.multiply(d).add(dfp2.multiply(d2)).add(dfp3.multiply(d3));
    }

    @Override
    public Dfp linearCombination(Dfp dfp, Dfp dfp2, Dfp dfp3, Dfp dfp4, Dfp dfp5, Dfp dfp6, Dfp dfp7, Dfp dfp8) {
        return dfp.multiply(dfp2).add(dfp3.multiply(dfp4)).add(dfp5.multiply(dfp6)).add(dfp7.multiply(dfp8));
    }

    @Override
    public Dfp linearCombination(double d, Dfp dfp, double d2, Dfp dfp2, double d3, Dfp dfp3, double d4, Dfp dfp4) {
        return dfp.multiply(d).add(dfp2.multiply(d2)).add(dfp3.multiply(d3)).add(dfp4.multiply(d4));
    }
}

