/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.dfp;

import org.apache.commons.math3.dfp.Dfp;
import org.apache.commons.math3.dfp.DfpField;

public class DfpDec
extends Dfp {
    protected DfpDec(DfpField dfpField) {
        super(dfpField);
    }

    protected DfpDec(DfpField dfpField, byte by) {
        super(dfpField, by);
    }

    protected DfpDec(DfpField dfpField, int n) {
        super(dfpField, n);
    }

    protected DfpDec(DfpField dfpField, long l) {
        super(dfpField, l);
    }

    protected DfpDec(DfpField dfpField, double d) {
        super(dfpField, d);
        this.round(0);
    }

    public DfpDec(Dfp dfp) {
        super(dfp);
        this.round(0);
    }

    protected DfpDec(DfpField dfpField, String string) {
        super(dfpField, string);
        this.round(0);
    }

    protected DfpDec(DfpField dfpField, byte by, byte by2) {
        super(dfpField, by, by2);
    }

    public Dfp newInstance() {
        return new DfpDec(this.getField());
    }

    public Dfp newInstance(byte by) {
        return new DfpDec(this.getField(), by);
    }

    public Dfp newInstance(int n) {
        return new DfpDec(this.getField(), n);
    }

    public Dfp newInstance(long l) {
        return new DfpDec(this.getField(), l);
    }

    public Dfp newInstance(double d) {
        return new DfpDec(this.getField(), d);
    }

    public Dfp newInstance(Dfp dfp) {
        if (this.getField().getRadixDigits() != dfp.getField().getRadixDigits()) {
            this.getField().setIEEEFlagsBits(1);
            Dfp dfp2 = this.newInstance(this.getZero());
            dfp2.nans = (byte)3;
            return this.dotrap(1, "newInstance", dfp, dfp2);
        }
        return new DfpDec(dfp);
    }

    public Dfp newInstance(String string) {
        return new DfpDec(this.getField(), string);
    }

    public Dfp newInstance(byte by, byte by2) {
        return new DfpDec(this.getField(), by, by2);
    }

    protected int getDecimalDigits() {
        return this.getRadixDigits() * 4 - 3;
    }

    protected int round(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.mant[this.mant.length - 1];
        if (n5 == 0) {
            return 0;
        }
        int n6 = this.mant.length * 4;
        int n7 = 1000;
        while (n7 > n5) {
            n7 /= 10;
            --n6;
        }
        int n8 = this.getDecimalDigits();
        int n9 = n6 - n8;
        int n10 = n9 / 4;
        n7 = 1;
        for (n4 = 0; n4 < n9 % 4; ++n4) {
            n7 *= 10;
        }
        n4 = this.mant[n10];
        if (n7 <= 1 && n8 == 4 * this.mant.length - 3) {
            return super.round(n);
        }
        int n11 = n;
        if (n7 == 1) {
            n3 = this.mant[n10 - 1] / 1000 % 10;
            int n12 = n10 - 1;
            this.mant[n12] = this.mant[n12] % 1000;
            n11 |= this.mant[n10 - 1];
        } else {
            n3 = n4 * 10 / n7 % 10;
            n11 |= n4 % (n7 / 10);
        }
        for (n2 = 0; n2 < n10; ++n2) {
            n11 |= this.mant[n2];
            this.mant[n2] = 0;
        }
        this.mant[n10] = n4 / n7 * n7;
        switch (this.getField().getRoundingMode()) {
            case ROUND_DOWN: {
                n2 = 0;
                break;
            }
            case ROUND_UP: {
                n2 = n3 != 0 || n11 != 0 ? 1 : 0;
                break;
            }
            case ROUND_HALF_UP: {
                n2 = n3 >= 5 ? 1 : 0;
                break;
            }
            case ROUND_HALF_DOWN: {
                n2 = n3 > 5 ? 1 : 0;
                break;
            }
            case ROUND_HALF_EVEN: {
                n2 = n3 > 5 || n3 == 5 && n11 != 0 || n3 == 5 && n11 == 0 && (n4 / n7 & 1) == 1 ? 1 : 0;
                break;
            }
            case ROUND_HALF_ODD: {
                n2 = n3 > 5 || n3 == 5 && n11 != 0 || n3 == 5 && n11 == 0 && (n4 / n7 & 1) == 0 ? 1 : 0;
                break;
            }
            case ROUND_CEIL: {
                n2 = this.sign == 1 && (n3 != 0 || n11 != 0) ? 1 : 0;
                break;
            }
            default: {
                int n13 = n2 = this.sign == -1 && (n3 != 0 || n11 != 0) ? 1 : 0;
            }
        }
        if (n2 != 0) {
            int n14 = n7;
            for (int i = n10; i < this.mant.length; ++i) {
                int n15 = this.mant[i] + n14;
                n14 = n15 / 10000;
                this.mant[i] = n15 % 10000;
            }
            if (n14 != 0) {
                this.shiftRight();
                this.mant[this.mant.length - 1] = n14;
            }
        }
        if (this.exp < -32767) {
            this.getField().setIEEEFlagsBits(8);
            return 8;
        }
        if (this.exp > 32768) {
            this.getField().setIEEEFlagsBits(4);
            return 4;
        }
        if (n3 != 0 || n11 != 0) {
            this.getField().setIEEEFlagsBits(16);
            return 16;
        }
        return 0;
    }

    public Dfp nextAfter(Dfp dfp) {
        Dfp dfp2;
        String string = "nextAfter";
        if (this.getField().getRadixDigits() != dfp.getField().getRadixDigits()) {
            this.getField().setIEEEFlagsBits(1);
            Dfp dfp3 = this.newInstance(this.getZero());
            dfp3.nans = (byte)3;
            return this.dotrap(1, "nextAfter", dfp, dfp3);
        }
        boolean bl = false;
        if (this.lessThan(dfp)) {
            bl = true;
        }
        if (this.equals(dfp)) {
            return this.newInstance(dfp);
        }
        if (this.lessThan(this.getZero())) {
            boolean bl2 = bl = !bl;
        }
        if (bl) {
            Dfp dfp4 = this.power10(this.intLog10() - this.getDecimalDigits() + 1);
            dfp4 = DfpDec.copysign(dfp4, this);
            if (this.equals(this.getZero())) {
                dfp4 = this.power10K(-32767 - this.mant.length - 1);
            }
            dfp2 = dfp4.equals(this.getZero()) ? DfpDec.copysign(this.newInstance(this.getZero()), this) : this.add(dfp4);
        } else {
            Dfp dfp5 = this.power10(this.intLog10());
            dfp5 = this.equals(dfp5 = DfpDec.copysign(dfp5, this)) ? dfp5.divide(this.power10(this.getDecimalDigits())) : dfp5.divide(this.power10(this.getDecimalDigits() - 1));
            if (this.equals(this.getZero())) {
                dfp5 = this.power10K(-32767 - this.mant.length - 1);
            }
            dfp2 = dfp5.equals(this.getZero()) ? DfpDec.copysign(this.newInstance(this.getZero()), this) : this.subtract(dfp5);
        }
        if (dfp2.classify() == 1 && this.classify() != 1) {
            this.getField().setIEEEFlagsBits(16);
            dfp2 = this.dotrap(16, "nextAfter", dfp, dfp2);
        }
        if (dfp2.equals(this.getZero()) && !this.equals(this.getZero())) {
            this.getField().setIEEEFlagsBits(16);
            dfp2 = this.dotrap(16, "nextAfter", dfp, dfp2);
        }
        return dfp2;
    }
}

