/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.exception.NotFiniteNumberException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumeratedDistribution<T>
implements Serializable {
    private static final long serialVersionUID = 20123308L;
    protected final RandomGenerator random;
    private final List<T> singletons;
    private final double[] probabilities;
    private final double[] cumulativeProbabilities;

    public EnumeratedDistribution(List<Pair<T, Double>> list) {
        this(new Well19937c(), list);
    }

    public EnumeratedDistribution(RandomGenerator randomGenerator, List<Pair<T, Double>> list) {
        this.random = randomGenerator;
        this.singletons = new ArrayList<T>(list.size());
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Pair<T, Double> pair = list.get(i);
            this.singletons.add(pair.getKey());
            double d = pair.getValue();
            if (d < 0.0) {
                throw new NotPositiveException(pair.getValue());
            }
            if (Double.isInfinite(d)) {
                throw new NotFiniteNumberException(d, new Object[0]);
            }
            if (Double.isNaN(d)) {
                throw new NotANumberException();
            }
            dArray[i] = d;
        }
        this.probabilities = MathArrays.normalizeArray(dArray, 1.0);
        this.cumulativeProbabilities = new double[this.probabilities.length];
        double d = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            this.cumulativeProbabilities[i] = d += this.probabilities[i];
        }
    }

    public void reseedRandomGenerator(long l) {
        this.random.setSeed(l);
    }

    double probability(T t) {
        double d = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            if ((t != null || this.singletons.get(i) != null) && (t == null || !t.equals(this.singletons.get(i)))) continue;
            d += this.probabilities[i];
        }
        return d;
    }

    public List<Pair<T, Double>> getPmf() {
        ArrayList<Pair<T, Double>> arrayList = new ArrayList<Pair<T, Double>>(this.probabilities.length);
        for (int i = 0; i < this.probabilities.length; ++i) {
            arrayList.add(new Pair<T, Double>(this.singletons.get(i), this.probabilities[i]));
        }
        return arrayList;
    }

    public T sample() {
        double d = this.random.nextDouble();
        int n = Arrays.binarySearch(this.cumulativeProbabilities, d);
        if (n < 0) {
            n = -n - 1;
        }
        if (n >= 0 && n < this.probabilities.length && d < this.cumulativeProbabilities[n]) {
            return this.singletons.get(n);
        }
        return this.singletons.get(this.singletons.size() - 1);
    }

    public Object[] sample(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.sample();
        }
        return objectArray;
    }

    public T[] sample(int n, T[] TArray) {
        Object[] objectArray;
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
        }
        if (TArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (TArray.length < n) {
            Object[] objectArray2 = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
            objectArray = objectArray2;
        } else {
            objectArray = TArray;
        }
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.sample();
        }
        return objectArray;
    }
}

