/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.BigFractionField;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KolmogorovSmirnovDistribution
implements Serializable {
    private static final long serialVersionUID = -4670676796862967187L;
    private int n;

    public KolmogorovSmirnovDistribution(int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        this.n = n;
    }

    public double cdf(double d) {
        return this.cdf(d, false);
    }

    public double cdfExact(double d) {
        return this.cdf(d, true);
    }

    public double cdf(double d, boolean bl) {
        double d2 = 1.0 / (double)this.n;
        double d3 = 0.5 * d2;
        if (d <= d3) {
            return 0.0;
        }
        if (d3 < d && d <= d2) {
            double d4 = 1.0;
            double d5 = 2.0 * d - d2;
            for (int i = 1; i <= this.n; ++i) {
                d4 *= (double)i * d5;
            }
            return d4;
        }
        if (1.0 - d2 <= d && d < 1.0) {
            return 1.0 - 2.0 * FastMath.pow(1.0 - d, this.n);
        }
        if (1.0 <= d) {
            return 1.0;
        }
        return bl ? this.exactK(d) : this.roundedK(d);
    }

    private double exactK(double d) {
        int n = (int)FastMath.ceil((double)this.n * d);
        FieldMatrix<BigFraction> fieldMatrix = this.createH(d);
        FieldMatrix<BigFraction> fieldMatrix2 = fieldMatrix.power(this.n);
        BigFraction bigFraction = fieldMatrix2.getEntry(n - 1, n - 1);
        for (int i = 1; i <= this.n; ++i) {
            bigFraction = bigFraction.multiply(i).divide(this.n);
        }
        return bigFraction.bigDecimalValue(20, 4).doubleValue();
    }

    private double roundedK(double d) {
        int n = (int)FastMath.ceil((double)this.n * d);
        FieldMatrix<BigFraction> fieldMatrix = this.createH(d);
        int n2 = fieldMatrix.getRowDimension();
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n2, n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                array2DRowRealMatrix.setEntry(i, j, fieldMatrix.getEntry(i, j).doubleValue());
            }
        }
        RealMatrix realMatrix = array2DRowRealMatrix.power(this.n);
        double d2 = realMatrix.getEntry(n - 1, n - 1);
        for (int i = 1; i <= this.n; ++i) {
            d2 *= (double)i / (double)this.n;
        }
        return d2;
    }

    private FieldMatrix<BigFraction> createH(double d) {
        int n;
        int n2 = (int)FastMath.ceil((double)this.n * d);
        int n3 = 2 * n2 - 1;
        double d2 = (double)n2 - (double)this.n * d;
        if (d2 >= 1.0) {
            throw new NumberIsTooLargeException(d2, (Number)1.0, false);
        }
        BigFraction bigFraction = null;
        try {
            bigFraction = new BigFraction(d2, 1.0E-20, 10000);
        }
        catch (FractionConversionException fractionConversionException) {
            try {
                bigFraction = new BigFraction(d2, 1.0E-10, 10000);
            }
            catch (FractionConversionException fractionConversionException2) {
                bigFraction = new BigFraction(d2, 1.0E-5, 10000);
            }
        }
        FieldElement[][] fieldElementArray = new BigFraction[n3][n3];
        for (int i = 0; i < n3; ++i) {
            for (n = 0; n < n3; ++n) {
                fieldElementArray[i][n] = i - n + 1 < 0 ? BigFraction.ZERO : BigFraction.ONE;
            }
        }
        BigFraction[] bigFractionArray = new BigFraction[n3];
        bigFractionArray[0] = bigFraction;
        for (n = 1; n < n3; ++n) {
            bigFractionArray[n] = bigFraction.multiply(bigFractionArray[n - 1]);
        }
        for (n = 0; n < n3; ++n) {
            fieldElementArray[n][0] = fieldElementArray[n][0].subtract(bigFractionArray[n]);
            fieldElementArray[n3 - 1][n] = ((BigFraction)fieldElementArray[n3 - 1][n]).subtract(bigFractionArray[n3 - n - 1]);
        }
        if (bigFraction.compareTo(BigFraction.ONE_HALF) == 1) {
            fieldElementArray[n3 - 1][0] = ((BigFraction)fieldElementArray[n3 - 1][0]).add(bigFraction.multiply(2).subtract(1).pow(n3));
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n + 1; ++i) {
                if (n - i + 1 <= 0) continue;
                for (int j = 2; j <= n - i + 1; ++j) {
                    fieldElementArray[n][i] = ((BigFraction)fieldElementArray[n][i]).divide(j);
                }
            }
        }
        return new Array2DRowFieldMatrix((Field)BigFractionField.getInstance(), fieldElementArray);
    }
}

