/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Erf;
import org.apache.commons.math3.util.FastMath;

public class LevyDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20130314L;
    private final double mu;
    private final double c;
    private final double halfC;

    public LevyDistribution(double d, double d2) {
        this(new Well19937c(), d, d2);
    }

    public LevyDistribution(RandomGenerator randomGenerator, double d, double d2) {
        super(randomGenerator);
        this.mu = d;
        this.c = d2;
        this.halfC = 0.5 * d2;
    }

    public double density(double d) {
        if (d < this.mu) {
            return Double.NaN;
        }
        double d2 = d - this.mu;
        double d3 = this.halfC / d2;
        return FastMath.sqrt(d3 / Math.PI) * FastMath.exp(-d3) / d2;
    }

    public double logDensity(double d) {
        if (d < this.mu) {
            return Double.NaN;
        }
        double d2 = d - this.mu;
        double d3 = this.halfC / d2;
        return 0.5 * FastMath.log(d3 / Math.PI) - d3 - FastMath.log(d2);
    }

    public double cumulativeProbability(double d) {
        if (d < this.mu) {
            return Double.NaN;
        }
        return Erf.erfc(FastMath.sqrt(this.halfC / (d - this.mu)));
    }

    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        double d2 = Erf.erfcInv(d);
        return this.mu + this.halfC / (d2 * d2);
    }

    public double getScale() {
        return this.c;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getNumericalMean() {
        return Double.POSITIVE_INFINITY;
    }

    public double getNumericalVariance() {
        return Double.POSITIVE_INFINITY;
    }

    public double getSupportLowerBound() {
        return this.mu;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

