/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Erf;
import org.apache.commons.math3.util.FastMath;

public class LogNormalDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20120112L;
    private static final double SQRT2PI = FastMath.sqrt(Math.PI * 2);
    private static final double SQRT2 = FastMath.sqrt(2.0);
    private final double scale;
    private final double shape;
    private final double logShapePlusHalfLog2Pi;
    private final double solverAbsoluteAccuracy;

    public LogNormalDistribution() {
        this(0.0, 1.0);
    }

    public LogNormalDistribution(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public LogNormalDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2, d3);
    }

    public LogNormalDistribution(RandomGenerator randomGenerator, double d, double d2) {
        this(randomGenerator, d, d2, 1.0E-9);
    }

    public LogNormalDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d2);
        }
        this.scale = d;
        this.shape = d2;
        this.logShapePlusHalfLog2Pi = FastMath.log(d2) + 0.5 * FastMath.log(Math.PI * 2);
        this.solverAbsoluteAccuracy = d3;
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    public double density(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = FastMath.log(d) - this.scale;
        double d3 = d2 / this.shape;
        return FastMath.exp(-0.5 * d3 * d3) / (this.shape * SQRT2PI * d);
    }

    public double logDensity(double d) {
        if (d <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = FastMath.log(d);
        double d3 = d2 - this.scale;
        double d4 = d3 / this.shape;
        return -0.5 * d4 * d4 - (this.logShapePlusHalfLog2Pi + d2);
    }

    public double cumulativeProbability(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = FastMath.log(d) - this.scale;
        if (FastMath.abs(d2) > 40.0 * this.shape) {
            return d2 < 0.0 ? 0.0 : 1.0;
        }
        return 0.5 + 0.5 * Erf.erf(d2 / (this.shape * SQRT2));
    }

    @Deprecated
    public double cumulativeProbability(double d, double d2) {
        return this.probability(d, d2);
    }

    public double probability(double d, double d2) {
        if (d > d2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)d, d2, true);
        }
        if (d <= 0.0 || d2 <= 0.0) {
            return super.probability(d, d2);
        }
        double d3 = this.shape * SQRT2;
        double d4 = (FastMath.log(d) - this.scale) / d3;
        double d5 = (FastMath.log(d2) - this.scale) / d3;
        return 0.5 * Erf.erf(d4, d5);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        double d = this.shape;
        return FastMath.exp(this.scale + d * d / 2.0);
    }

    public double getNumericalVariance() {
        double d = this.shape;
        double d2 = d * d;
        return FastMath.expm1(d2) * FastMath.exp(2.0 * this.scale + d2);
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double sample() {
        double d = this.random.nextGaussian();
        return FastMath.exp(this.scale + this.shape * d);
    }
}

