/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;

public class ParetoDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20130424L;
    private final double scale;
    private final double shape;
    private final double solverAbsoluteAccuracy;

    public ParetoDistribution() {
        this(1.0, 1.0);
    }

    public ParetoDistribution(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public ParetoDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2, d3);
    }

    public ParetoDistribution(RandomGenerator randomGenerator, double d, double d2) {
        this(randomGenerator, d, d2, 1.0E-9);
    }

    public ParetoDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d);
        }
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d2);
        }
        this.scale = d;
        this.shape = d2;
        this.solverAbsoluteAccuracy = d3;
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    public double density(double d) {
        if (d < this.scale) {
            return 0.0;
        }
        return FastMath.pow(this.scale, this.shape) / FastMath.pow(d, this.shape + 1.0) * this.shape;
    }

    public double logDensity(double d) {
        if (d < this.scale) {
            return Double.NEGATIVE_INFINITY;
        }
        return FastMath.log(this.scale) * this.shape - FastMath.log(d) * (this.shape + 1.0) + FastMath.log(this.shape);
    }

    public double cumulativeProbability(double d) {
        if (d <= this.scale) {
            return 0.0;
        }
        return 1.0 - FastMath.pow(this.scale / d, this.shape);
    }

    @Deprecated
    public double cumulativeProbability(double d, double d2) {
        return this.probability(d, d2);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getNumericalMean() {
        if (this.shape <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.shape * this.scale / (this.shape - 1.0);
    }

    public double getNumericalVariance() {
        if (this.shape <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d = this.shape - 1.0;
        return this.scale * this.scale * this.shape / (d * d) / (this.shape - 2.0);
    }

    public double getSupportLowerBound() {
        return this.scale;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double sample() {
        double d = this.random.nextDouble();
        return this.scale / FastMath.pow(d, 1.0 / this.shape);
    }
}

