/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.filter;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.filter.MeasurementModel;
import org.apache.commons.math3.filter.ProcessModel;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.MathUtils;

public class KalmanFilter {
    private final ProcessModel processModel;
    private final MeasurementModel measurementModel;
    private RealMatrix transitionMatrix;
    private RealMatrix transitionMatrixT;
    private RealMatrix controlMatrix;
    private RealMatrix measurementMatrix;
    private RealMatrix measurementMatrixT;
    private RealVector stateEstimation;
    private RealMatrix errorCovariance;

    public KalmanFilter(ProcessModel processModel, MeasurementModel measurementModel) {
        MathUtils.checkNotNull(processModel);
        MathUtils.checkNotNull(measurementModel);
        this.processModel = processModel;
        this.measurementModel = measurementModel;
        this.transitionMatrix = this.processModel.getStateTransitionMatrix();
        MathUtils.checkNotNull(this.transitionMatrix);
        this.transitionMatrixT = this.transitionMatrix.transpose();
        this.controlMatrix = this.processModel.getControlMatrix() == null ? new Array2DRowRealMatrix() : this.processModel.getControlMatrix();
        this.measurementMatrix = this.measurementModel.getMeasurementMatrix();
        MathUtils.checkNotNull(this.measurementMatrix);
        this.measurementMatrixT = this.measurementMatrix.transpose();
        RealMatrix realMatrix = this.processModel.getProcessNoise();
        MathUtils.checkNotNull(realMatrix);
        RealMatrix realMatrix2 = this.measurementModel.getMeasurementNoise();
        MathUtils.checkNotNull(realMatrix2);
        this.stateEstimation = this.processModel.getInitialStateEstimate() == null ? new ArrayRealVector(this.transitionMatrix.getColumnDimension()) : this.processModel.getInitialStateEstimate();
        if (this.transitionMatrix.getColumnDimension() != this.stateEstimation.getDimension()) {
            throw new DimensionMismatchException(this.transitionMatrix.getColumnDimension(), this.stateEstimation.getDimension());
        }
        this.errorCovariance = this.processModel.getInitialErrorCovariance() == null ? realMatrix.copy() : this.processModel.getInitialErrorCovariance();
        if (!this.transitionMatrix.isSquare()) {
            throw new NonSquareMatrixException(this.transitionMatrix.getRowDimension(), this.transitionMatrix.getColumnDimension());
        }
        if (this.controlMatrix != null && this.controlMatrix.getRowDimension() > 0 && this.controlMatrix.getColumnDimension() > 0 && this.controlMatrix.getRowDimension() != this.transitionMatrix.getRowDimension()) {
            throw new MatrixDimensionMismatchException(this.controlMatrix.getRowDimension(), this.controlMatrix.getColumnDimension(), this.transitionMatrix.getRowDimension(), this.controlMatrix.getColumnDimension());
        }
        MatrixUtils.checkAdditionCompatible(this.transitionMatrix, realMatrix);
        if (this.measurementMatrix.getColumnDimension() != this.transitionMatrix.getRowDimension()) {
            throw new MatrixDimensionMismatchException(this.measurementMatrix.getRowDimension(), this.measurementMatrix.getColumnDimension(), this.measurementMatrix.getRowDimension(), this.transitionMatrix.getRowDimension());
        }
        if (realMatrix2.getRowDimension() != this.measurementMatrix.getRowDimension()) {
            throw new MatrixDimensionMismatchException(realMatrix2.getRowDimension(), realMatrix2.getColumnDimension(), this.measurementMatrix.getRowDimension(), realMatrix2.getColumnDimension());
        }
    }

    public int getStateDimension() {
        return this.stateEstimation.getDimension();
    }

    public int getMeasurementDimension() {
        return this.measurementMatrix.getRowDimension();
    }

    public double[] getStateEstimation() {
        return this.stateEstimation.toArray();
    }

    public RealVector getStateEstimationVector() {
        return this.stateEstimation.copy();
    }

    public double[][] getErrorCovariance() {
        return this.errorCovariance.getData();
    }

    public RealMatrix getErrorCovarianceMatrix() {
        return this.errorCovariance.copy();
    }

    public void predict() {
        this.predict((RealVector)null);
    }

    public void predict(double[] dArray) {
        this.predict(new ArrayRealVector(dArray, false));
    }

    public void predict(RealVector realVector) {
        if (realVector != null && realVector.getDimension() != this.controlMatrix.getColumnDimension()) {
            throw new DimensionMismatchException(realVector.getDimension(), this.controlMatrix.getColumnDimension());
        }
        this.stateEstimation = this.transitionMatrix.operate(this.stateEstimation);
        if (realVector != null) {
            this.stateEstimation = this.stateEstimation.add(this.controlMatrix.operate(realVector));
        }
        this.errorCovariance = this.transitionMatrix.multiply(this.errorCovariance).multiply(this.transitionMatrixT).add(this.processModel.getProcessNoise());
    }

    public void correct(double[] dArray) {
        this.correct(new ArrayRealVector(dArray, false));
    }

    public void correct(RealVector realVector) {
        MathUtils.checkNotNull(realVector);
        if (realVector.getDimension() != this.measurementMatrix.getRowDimension()) {
            throw new DimensionMismatchException(realVector.getDimension(), this.measurementMatrix.getRowDimension());
        }
        RealMatrix realMatrix = this.measurementMatrix.multiply(this.errorCovariance).multiply(this.measurementMatrixT).add(this.measurementModel.getMeasurementNoise());
        RealVector realVector2 = realVector.subtract(this.measurementMatrix.operate(this.stateEstimation));
        RealMatrix realMatrix2 = new CholeskyDecomposition(realMatrix).getSolver().solve(this.measurementMatrix.multiply(this.errorCovariance.transpose())).transpose();
        this.stateEstimation = this.stateEstimation.add(realMatrix2.operate(realVector2));
        RealMatrix realMatrix3 = MatrixUtils.createRealIdentityMatrix(realMatrix2.getRowDimension());
        this.errorCovariance = realMatrix3.subtract(realMatrix2.multiply(this.measurementMatrix)).multiply(this.errorCovariance);
    }
}

