/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunction;
import org.apache.commons.math3.optim.nonlinear.vector.ModelFunctionJacobian;
import org.apache.commons.math3.optim.nonlinear.vector.MultivariateVectorOptimizer;
import org.apache.commons.math3.optim.nonlinear.vector.Target;
import org.apache.commons.math3.optim.nonlinear.vector.Weight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CurveFitter<T extends ParametricUnivariateFunction> {
    private final MultivariateVectorOptimizer optimizer;
    private final List<WeightedObservedPoint> observations;

    public CurveFitter(MultivariateVectorOptimizer multivariateVectorOptimizer) {
        this.optimizer = multivariateVectorOptimizer;
        this.observations = new ArrayList<WeightedObservedPoint>();
    }

    public void addObservedPoint(double d, double d2) {
        this.addObservedPoint(1.0, d, d2);
    }

    public void addObservedPoint(double d, double d2, double d3) {
        this.observations.add(new WeightedObservedPoint(d, d2, d3));
    }

    public void addObservedPoint(WeightedObservedPoint weightedObservedPoint) {
        this.observations.add(weightedObservedPoint);
    }

    public WeightedObservedPoint[] getObservations() {
        return this.observations.toArray(new WeightedObservedPoint[this.observations.size()]);
    }

    public void clearObservations() {
        this.observations.clear();
    }

    public double[] fit(T t, double[] dArray) {
        return this.fit(Integer.MAX_VALUE, t, dArray);
    }

    public double[] fit(int n, T t, double[] dArray) {
        double[] dArray2 = new double[this.observations.size()];
        double[] dArray3 = new double[this.observations.size()];
        int n2 = 0;
        for (WeightedObservedPoint serializable2 : this.observations) {
            dArray2[n2] = serializable2.getY();
            dArray3[n2] = serializable2.getWeight();
            ++n2;
        }
        TheoreticalValuesFunction theoreticalValuesFunction = new TheoreticalValuesFunction((ParametricUnivariateFunction)t);
        PointVectorValuePair pointVectorValuePair = this.optimizer.optimize(new MaxEval(n), theoreticalValuesFunction.getModelFunction(), theoreticalValuesFunction.getModelFunctionJacobian(), new Target(dArray2), new Weight(dArray3), new InitialGuess(dArray));
        return pointVectorValuePair.getPointRef();
    }

    private class TheoreticalValuesFunction {
        private final ParametricUnivariateFunction f;

        TheoreticalValuesFunction(ParametricUnivariateFunction parametricUnivariateFunction) {
            this.f = parametricUnivariateFunction;
        }

        public ModelFunction getModelFunction() {
            return new ModelFunction(new MultivariateVectorFunction(){

                public double[] value(double[] dArray) {
                    double[] dArray2 = new double[CurveFitter.this.observations.size()];
                    int n = 0;
                    for (WeightedObservedPoint weightedObservedPoint : CurveFitter.this.observations) {
                        dArray2[n++] = TheoreticalValuesFunction.this.f.value(weightedObservedPoint.getX(), dArray);
                    }
                    return dArray2;
                }
            });
        }

        public ModelFunctionJacobian getModelFunctionJacobian() {
            return new ModelFunctionJacobian(new MultivariateMatrixFunction(){

                public double[][] value(double[] dArray) {
                    double[][] dArrayArray = new double[CurveFitter.this.observations.size()][];
                    int n = 0;
                    for (WeightedObservedPoint weightedObservedPoint : CurveFitter.this.observations) {
                        dArrayArray[n++] = TheoreticalValuesFunction.this.f.gradient(weightedObservedPoint.getX(), dArray);
                    }
                    return dArrayArray;
                }
            });
        }
    }
}

