/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.analysis.function.Gaussian;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fitting.AbstractCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussianCurveFitter
extends AbstractCurveFitter {
    private static final Gaussian.Parametric FUNCTION = new Gaussian.Parametric(){

        public double value(double d, double ... dArray) {
            double d2 = Double.POSITIVE_INFINITY;
            try {
                d2 = super.value(d, dArray);
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                // empty catch block
            }
            return d2;
        }

        public double[] gradient(double d, double ... dArray) {
            double[] dArray2 = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
            try {
                dArray2 = super.gradient(d, dArray);
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                // empty catch block
            }
            return dArray2;
        }
    };
    private final double[] initialGuess;
    private final int maxIter;

    private GaussianCurveFitter(double[] dArray, int n) {
        this.initialGuess = dArray;
        this.maxIter = n;
    }

    public static GaussianCurveFitter create() {
        return new GaussianCurveFitter(null, Integer.MAX_VALUE);
    }

    public GaussianCurveFitter withStartPoint(double[] dArray) {
        return new GaussianCurveFitter((double[])dArray.clone(), this.maxIter);
    }

    public GaussianCurveFitter withMaxIterations(int n) {
        return new GaussianCurveFitter(this.initialGuess, n);
    }

    @Override
    protected LeastSquaresProblem getProblem(Collection<WeightedObservedPoint> collection) {
        int n = collection.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        for (WeightedObservedPoint object2 : collection) {
            dArray[n2] = object2.getY();
            dArray2[n2] = object2.getWeight();
            ++n2;
        }
        AbstractCurveFitter.TheoreticalValuesFunction theoreticalValuesFunction = new AbstractCurveFitter.TheoreticalValuesFunction(FUNCTION, collection);
        double[] dArray3 = this.initialGuess != null ? this.initialGuess : new ParameterGuesser(collection).guess();
        return new LeastSquaresBuilder().maxEvaluations(Integer.MAX_VALUE).maxIterations(this.maxIter).start(dArray3).target(dArray).weight(new DiagonalMatrix(dArray2)).model(theoreticalValuesFunction.getModelFunction(), theoreticalValuesFunction.getModelFunctionJacobian()).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParameterGuesser {
        private final double norm;
        private final double mean;
        private final double sigma;

        public ParameterGuesser(Collection<WeightedObservedPoint> collection) {
            if (collection == null) {
                throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
            }
            if (collection.size() < 3) {
                throw new NumberIsTooSmallException(collection.size(), (Number)3, true);
            }
            List<WeightedObservedPoint> list = this.sortObservations(collection);
            double[] dArray = this.basicGuess(list.toArray(new WeightedObservedPoint[0]));
            this.norm = dArray[0];
            this.mean = dArray[1];
            this.sigma = dArray[2];
        }

        public double[] guess() {
            return new double[]{this.norm, this.mean, this.sigma};
        }

        private List<WeightedObservedPoint> sortObservations(Collection<WeightedObservedPoint> collection) {
            ArrayList<WeightedObservedPoint> arrayList = new ArrayList<WeightedObservedPoint>(collection);
            Comparator<WeightedObservedPoint> comparator = new Comparator<WeightedObservedPoint>(){

                @Override
                public int compare(WeightedObservedPoint weightedObservedPoint, WeightedObservedPoint weightedObservedPoint2) {
                    if (weightedObservedPoint == null && weightedObservedPoint2 == null) {
                        return 0;
                    }
                    if (weightedObservedPoint == null) {
                        return -1;
                    }
                    if (weightedObservedPoint2 == null) {
                        return 1;
                    }
                    int n = Double.compare(weightedObservedPoint.getX(), weightedObservedPoint2.getX());
                    if (n < 0) {
                        return -1;
                    }
                    if (n > 0) {
                        return 1;
                    }
                    int n2 = Double.compare(weightedObservedPoint.getY(), weightedObservedPoint2.getY());
                    if (n2 < 0) {
                        return -1;
                    }
                    if (n2 > 0) {
                        return 1;
                    }
                    int n3 = Double.compare(weightedObservedPoint.getWeight(), weightedObservedPoint2.getWeight());
                    if (n3 < 0) {
                        return -1;
                    }
                    if (n3 > 0) {
                        return 1;
                    }
                    return 0;
                }
            };
            Collections.sort(arrayList, comparator);
            return arrayList;
        }

        private double[] basicGuess(WeightedObservedPoint[] weightedObservedPointArray) {
            double d;
            double d2;
            int n = this.findMaxY(weightedObservedPointArray);
            double d3 = weightedObservedPointArray[n].getY();
            double d4 = weightedObservedPointArray[n].getX();
            try {
                d2 = d3 + (d4 - d3) / 2.0;
                double d5 = this.interpolateXAtY(weightedObservedPointArray, n, -1, d2);
                double d6 = this.interpolateXAtY(weightedObservedPointArray, n, 1, d2);
                d = d6 - d5;
            }
            catch (OutOfRangeException outOfRangeException) {
                d = weightedObservedPointArray[weightedObservedPointArray.length - 1].getX() - weightedObservedPointArray[0].getX();
            }
            d2 = d / (2.0 * FastMath.sqrt(2.0 * FastMath.log(2.0)));
            return new double[]{d3, d4, d2};
        }

        private int findMaxY(WeightedObservedPoint[] weightedObservedPointArray) {
            int n = 0;
            for (int i = 1; i < weightedObservedPointArray.length; ++i) {
                if (!(weightedObservedPointArray[i].getY() > weightedObservedPointArray[n].getY())) continue;
                n = i;
            }
            return n;
        }

        private double interpolateXAtY(WeightedObservedPoint[] weightedObservedPointArray, int n, int n2, double d) {
            if (n2 == 0) {
                throw new ZeroException();
            }
            WeightedObservedPoint[] weightedObservedPointArray2 = this.getInterpolationPointsForY(weightedObservedPointArray, n, n2, d);
            WeightedObservedPoint weightedObservedPoint = weightedObservedPointArray2[0];
            WeightedObservedPoint weightedObservedPoint2 = weightedObservedPointArray2[1];
            if (weightedObservedPoint.getY() == d) {
                return weightedObservedPoint.getX();
            }
            if (weightedObservedPoint2.getY() == d) {
                return weightedObservedPoint2.getX();
            }
            return weightedObservedPoint.getX() + (d - weightedObservedPoint.getY()) * (weightedObservedPoint2.getX() - weightedObservedPoint.getX()) / (weightedObservedPoint2.getY() - weightedObservedPoint.getY());
        }

        private WeightedObservedPoint[] getInterpolationPointsForY(WeightedObservedPoint[] weightedObservedPointArray, int n, int n2, double d) {
            if (n2 == 0) {
                throw new ZeroException();
            }
            int n3 = n;
            while (n2 < 0 ? n3 + n2 >= 0 : n3 + n2 < weightedObservedPointArray.length) {
                WeightedObservedPoint weightedObservedPoint = weightedObservedPointArray[n3];
                WeightedObservedPoint weightedObservedPoint2 = weightedObservedPointArray[n3 + n2];
                if (this.isBetween(d, weightedObservedPoint.getY(), weightedObservedPoint2.getY())) {
                    if (n2 < 0) {
                        return new WeightedObservedPoint[]{weightedObservedPoint2, weightedObservedPoint};
                    }
                    return new WeightedObservedPoint[]{weightedObservedPoint, weightedObservedPoint2};
                }
                n3 += n2;
            }
            throw new OutOfRangeException(d, (Number)Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }

        private boolean isBetween(double d, double d2, double d3) {
            return d >= d2 && d <= d3 || d >= d3 && d <= d2;
        }
    }
}

