/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.analysis.function.HarmonicOscillator;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fitting.AbstractCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresBuilder;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HarmonicCurveFitter
extends AbstractCurveFitter {
    private static final HarmonicOscillator.Parametric FUNCTION = new HarmonicOscillator.Parametric();
    private final double[] initialGuess;
    private final int maxIter;

    private HarmonicCurveFitter(double[] dArray, int n) {
        this.initialGuess = dArray;
        this.maxIter = n;
    }

    public static HarmonicCurveFitter create() {
        return new HarmonicCurveFitter(null, Integer.MAX_VALUE);
    }

    public HarmonicCurveFitter withStartPoint(double[] dArray) {
        return new HarmonicCurveFitter((double[])dArray.clone(), this.maxIter);
    }

    public HarmonicCurveFitter withMaxIterations(int n) {
        return new HarmonicCurveFitter(this.initialGuess, n);
    }

    @Override
    protected LeastSquaresProblem getProblem(Collection<WeightedObservedPoint> collection) {
        int n = collection.size();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int n2 = 0;
        for (WeightedObservedPoint object2 : collection) {
            dArray[n2] = object2.getY();
            dArray2[n2] = object2.getWeight();
            ++n2;
        }
        AbstractCurveFitter.TheoreticalValuesFunction theoreticalValuesFunction = new AbstractCurveFitter.TheoreticalValuesFunction(FUNCTION, collection);
        double[] dArray3 = this.initialGuess != null ? this.initialGuess : new ParameterGuesser(collection).guess();
        return new LeastSquaresBuilder().maxEvaluations(Integer.MAX_VALUE).maxIterations(this.maxIter).start(dArray3).target(dArray).weight(new DiagonalMatrix(dArray2)).model(theoreticalValuesFunction.getModelFunction(), theoreticalValuesFunction.getModelFunctionJacobian()).build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParameterGuesser {
        private final double a;
        private final double omega;
        private final double phi;

        public ParameterGuesser(Collection<WeightedObservedPoint> collection) {
            if (collection.size() < 4) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, (Number)collection.size(), 4, true);
            }
            WeightedObservedPoint[] weightedObservedPointArray = this.sortObservations(collection).toArray(new WeightedObservedPoint[0]);
            double[] dArray = this.guessAOmega(weightedObservedPointArray);
            this.a = dArray[0];
            this.omega = dArray[1];
            this.phi = this.guessPhi(weightedObservedPointArray);
        }

        public double[] guess() {
            return new double[]{this.a, this.omega, this.phi};
        }

        private List<WeightedObservedPoint> sortObservations(Collection<WeightedObservedPoint> collection) {
            ArrayList<WeightedObservedPoint> arrayList = new ArrayList<WeightedObservedPoint>(collection);
            WeightedObservedPoint weightedObservedPoint = (WeightedObservedPoint)arrayList.get(0);
            int n = arrayList.size();
            for (int i = 1; i < n; ++i) {
                WeightedObservedPoint weightedObservedPoint2 = weightedObservedPoint;
                weightedObservedPoint = (WeightedObservedPoint)arrayList.get(i);
                if (!(weightedObservedPoint.getX() < weightedObservedPoint2.getX())) continue;
                int n2 = i - 1;
                WeightedObservedPoint weightedObservedPoint3 = (WeightedObservedPoint)arrayList.get(n2);
                while (n2 >= 0 && weightedObservedPoint.getX() < weightedObservedPoint3.getX()) {
                    arrayList.set(n2 + 1, weightedObservedPoint3);
                    if (n2-- == 0) continue;
                    weightedObservedPoint3 = (WeightedObservedPoint)arrayList.get(n2);
                }
                arrayList.set(n2 + 1, weightedObservedPoint);
                weightedObservedPoint = (WeightedObservedPoint)arrayList.get(i);
            }
            return arrayList;
        }

        private double[] guessAOmega(WeightedObservedPoint[] weightedObservedPointArray) {
            double d;
            double d2;
            double d3;
            double[] dArray = new double[2];
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = weightedObservedPointArray[0].getX();
            double d10 = weightedObservedPointArray[0].getY();
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = d9;
            for (int i = 1; i < weightedObservedPointArray.length; ++i) {
                double d14 = d9;
                double d15 = d10;
                d9 = weightedObservedPointArray[i].getX();
                d10 = weightedObservedPointArray[i].getY();
                double d16 = d9 - d14;
                d3 = d10 - d15;
                d2 = d16 * (d15 * d15 + d15 * d10 + d10 * d10) / 3.0;
                d = d3 * d3 / d16;
                double d17 = d9 - d13;
                d4 += d17 * d17;
                d5 += (d11 += d2) * d11;
                d6 += d17 * d11;
                d7 += d17 * (d12 += d);
                d8 += d11 * d12;
            }
            double d18 = d5 * d7 - d6 * d8;
            double d19 = d6 * d7 - d4 * d8;
            double d20 = d4 * d5 - d6 * d6;
            if (d18 / d19 < 0.0 || d19 / d20 < 0.0) {
                int n = weightedObservedPointArray.length - 1;
                d3 = weightedObservedPointArray[n].getX() - weightedObservedPointArray[0].getX();
                if (d3 == 0.0) {
                    throw new ZeroException();
                }
                dArray[1] = Math.PI * 2 / d3;
                d2 = Double.POSITIVE_INFINITY;
                d = Double.NEGATIVE_INFINITY;
                for (int i = 1; i < weightedObservedPointArray.length; ++i) {
                    double d21 = weightedObservedPointArray[i].getY();
                    if (d21 < d2) {
                        d2 = d21;
                    }
                    if (!(d21 > d)) continue;
                    d = d21;
                }
                dArray[0] = 0.5 * (d - d2);
            } else {
                if (d19 == 0.0) {
                    throw new MathIllegalStateException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
                }
                dArray[0] = FastMath.sqrt(d18 / d19);
                dArray[1] = FastMath.sqrt(d19 / d20);
            }
            return dArray;
        }

        private double guessPhi(WeightedObservedPoint[] weightedObservedPointArray) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = weightedObservedPointArray[0].getX();
            double d4 = weightedObservedPointArray[0].getY();
            for (int i = 1; i < weightedObservedPointArray.length; ++i) {
                double d5 = d3;
                double d6 = d4;
                d3 = weightedObservedPointArray[i].getX();
                d4 = weightedObservedPointArray[i].getY();
                double d7 = (d4 - d6) / (d3 - d5);
                double d8 = this.omega * d3;
                double d9 = FastMath.cos(d8);
                double d10 = FastMath.sin(d8);
                d += this.omega * d4 * d9 - d7 * d10;
                d2 += this.omega * d4 * d10 + d7 * d9;
            }
            return FastMath.atan2(-d2, d);
        }
    }
}

