/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;

public abstract class AbstractEvaluation
implements LeastSquaresProblem.Evaluation {
    private final int observationSize;

    AbstractEvaluation(int n) {
        this.observationSize = n;
    }

    public RealMatrix getCovariances(double d) {
        RealMatrix realMatrix = this.getJacobian();
        RealMatrix realMatrix2 = realMatrix.transpose().multiply(realMatrix);
        DecompositionSolver decompositionSolver = new QRDecomposition(realMatrix2, d).getSolver();
        return decompositionSolver.getInverse();
    }

    public RealVector getSigma(double d) {
        RealMatrix realMatrix = this.getCovariances(d);
        int n = realMatrix.getColumnDimension();
        ArrayRealVector arrayRealVector = new ArrayRealVector(n);
        for (int i = 0; i < n; ++i) {
            ((RealVector)arrayRealVector).setEntry(i, FastMath.sqrt(realMatrix.getEntry(i, i)));
        }
        return arrayRealVector;
    }

    public double getRMS() {
        double d = this.getCost();
        return FastMath.sqrt(d * d / (double)this.observationSize);
    }

    public double getCost() {
        ArrayRealVector arrayRealVector = new ArrayRealVector(this.getResiduals());
        return FastMath.sqrt(arrayRealVector.dotProduct(arrayRealVector));
    }
}

