/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationRmsChecker
implements ConvergenceChecker<LeastSquaresProblem.Evaluation> {
    private final double relTol;
    private final double absTol;

    public EvaluationRmsChecker(double d) {
        this(d, d);
    }

    public EvaluationRmsChecker(double d, double d2) {
        this.relTol = d;
        this.absTol = d2;
    }

    @Override
    public boolean converged(int n, LeastSquaresProblem.Evaluation evaluation, LeastSquaresProblem.Evaluation evaluation2) {
        double d;
        double d2 = evaluation.getRMS();
        return Precision.equals(d2, d = evaluation2.getRMS(), this.absTol) || Precision.equalsWithRelativeTolerance(d2, d, this.relTol);
    }
}

