/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fitting.leastsquares.AbstractEvaluation;
import org.apache.commons.math3.fitting.leastsquares.DenseWeightedEvaluation;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresAdapter;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math3.fitting.leastsquares.ParameterValidator;
import org.apache.commons.math3.fitting.leastsquares.ValueAndJacobianFunction;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optim.AbstractOptimizationProblem;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeastSquaresFactory {
    private LeastSquaresFactory() {
    }

    public static LeastSquaresProblem create(MultivariateJacobianFunction multivariateJacobianFunction, RealVector realVector, RealVector realVector2, RealMatrix realMatrix, ConvergenceChecker<LeastSquaresProblem.Evaluation> convergenceChecker, int n, int n2, boolean bl, ParameterValidator parameterValidator) {
        LocalLeastSquaresProblem localLeastSquaresProblem = new LocalLeastSquaresProblem(multivariateJacobianFunction, realVector, realVector2, convergenceChecker, n, n2, bl, parameterValidator);
        if (realMatrix != null) {
            return LeastSquaresFactory.weightMatrix(localLeastSquaresProblem, realMatrix);
        }
        return localLeastSquaresProblem;
    }

    public static LeastSquaresProblem create(MultivariateJacobianFunction multivariateJacobianFunction, RealVector realVector, RealVector realVector2, ConvergenceChecker<LeastSquaresProblem.Evaluation> convergenceChecker, int n, int n2) {
        return LeastSquaresFactory.create(multivariateJacobianFunction, realVector, realVector2, null, convergenceChecker, n, n2, false, null);
    }

    public static LeastSquaresProblem create(MultivariateJacobianFunction multivariateJacobianFunction, RealVector realVector, RealVector realVector2, RealMatrix realMatrix, ConvergenceChecker<LeastSquaresProblem.Evaluation> convergenceChecker, int n, int n2) {
        return LeastSquaresFactory.weightMatrix(LeastSquaresFactory.create(multivariateJacobianFunction, realVector, realVector2, convergenceChecker, n, n2), realMatrix);
    }

    public static LeastSquaresProblem create(MultivariateVectorFunction multivariateVectorFunction, MultivariateMatrixFunction multivariateMatrixFunction, double[] dArray, double[] dArray2, RealMatrix realMatrix, ConvergenceChecker<LeastSquaresProblem.Evaluation> convergenceChecker, int n, int n2) {
        return LeastSquaresFactory.create(LeastSquaresFactory.model(multivariateVectorFunction, multivariateMatrixFunction), new ArrayRealVector(dArray, false), new ArrayRealVector(dArray2, false), realMatrix, convergenceChecker, n, n2);
    }

    public static LeastSquaresProblem weightMatrix(LeastSquaresProblem leastSquaresProblem, RealMatrix realMatrix) {
        final RealMatrix realMatrix2 = LeastSquaresFactory.squareRoot(realMatrix);
        return new LeastSquaresAdapter(leastSquaresProblem){

            public LeastSquaresProblem.Evaluation evaluate(RealVector realVector) {
                return new DenseWeightedEvaluation(super.evaluate(realVector), realMatrix2);
            }
        };
    }

    public static LeastSquaresProblem weightDiagonal(LeastSquaresProblem leastSquaresProblem, RealVector realVector) {
        return LeastSquaresFactory.weightMatrix(leastSquaresProblem, new DiagonalMatrix(realVector.toArray()));
    }

    public static LeastSquaresProblem countEvaluations(LeastSquaresProblem leastSquaresProblem, final Incrementor incrementor) {
        return new LeastSquaresAdapter(leastSquaresProblem){

            public LeastSquaresProblem.Evaluation evaluate(RealVector realVector) {
                incrementor.incrementCount();
                return super.evaluate(realVector);
            }
        };
    }

    public static ConvergenceChecker<LeastSquaresProblem.Evaluation> evaluationChecker(final ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        return new ConvergenceChecker<LeastSquaresProblem.Evaluation>(){

            @Override
            public boolean converged(int n, LeastSquaresProblem.Evaluation evaluation, LeastSquaresProblem.Evaluation evaluation2) {
                return convergenceChecker.converged(n, new PointVectorValuePair(evaluation.getPoint().toArray(), evaluation.getResiduals().toArray(), false), new PointVectorValuePair(evaluation2.getPoint().toArray(), evaluation2.getResiduals().toArray(), false));
            }
        };
    }

    private static RealMatrix squareRoot(RealMatrix realMatrix) {
        if (realMatrix instanceof DiagonalMatrix) {
            int n = realMatrix.getRowDimension();
            DiagonalMatrix diagonalMatrix = new DiagonalMatrix(n);
            for (int i = 0; i < n; ++i) {
                diagonalMatrix.setEntry(i, i, FastMath.sqrt(realMatrix.getEntry(i, i)));
            }
            return diagonalMatrix;
        }
        EigenDecomposition eigenDecomposition = new EigenDecomposition(realMatrix);
        return eigenDecomposition.getSquareRoot();
    }

    public static MultivariateJacobianFunction model(MultivariateVectorFunction multivariateVectorFunction, MultivariateMatrixFunction multivariateMatrixFunction) {
        return new LocalValueAndJacobianFunction(multivariateVectorFunction, multivariateMatrixFunction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalLeastSquaresProblem
    extends AbstractOptimizationProblem<LeastSquaresProblem.Evaluation>
    implements LeastSquaresProblem {
        private final RealVector target;
        private final MultivariateJacobianFunction model;
        private final RealVector start;
        private final boolean lazyEvaluation;
        private final ParameterValidator paramValidator;

        LocalLeastSquaresProblem(MultivariateJacobianFunction multivariateJacobianFunction, RealVector realVector, RealVector realVector2, ConvergenceChecker<LeastSquaresProblem.Evaluation> convergenceChecker, int n, int n2, boolean bl, ParameterValidator parameterValidator) {
            super(n, n2, convergenceChecker);
            this.target = realVector;
            this.model = multivariateJacobianFunction;
            this.start = realVector2;
            this.lazyEvaluation = bl;
            this.paramValidator = parameterValidator;
            if (bl && !(multivariateJacobianFunction instanceof ValueAndJacobianFunction)) {
                throw new MathIllegalStateException(LocalizedFormats.INVALID_IMPLEMENTATION, multivariateJacobianFunction.getClass().getName());
            }
        }

        @Override
        public int getObservationSize() {
            return this.target.getDimension();
        }

        @Override
        public int getParameterSize() {
            return this.start.getDimension();
        }

        @Override
        public RealVector getStart() {
            return this.start == null ? null : this.start.copy();
        }

        @Override
        public LeastSquaresProblem.Evaluation evaluate(RealVector realVector) {
            RealVector realVector2;
            RealVector realVector3 = realVector2 = this.paramValidator == null ? realVector.copy() : this.paramValidator.validate(realVector.copy());
            if (this.lazyEvaluation) {
                return new LazyUnweightedEvaluation((ValueAndJacobianFunction)this.model, this.target, realVector2);
            }
            Pair<RealVector, RealMatrix> pair = this.model.value(realVector2);
            return new UnweightedEvaluation(pair.getFirst(), pair.getSecond(), this.target, realVector2);
        }

        private static class LazyUnweightedEvaluation
        extends AbstractEvaluation {
            private final RealVector point;
            private final ValueAndJacobianFunction model;
            private final RealVector target;

            private LazyUnweightedEvaluation(ValueAndJacobianFunction valueAndJacobianFunction, RealVector realVector, RealVector realVector2) {
                super(realVector.getDimension());
                this.model = valueAndJacobianFunction;
                this.point = realVector2;
                this.target = realVector;
            }

            public RealMatrix getJacobian() {
                return this.model.computeJacobian(this.point.toArray());
            }

            public RealVector getPoint() {
                return this.point;
            }

            public RealVector getResiduals() {
                return this.target.subtract(this.model.computeValue(this.point.toArray()));
            }
        }

        private static class UnweightedEvaluation
        extends AbstractEvaluation {
            private final RealVector point;
            private final RealMatrix jacobian;
            private final RealVector residuals;

            private UnweightedEvaluation(RealVector realVector, RealMatrix realMatrix, RealVector realVector2, RealVector realVector3) {
                super(realVector2.getDimension());
                this.jacobian = realMatrix;
                this.point = realVector3;
                this.residuals = realVector2.subtract(realVector);
            }

            public RealMatrix getJacobian() {
                return this.jacobian;
            }

            public RealVector getPoint() {
                return this.point;
            }

            public RealVector getResiduals() {
                return this.residuals;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalValueAndJacobianFunction
    implements ValueAndJacobianFunction {
        private final MultivariateVectorFunction value;
        private final MultivariateMatrixFunction jacobian;

        LocalValueAndJacobianFunction(MultivariateVectorFunction multivariateVectorFunction, MultivariateMatrixFunction multivariateMatrixFunction) {
            this.value = multivariateVectorFunction;
            this.jacobian = multivariateMatrixFunction;
        }

        @Override
        public Pair<RealVector, RealMatrix> value(RealVector realVector) {
            double[] dArray = realVector.toArray();
            return new Pair<RealVector, RealMatrix>(this.computeValue(dArray), this.computeJacobian(dArray));
        }

        @Override
        public RealVector computeValue(double[] dArray) {
            return new ArrayRealVector(this.value.value(dArray), false);
        }

        @Override
        public RealMatrix computeJacobian(double[] dArray) {
            return new Array2DRowRealMatrix(this.jacobian.value(dArray), false);
        }
    }
}

