/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import java.util.Arrays;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.fitting.leastsquares.OptimumImpl;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Incrementor;
import org.apache.commons.math3.util.Precision;

public class LevenbergMarquardtOptimizer
implements LeastSquaresOptimizer {
    private static final double TWO_EPS = 2.0 * Precision.EPSILON;
    private final double initialStepBoundFactor;
    private final double costRelativeTolerance;
    private final double parRelativeTolerance;
    private final double orthoTolerance;
    private final double qrRankingThreshold;

    public LevenbergMarquardtOptimizer() {
        this(100.0, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double d, double d2, double d3, double d4, double d5) {
        this.initialStepBoundFactor = d;
        this.costRelativeTolerance = d2;
        this.parRelativeTolerance = d3;
        this.orthoTolerance = d4;
        this.qrRankingThreshold = d5;
    }

    public LevenbergMarquardtOptimizer withInitialStepBoundFactor(double d) {
        return new LevenbergMarquardtOptimizer(d, this.costRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withCostRelativeTolerance(double d) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, d, this.parRelativeTolerance, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withParameterRelativeTolerance(double d) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, d, this.orthoTolerance, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withOrthoTolerance(double d) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, d, this.qrRankingThreshold);
    }

    public LevenbergMarquardtOptimizer withRankingThreshold(double d) {
        return new LevenbergMarquardtOptimizer(this.initialStepBoundFactor, this.costRelativeTolerance, this.parRelativeTolerance, this.orthoTolerance, d);
    }

    public double getInitialStepBoundFactor() {
        return this.initialStepBoundFactor;
    }

    public double getCostRelativeTolerance() {
        return this.costRelativeTolerance;
    }

    public double getParameterRelativeTolerance() {
        return this.parRelativeTolerance;
    }

    public double getOrthoTolerance() {
        return this.orthoTolerance;
    }

    public double getRankingThreshold() {
        return this.qrRankingThreshold;
    }

    public LeastSquaresOptimizer.Optimum optimize(LeastSquaresProblem leastSquaresProblem) {
        int n = leastSquaresProblem.getObservationSize();
        int n2 = leastSquaresProblem.getParameterSize();
        Incrementor incrementor = leastSquaresProblem.getIterationCounter();
        Incrementor incrementor2 = leastSquaresProblem.getEvaluationCounter();
        ConvergenceChecker<LeastSquaresProblem.Evaluation> convergenceChecker = leastSquaresProblem.getConvergenceChecker();
        int n3 = FastMath.min(n, n2);
        double[] dArray = new double[n2];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        incrementor2.incrementCount();
        LeastSquaresProblem.Evaluation evaluation = leastSquaresProblem.evaluate(leastSquaresProblem.getStart());
        double[] dArray9 = evaluation.getResiduals().toArray();
        double d4 = evaluation.getCost();
        double[] dArray10 = evaluation.getPoint().toArray();
        boolean bl = true;
        block0: while (true) {
            double d5;
            int n4;
            int n5;
            incrementor.incrementCount();
            LeastSquaresProblem.Evaluation evaluation2 = evaluation;
            InternalData internalData = this.qrDecomposition(evaluation.getJacobian(), n3);
            double[][] dArray11 = internalData.weightedJacobian;
            int[] nArray = internalData.permutation;
            double[] dArray12 = internalData.diagR;
            double[] dArray13 = internalData.jacNorm;
            double[] dArray14 = dArray9;
            for (n5 = 0; n5 < n; ++n5) {
                dArray5[n5] = dArray14[n5];
            }
            this.qTy(dArray5, internalData);
            for (n5 = 0; n5 < n3; ++n5) {
                int n6 = nArray[n5];
                dArray11[n5][n6] = dArray12[n6];
            }
            if (bl) {
                d3 = 0.0;
                for (n5 = 0; n5 < n2; ++n5) {
                    double d6 = dArray13[n5];
                    if (d6 == 0.0) {
                        d6 = 1.0;
                    }
                    double d7 = d6 * dArray10[n5];
                    d3 += d7 * d7;
                    dArray2[n5] = d6;
                }
                d2 = (d3 = FastMath.sqrt(d3)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * d3;
            }
            double d8 = 0.0;
            if (d4 != 0.0) {
                for (n4 = 0; n4 < n3; ++n4) {
                    int n7 = nArray[n4];
                    d5 = dArray13[n7];
                    if (d5 == 0.0) continue;
                    double d9 = 0.0;
                    for (int i = 0; i <= n4; ++i) {
                        d9 += dArray11[i][n7] * dArray5[i];
                    }
                    d8 = FastMath.max(d8, FastMath.abs(d9) / (d5 * d4));
                }
            }
            if (d8 <= this.orthoTolerance) {
                return new OptimumImpl(evaluation, incrementor2.getCount(), incrementor.getCount());
            }
            for (n4 = 0; n4 < n2; ++n4) {
                dArray2[n4] = FastMath.max(dArray2[n4], dArray13[n4]);
            }
            double d10 = 0.0;
            do {
                int n8;
                double d11;
                double d12;
                if (!(d10 < 1.0E-4)) continue block0;
                for (int i = 0; i < n3; ++i) {
                    int n9 = nArray[i];
                    dArray3[n9] = dArray10[n9];
                }
                d5 = d4;
                double[] dArray15 = dArray14;
                dArray14 = dArray4;
                dArray4 = dArray15;
                d = this.determineLMParameter(dArray5, d2, dArray2, internalData, n3, dArray6, dArray7, dArray8, dArray, d);
                double d13 = 0.0;
                for (int i = 0; i < n3; ++i) {
                    int n10 = nArray[i];
                    dArray[n10] = -dArray[n10];
                    dArray10[n10] = dArray3[n10] + dArray[n10];
                    d12 = dArray2[n10] * dArray[n10];
                    d13 += d12 * d12;
                }
                d13 = FastMath.sqrt(d13);
                if (bl) {
                    d2 = FastMath.min(d2, d13);
                }
                incrementor2.incrementCount();
                evaluation = leastSquaresProblem.evaluate(new ArrayRealVector(dArray10));
                dArray9 = evaluation.getResiduals().toArray();
                d4 = evaluation.getCost();
                dArray10 = evaluation.getPoint().toArray();
                double d14 = -1.0;
                if (0.1 * d4 < d5) {
                    d12 = d4 / d5;
                    d14 = 1.0 - d12 * d12;
                }
                for (int i = 0; i < n3; ++i) {
                    int n11 = nArray[i];
                    d11 = dArray[n11];
                    dArray6[i] = 0.0;
                    for (int j = 0; j <= i; ++j) {
                        int n12 = j;
                        dArray6[n12] = dArray6[n12] + dArray11[j][n11] * d11;
                    }
                }
                d12 = 0.0;
                for (int i = 0; i < n3; ++i) {
                    d12 += dArray6[i] * dArray6[i];
                }
                d11 = d5 * d5;
                double d15 = d * d13 * d13 / d11;
                double d16 = (d12 /= d11) + 2.0 * d15;
                double d17 = -(d12 + d15);
                double d18 = d10 = d16 == 0.0 ? 0.0 : d14 / d16;
                if (d10 <= 0.25) {
                    double d19;
                    double d20 = d19 = d14 < 0.0 ? 0.5 * d17 / (d17 + 0.5 * d14) : 0.5;
                    if (0.1 * d4 >= d5 || d19 < 0.1) {
                        d19 = 0.1;
                    }
                    d2 = d19 * FastMath.min(d2, 10.0 * d13);
                    d /= d19;
                } else if (d == 0.0 || d10 >= 0.75) {
                    d2 = 2.0 * d13;
                    d *= 0.5;
                }
                if (d10 >= 1.0E-4) {
                    bl = false;
                    d3 = 0.0;
                    for (n8 = 0; n8 < n2; ++n8) {
                        double d21 = dArray2[n8] * dArray10[n8];
                        d3 += d21 * d21;
                    }
                    d3 = FastMath.sqrt(d3);
                    if (convergenceChecker != null && convergenceChecker.converged(incrementor.getCount(), evaluation2, evaluation)) {
                        return new OptimumImpl(evaluation, incrementor2.getCount(), incrementor.getCount());
                    }
                } else {
                    d4 = d5;
                    for (n8 = 0; n8 < n3; ++n8) {
                        int n13 = nArray[n8];
                        dArray10[n13] = dArray3[n13];
                    }
                    dArray15 = dArray14;
                    dArray14 = dArray4;
                    dArray4 = dArray15;
                    evaluation = evaluation2;
                }
                if (FastMath.abs(d14) <= this.costRelativeTolerance && d16 <= this.costRelativeTolerance && d10 <= 2.0 || d2 <= this.parRelativeTolerance * d3) {
                    return new OptimumImpl(evaluation, incrementor2.getCount(), incrementor.getCount());
                }
                if (FastMath.abs(d14) <= TWO_EPS && d16 <= TWO_EPS && d10 <= 2.0) {
                    throw new ConvergenceException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, this.costRelativeTolerance);
                }
                if (!(d2 <= TWO_EPS * d3)) continue;
                throw new ConvergenceException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, this.parRelativeTolerance);
            } while (!(d8 <= TWO_EPS));
            break;
        }
        throw new ConvergenceException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, this.orthoTolerance);
    }

    private double determineLMParameter(double[] dArray, double d, double[] dArray2, InternalData internalData, int n, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double d2) {
        double d3;
        int n2;
        int n3;
        int n4;
        double[][] dArray7 = internalData.weightedJacobian;
        int[] nArray = internalData.permutation;
        int n5 = internalData.rank;
        double[] dArray8 = internalData.diagR;
        int n6 = dArray7[0].length;
        for (n4 = 0; n4 < n5; ++n4) {
            dArray6[nArray[n4]] = dArray[n4];
        }
        for (n4 = n5; n4 < n6; ++n4) {
            dArray6[nArray[n4]] = 0.0;
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            int n7 = nArray[n4];
            double d4 = dArray6[n7] / dArray8[n7];
            for (int i = 0; i < n4; ++i) {
                int n8 = nArray[i];
                dArray6[n8] = dArray6[n8] - d4 * dArray7[i][n7];
            }
            dArray6[n7] = d4;
        }
        double d5 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d6;
            int n9 = nArray[i];
            dArray3[n9] = d6 = dArray2[n9] * dArray6[n9];
            d5 += d6 * d6;
        }
        double d7 = (d5 = FastMath.sqrt(d5)) - d;
        if (d7 <= 0.1 * d) {
            d2 = 0.0;
            return d2;
        }
        double d8 = 0.0;
        if (n5 == n) {
            for (n3 = 0; n3 < n; ++n3) {
                int n10 = n2 = nArray[n3];
                dArray3[n10] = dArray3[n10] * (dArray2[n2] / d5);
            }
            double d9 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                double d10;
                n2 = nArray[n3];
                d3 = 0.0;
                for (int i = 0; i < n3; ++i) {
                    d3 += dArray7[i][n2] * dArray3[nArray[i]];
                }
                dArray3[n2] = d10 = (dArray3[n2] - d3) / dArray8[n2];
                d9 += d10 * d10;
            }
            d8 = d7 / (d * d9);
        }
        double d11 = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            d3 = 0.0;
            for (int i = 0; i <= n3; ++i) {
                d3 += dArray7[i][n2] * dArray[i];
            }
            d11 += (d3 /= dArray2[n2]) * d3;
        }
        double d12 = FastMath.sqrt(d11);
        d3 = d12 / d;
        if (d3 == 0.0) {
            d3 = Precision.SAFE_MIN / FastMath.min(d, 0.1);
        }
        if ((d2 = FastMath.min(d3, FastMath.max(d2, d8))) == 0.0) {
            d2 = d12 / d5;
        }
        for (int i = 10; i >= 0; --i) {
            int n11;
            int n12;
            double d13;
            int n13;
            int n14;
            if (d2 == 0.0) {
                d2 = FastMath.max(Precision.SAFE_MIN, 0.001 * d3);
            }
            double d14 = FastMath.sqrt(d2);
            for (n14 = 0; n14 < n; ++n14) {
                n13 = nArray[n14];
                dArray3[n13] = d14 * dArray2[n13];
            }
            this.determineLMDirection(dArray, dArray3, dArray4, internalData, n, dArray5, dArray6);
            d5 = 0.0;
            for (n14 = 0; n14 < n; ++n14) {
                n13 = nArray[n14];
                dArray5[n13] = d13 = dArray2[n13] * dArray6[n13];
                d5 += d13 * d13;
            }
            d5 = FastMath.sqrt(d5);
            double d15 = d7;
            d7 = d5 - d;
            if (FastMath.abs(d7) <= 0.1 * d || d8 == 0.0 && d7 <= d15 && d15 < 0.0) {
                return d2;
            }
            for (n12 = 0; n12 < n; ++n12) {
                n11 = nArray[n12];
                dArray3[n11] = dArray5[n11] * dArray2[n11] / d5;
            }
            for (n12 = 0; n12 < n; ++n12) {
                int n15 = n11 = nArray[n12];
                dArray3[n15] = dArray3[n15] / dArray4[n12];
                double d16 = dArray3[n11];
                for (int j = n12 + 1; j < n; ++j) {
                    int n16 = nArray[j];
                    dArray3[n16] = dArray3[n16] - dArray7[j][n11] * d16;
                }
            }
            d11 = 0.0;
            for (n12 = 0; n12 < n; ++n12) {
                double d17 = dArray3[nArray[n12]];
                d11 += d17 * d17;
            }
            d13 = d7 / (d * d11);
            if (d7 > 0.0) {
                d8 = FastMath.max(d8, d2);
            } else if (d7 < 0.0) {
                d3 = FastMath.min(d3, d2);
            }
            d2 = FastMath.max(d8, d2 + d13);
        }
        return d2;
    }

    private void determineLMDirection(double[] dArray, double[] dArray2, double[] dArray3, InternalData internalData, int n, double[] dArray4, double[] dArray5) {
        int n2;
        int n3;
        int[] nArray = internalData.permutation;
        double[][] dArray6 = internalData.weightedJacobian;
        double[] dArray7 = internalData.diagR;
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            for (int i = n3 + 1; i < n; ++i) {
                dArray6[i][n2] = dArray6[n3][nArray[i]];
            }
            dArray5[n3] = dArray7[n2];
            dArray4[n3] = dArray[n3];
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = nArray[n3];
            double d = dArray2[n2];
            if (d != 0.0) {
                Arrays.fill(dArray3, n3 + 1, dArray3.length, 0.0);
            }
            dArray3[n3] = d;
            double d2 = 0.0;
            for (int i = n3; i < n; ++i) {
                double d3;
                double d4;
                double d5;
                int n4 = nArray[i];
                if (dArray3[i] == 0.0) continue;
                double d6 = dArray6[i][n4];
                if (FastMath.abs(d6) < FastMath.abs(dArray3[i])) {
                    d5 = d6 / dArray3[i];
                    d4 = 1.0 / FastMath.sqrt(1.0 + d5 * d5);
                    d3 = d4 * d5;
                } else {
                    d5 = dArray3[i] / d6;
                    d3 = 1.0 / FastMath.sqrt(1.0 + d5 * d5);
                    d4 = d3 * d5;
                }
                dArray6[i][n4] = d3 * d6 + d4 * dArray3[i];
                d5 = d3 * dArray4[i] + d4 * d2;
                d2 = -d4 * dArray4[i] + d3 * d2;
                dArray4[i] = d5;
                for (int j = i + 1; j < n; ++j) {
                    double d7 = dArray6[j][n4];
                    double d8 = d3 * d7 + d4 * dArray3[j];
                    dArray3[j] = -d4 * d7 + d3 * dArray3[j];
                    dArray6[j][n4] = d8;
                }
            }
            dArray3[n3] = dArray6[n3][nArray[n3]];
            dArray6[n3][nArray[n3]] = dArray5[n3];
        }
        n3 = n;
        for (n2 = 0; n2 < n; ++n2) {
            if (dArray3[n2] == 0.0 && n3 == n) {
                n3 = n2;
            }
            if (n3 >= n) continue;
            dArray4[n2] = 0.0;
        }
        if (n3 > 0) {
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                int n5 = nArray[n2];
                double d = 0.0;
                for (int i = n2 + 1; i < n3; ++i) {
                    d += dArray6[i][n5] * dArray4[i];
                }
                dArray4[n2] = (dArray4[n2] - d) / dArray3[n2];
            }
        }
        for (n2 = 0; n2 < dArray5.length; ++n2) {
            dArray5[nArray[n2]] = dArray4[n2];
        }
    }

    private InternalData qrDecomposition(RealMatrix realMatrix, int n) {
        int n2;
        double[][] dArray = realMatrix.scalarMultiply(-1.0).getData();
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int[] nArray = new int[n4];
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = n2;
            double d = 0.0;
            for (int i = 0; i < n3; ++i) {
                double d2 = dArray[i][n2];
                d += d2 * d2;
            }
            dArray3[n2] = FastMath.sqrt(d);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            double d;
            double d3;
            int n5;
            int n6 = -1;
            double d4 = Double.NEGATIVE_INFINITY;
            for (n5 = n2; n5 < n4; ++n5) {
                d3 = 0.0;
                for (int i = n2; i < n3; ++i) {
                    double d5 = dArray[i][nArray[n5]];
                    d3 += d5 * d5;
                }
                if (Double.isInfinite(d3) || Double.isNaN(d3)) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, n3, n4);
                }
                if (!(d3 > d4)) continue;
                n6 = n5;
                d4 = d3;
            }
            if (d4 <= this.qrRankingThreshold) {
                return new InternalData(dArray, nArray, n2, dArray2, dArray3, dArray4);
            }
            n5 = nArray[n6];
            nArray[n6] = nArray[n2];
            nArray[n2] = n5;
            d3 = dArray[n2][n5];
            double d6 = d3 > 0.0 ? -FastMath.sqrt(d4) : FastMath.sqrt(d4);
            dArray4[n5] = d = 1.0 / (d4 - d3 * d6);
            dArray2[n5] = d6;
            double[] dArray5 = dArray[n2];
            int n7 = n5;
            dArray5[n7] = dArray5[n7] - d6;
            for (int i = n4 - 1 - n2; i > 0; --i) {
                int n8;
                double d7 = 0.0;
                for (n8 = n2; n8 < n3; ++n8) {
                    d7 += dArray[n8][n5] * dArray[n8][nArray[n2 + i]];
                }
                d7 *= d;
                for (n8 = n2; n8 < n3; ++n8) {
                    double[] dArray6 = dArray[n8];
                    int n9 = nArray[n2 + i];
                    dArray6[n9] = dArray6[n9] - d7 * dArray[n8][n5];
                }
            }
        }
        return new InternalData(dArray, nArray, n, dArray2, dArray3, dArray4);
    }

    private void qTy(double[] dArray, InternalData internalData) {
        double[][] dArray2 = internalData.weightedJacobian;
        int[] nArray = internalData.permutation;
        double[] dArray3 = internalData.beta;
        int n = dArray2.length;
        int n2 = dArray2[0].length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = nArray[i];
            double d = 0.0;
            for (n3 = i; n3 < n; ++n3) {
                d += dArray2[n3][n4] * dArray[n3];
            }
            d *= dArray3[n4];
            for (n3 = i; n3 < n; ++n3) {
                int n5 = n3;
                dArray[n5] = dArray[n5] - d * dArray2[n3][n4];
            }
        }
    }

    private static class InternalData {
        private final double[][] weightedJacobian;
        private final int[] permutation;
        private final int rank;
        private final double[] diagR;
        private final double[] jacNorm;
        private final double[] beta;

        InternalData(double[][] dArray, int[] nArray, int n, double[] dArray2, double[] dArray3, double[] dArray4) {
            this.weightedJacobian = dArray;
            this.permutation = nArray;
            this.rank = n;
            this.diagR = dArray2;
            this.jacNorm = dArray3;
            this.beta = dArray4;
        }
    }
}

