/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fraction;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;

public abstract class AbstractFormat
extends NumberFormat
implements Serializable {
    private static final long serialVersionUID = -6981118387974191891L;
    private NumberFormat denominatorFormat;
    private NumberFormat numeratorFormat;

    protected AbstractFormat() {
        this(AbstractFormat.getDefaultNumberFormat());
    }

    protected AbstractFormat(NumberFormat numberFormat) {
        this(numberFormat, (NumberFormat)numberFormat.clone());
    }

    protected AbstractFormat(NumberFormat numberFormat, NumberFormat numberFormat2) {
        this.numeratorFormat = numberFormat;
        this.denominatorFormat = numberFormat2;
    }

    protected static NumberFormat getDefaultNumberFormat() {
        return AbstractFormat.getDefaultNumberFormat(Locale.getDefault());
    }

    protected static NumberFormat getDefaultNumberFormat(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setParseIntegerOnly(true);
        return numberFormat;
    }

    public NumberFormat getDenominatorFormat() {
        return this.denominatorFormat;
    }

    public NumberFormat getNumeratorFormat() {
        return this.numeratorFormat;
    }

    public void setDenominatorFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.DENOMINATOR_FORMAT, new Object[0]);
        }
        this.denominatorFormat = numberFormat;
    }

    public void setNumeratorFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new NullArgumentException(LocalizedFormats.NUMERATOR_FORMAT, new Object[0]);
        }
        this.numeratorFormat = numberFormat;
    }

    protected static void parseAndIgnoreWhitespace(String string, ParsePosition parsePosition) {
        AbstractFormat.parseNextCharacter(string, parsePosition);
        parsePosition.setIndex(parsePosition.getIndex() - 1);
    }

    protected static char parseNextCharacter(String string, ParsePosition parsePosition) {
        int n = parsePosition.getIndex();
        int n2 = string.length();
        char c = '\u0000';
        if (n < n2) {
            char c2;
            while (Character.isWhitespace(c2 = string.charAt(n++)) && n < n2) {
            }
            parsePosition.setIndex(n);
            if (n < n2) {
                c = c2;
            }
        }
        return c;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((Object)d, stringBuffer, fieldPosition);
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((Object)l, stringBuffer, fieldPosition);
    }
}

