/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.ArrayList;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.AbstractListChromosome;
import org.apache.commons.math3.genetics.BinaryChromosome;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.GeneticAlgorithm;
import org.apache.commons.math3.genetics.MutationPolicy;

public class BinaryMutation
implements MutationPolicy {
    public Chromosome mutate(Chromosome chromosome) {
        if (!(chromosome instanceof BinaryChromosome)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INVALID_BINARY_CHROMOSOME, new Object[0]);
        }
        BinaryChromosome binaryChromosome = (BinaryChromosome)chromosome;
        ArrayList arrayList = new ArrayList(binaryChromosome.getRepresentation());
        int n = GeneticAlgorithm.getRandomGenerator().nextInt(binaryChromosome.getLength());
        arrayList.set(n, (Integer)binaryChromosome.getRepresentation().get(n) == 0 ? 1 : 0);
        AbstractListChromosome abstractListChromosome = binaryChromosome.newFixedLengthChromosome(arrayList);
        return abstractListChromosome;
    }
}

