/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import org.apache.commons.math3.genetics.Fitness;
import org.apache.commons.math3.genetics.Population;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Chromosome
implements Comparable<Chromosome>,
Fitness {
    private static final double NO_FITNESS = Double.NEGATIVE_INFINITY;
    private double fitness = Double.NEGATIVE_INFINITY;

    public double getFitness() {
        if (this.fitness == Double.NEGATIVE_INFINITY) {
            this.fitness = this.fitness();
        }
        return this.fitness;
    }

    @Override
    public int compareTo(Chromosome chromosome) {
        return Double.compare(this.getFitness(), chromosome.getFitness());
    }

    protected boolean isSame(Chromosome chromosome) {
        return false;
    }

    protected Chromosome findSameChromosome(Population population) {
        for (Chromosome chromosome : population) {
            if (!this.isSame(chromosome)) continue;
            return chromosome;
        }
        return null;
    }

    public void searchForFitnessUpdate(Population population) {
        Chromosome chromosome = this.findSameChromosome(population);
        if (chromosome != null) {
            this.fitness = chromosome.getFitness();
        }
    }
}

