/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.commons.math3.genetics.ListPopulation;
import org.apache.commons.math3.genetics.Population;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElitisticListPopulation
extends ListPopulation {
    private double elitismRate = 0.9;

    public ElitisticListPopulation(List<Chromosome> list, int n, double d) {
        super(list, n);
        this.setElitismRate(d);
    }

    public ElitisticListPopulation(int n, double d) {
        super(n);
        this.setElitismRate(d);
    }

    @Override
    public Population nextGeneration() {
        int n;
        ElitisticListPopulation elitisticListPopulation = new ElitisticListPopulation(this.getPopulationLimit(), this.getElitismRate());
        List<Chromosome> list = this.getChromosomeList();
        Collections.sort(list);
        for (int i = n = (int)FastMath.ceil((1.0 - this.getElitismRate()) * (double)list.size()); i < list.size(); ++i) {
            elitisticListPopulation.addChromosome(list.get(i));
        }
        return elitisticListPopulation;
    }

    public void setElitismRate(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ELITISM_RATE, (Number)d, 0, 1);
        }
        this.elitismRate = d;
    }

    public double getElitismRate() {
        return this.elitismRate;
    }
}

