/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.genetics;

import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.genetics.ChromosomePair;
import org.apache.commons.math3.genetics.CrossoverPolicy;
import org.apache.commons.math3.genetics.MutationPolicy;
import org.apache.commons.math3.genetics.Population;
import org.apache.commons.math3.genetics.SelectionPolicy;
import org.apache.commons.math3.genetics.StoppingCondition;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;

public class GeneticAlgorithm {
    private static RandomGenerator randomGenerator = new JDKRandomGenerator();
    private final CrossoverPolicy crossoverPolicy;
    private final double crossoverRate;
    private final MutationPolicy mutationPolicy;
    private final double mutationRate;
    private final SelectionPolicy selectionPolicy;
    private int generationsEvolved = 0;

    public GeneticAlgorithm(CrossoverPolicy crossoverPolicy, double d, MutationPolicy mutationPolicy, double d2, SelectionPolicy selectionPolicy) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.CROSSOVER_RATE, (Number)d, 0, 1);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.MUTATION_RATE, (Number)d2, 0, 1);
        }
        this.crossoverPolicy = crossoverPolicy;
        this.crossoverRate = d;
        this.mutationPolicy = mutationPolicy;
        this.mutationRate = d2;
        this.selectionPolicy = selectionPolicy;
    }

    public static synchronized void setRandomGenerator(RandomGenerator randomGenerator) {
        GeneticAlgorithm.randomGenerator = randomGenerator;
    }

    public static synchronized RandomGenerator getRandomGenerator() {
        return randomGenerator;
    }

    public Population evolve(Population population, StoppingCondition stoppingCondition) {
        Population population2 = population;
        this.generationsEvolved = 0;
        while (!stoppingCondition.isSatisfied(population2)) {
            population2 = this.nextGeneration(population2);
            ++this.generationsEvolved;
        }
        return population2;
    }

    public Population nextGeneration(Population population) {
        Population population2 = population.nextGeneration();
        RandomGenerator randomGenerator = GeneticAlgorithm.getRandomGenerator();
        while (population2.getPopulationSize() < population2.getPopulationLimit()) {
            ChromosomePair chromosomePair = this.getSelectionPolicy().select(population);
            if (randomGenerator.nextDouble() < this.getCrossoverRate()) {
                chromosomePair = this.getCrossoverPolicy().crossover(chromosomePair.getFirst(), chromosomePair.getSecond());
            }
            if (randomGenerator.nextDouble() < this.getMutationRate()) {
                chromosomePair = new ChromosomePair(this.getMutationPolicy().mutate(chromosomePair.getFirst()), this.getMutationPolicy().mutate(chromosomePair.getSecond()));
            }
            population2.addChromosome(chromosomePair.getFirst());
            if (population2.getPopulationSize() >= population2.getPopulationLimit()) continue;
            population2.addChromosome(chromosomePair.getSecond());
        }
        return population2;
    }

    public CrossoverPolicy getCrossoverPolicy() {
        return this.crossoverPolicy;
    }

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    public MutationPolicy getMutationPolicy() {
        return this.mutationPolicy;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public SelectionPolicy getSelectionPolicy() {
        return this.selectionPolicy;
    }

    public int getGenerationsEvolved() {
        return this.generationsEvolved;
    }
}

